/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ui.tests.text.indenting;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.ruby.internal.ui.RubyPreferenceConstants;
import org.eclipse.dltk.ruby.internal.ui.text.RubyAutoEditStrategy;
import org.eclipse.dltk.ruby.ui.tests.internal.TestUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.DocCmd;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;

public class IndentingTest
extends SuiteOfTestCases {
    private static final String PATH = "resources/indenting/";
    private RubyAutoEditStrategy tabStrategy;
    private RubyAutoEditStrategy spaceStrategy;

    public IndentingTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.tabStrategy = this.createStrategy(true);
        this.spaceStrategy = this.createStrategy(false);
        super.setUp();
    }

    private RubyAutoEditStrategy createStrategy(boolean useTabs) {
        PreferenceStore store = new PreferenceStore();
        store.setValue("formatter.tabulation.char", useTabs ? "tab" : "space");
        RubyPreferenceConstants.initializeDefaultValues((IPreferenceStore)store);
        String partitioning = "__ruby_partitioning";
        RubyAutoEditStrategy result = new RubyAutoEditStrategy((IPreferenceStore)store, partitioning);
        return result;
    }

    public void doTest(String data, RubyAutoEditStrategy strategy) throws Exception {
        int endPos;
        int startPos = (data = data.replaceAll("\u00cf\u0080", "\u00e2\u0089\u00a4\n\u00e2\u0089\u00a5")).indexOf("\u00e2\u0089\u00a4");
        Assert.isLegal((startPos >= 0 ? 1 : 0) != 0);
        data = String.valueOf(data.substring(0, startPos)) + data.substring(startPos + 1);
        int replacePos = data.indexOf("\u00c2\u00b1");
        int insertionStartPos = startPos;
        if (replacePos >= 0) {
            Assert.isLegal((replacePos >= startPos ? 1 : 0) != 0);
            data = String.valueOf(data.substring(0, replacePos)) + data.substring(replacePos + 1);
            insertionStartPos = replacePos;
        }
        Assert.isLegal(((endPos = data.indexOf("\u00e2\u0089\u00a5")) >= 0 ? 1 : 0) != 0);
        Assert.isLegal((replacePos < 0 || endPos >= replacePos ? 1 : 0) != 0);
        String insertion = data.substring(insertionStartPos, endPos);
        data = String.valueOf(data.substring(0, insertionStartPos)) + data.substring(endPos + 1);
        int expectedPos = data.indexOf("\u00c2\u00a7\u00c2\u00a7");
        Assert.isLegal((expectedPos >= 0 ? 1 : 0) != 0);
        String expected = data.substring(expectedPos + 2);
        data = data.substring(0, expectedPos);
        Document doc = new Document(data);
        TestUtils.installStuff(doc);
        String[] legalLineDelimiters = doc.getLegalLineDelimiters();
        int index = TextUtilities.startsWith((String[])legalLineDelimiters, (String)expected);
        Assert.isLegal((index >= 0 ? 1 : 0) != 0);
        expected = expected.substring(legalLineDelimiters[index].length());
        int replaceLength = replacePos < 0 ? 0 : replacePos - startPos;
        DocCmd cmd = new DocCmd(startPos, replaceLength, insertion);
        strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)cmd);
        if (cmd.doit) {
            doc.replace(cmd.offset, cmd.length, cmd.text);
        }
        IndentingTest.assertEquals((String)expected, (String)doc.get());
    }

    private void magic() throws Exception {
        String name = this.getName();
        String fileName = String.valueOf(name.substring(4, 5).toLowerCase()) + name.substring(5) + ".rb";
        String data = TestUtils.getData(PATH + fileName);
        String moreData = data.replaceAll("\t", "    ");
        if (!moreData.equals(data)) {
            this.doTest(moreData, this.spaceStrategy);
        }
        this.doTest(data, this.tabStrategy);
    }

    public void testNewLineInDef() throws Exception {
        this.magic();
    }

    public void testEnterBeforeClass() throws Exception {
        this.magic();
    }

    public void testEnterOpensClass() throws Exception {
        this.magic();
    }

    public void testIfStatement() throws Exception {
        this.magic();
    }

    public void testIfModifier() throws Exception {
        this.magic();
    }

    public void testMovingEndToNewLine() throws Exception {
        this.magic();
    }

    public void testMovingEndWithWhitespaceToNewLine() throws Exception {
        this.magic();
    }

    public void testDeindentingEnd() throws Exception {
        this.magic();
    }

    public void testClassNotKeyword() throws Exception {
        this.magic();
    }

    public void testNewLineAfterEmptyIndentedLine() throws Exception {
        this.magic();
    }

    public void testNewLineInRegularFunction() throws Exception {
        this.magic();
    }

    public void testIndentAfterNewLineBeforeParen() throws Exception {
        this.magic();
    }

    public void testIndentOnUnclosedParen() throws Exception {
        this.magic();
    }

    public void testIndentOnFirstExplicitContinuation() throws Exception {
        this.magic();
    }

    public void testIndentOnFirstImplicitContinuation() throws Exception {
        this.magic();
    }

    public void testNoIndentOnSubsequentExplicitContinuation() throws Exception {
        this.magic();
    }

    public void testNoIndentOnSubsequentImplicitContinuationAfterExplicitOne() throws Exception {
        this.magic();
    }

    public void testNoIndentOnSubsequentImplicitContinuationAfterImplicitOne() throws Exception {
        this.magic();
    }
}

