/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.formatting;

import java.util.Map;
import org.eclipse.dltk.ruby.internal.ui.formatting.Indents;

public class IndentationState {
    private String lastIndentationBasedOnLevel = "";
    private int indentationLevel;
    private int offset;
    private int pos;
    private int fixIndentation;
    private String unformattedText;

    public IndentationState(String unformattedText, int offset, int initialIndentLevel) {
        this.unformattedText = unformattedText;
        this.offset = offset;
        this.indentationLevel = initialIndentLevel;
        this.pos = 0;
        this.resetFixIndentation();
    }

    public void decIndentationLevel() {
        --this.indentationLevel;
        this.resetFixIndentation();
    }

    public void incIndentationLevel() {
        ++this.indentationLevel;
        this.resetFixIndentation();
    }

    public void incPos(int increment) {
        this.pos += increment;
    }

    public void resetFixIndentation() {
        this.fixIndentation = -1;
    }

    public int getIndentation() {
        return this.fixIndentation;
    }

    public int getIndentationLevel() {
        return this.indentationLevel;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getPos() {
        return this.pos;
    }

    public String getUnformattedText() {
        return this.unformattedText;
    }

    public void setFixIndentation(int indentation) {
        this.fixIndentation = indentation;
    }

    public void setIndentationLevel(int indentationLevel) {
        this.indentationLevel = indentationLevel;
        this.resetFixIndentation();
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.resetFixIndentation();
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    protected String getIndentationString(Map options) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.getOffset()) {
            sb.append(" ");
            ++i;
        }
        if (this.getIndentation() != -1) {
            sb.append(this.lastIndentationBasedOnLevel);
            sb.append(Indents.createFixIndentString(this.getIndentation(), options));
        } else {
            this.lastIndentationBasedOnLevel = Indents.createIndentString(this.getIndentationLevel(), options);
            sb.append(this.lastIndentationBasedOnLevel);
        }
        return sb.toString();
    }
}

