/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ui.tests.dialogs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.corext.buildpath.AddLibraryOperation;
import org.eclipse.dltk.internal.corext.buildpath.AddSelectedLibraryOperation;
import org.eclipse.dltk.internal.corext.buildpath.AddSelectedSourceFolderOperation;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.corext.buildpath.EditFiltersOperation;
import org.eclipse.dltk.internal.corext.buildpath.ExcludeOperation;
import org.eclipse.dltk.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.internal.corext.buildpath.IncludeOperation;
import org.eclipse.dltk.internal.corext.buildpath.RemoveFromBuildpathOperation;
import org.eclipse.dltk.internal.corext.buildpath.ResetOperation;
import org.eclipse.dltk.internal.corext.buildpath.UnexcludeOperation;
import org.eclipse.dltk.internal.corext.buildpath.UnincludeOperation;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.BuildpathModifierQueries;
import org.eclipse.dltk.tcl.ui.tests.dialogs.NewEmptyProjectWizardTest;
import org.eclipse.dltk.tcl.ui.tests.dialogs.NewProjectTestSetup;
import org.eclipse.dltk.tcl.ui.tests.dialogs.NewProjectWizardOperationTest;
import org.eclipse.dltk.ui.tests.ScriptProjectHelper;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class NewProjectWizardTest
extends TestCase {
    private static final Class THIS;
    protected IScriptProject fProject;
    protected static NewProjectTestSetup fTestSetup;
    protected String fNormalFolder = "NormalFolder";
    protected String fSubFolder = "SubFolder";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.tcl.ui.tests.dialogs.NewProjectWizardTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public NewProjectWizardTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return NewProjectWizardTest.setUpTest((Test)new TestSuite(THIS));
    }

    public static Test setUpTest(Test test) {
        fTestSetup = new NewProjectTestSetup(test);
        return fTestSetup;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(THIS);
        fTestSetup = new NewProjectTestSetup((Test)suite);
        suite.addTestSuite(NewEmptyProjectWizardTest.THIS);
        suite.addTestSuite(NewProjectWizardOperationTest.THIS);
        return fTestSetup;
    }

    protected void setUp() throws Exception {
        this.fProject = fTestSetup.getWorkspaceProjectWithSrc();
        NewProjectWizardTest.assertFalse((boolean)this.fProject.isOnBuildpath(this.fProject.getUnderlyingResource()));
    }

    protected void tearDown() throws Exception {
        this.fProject.getProject().delete(true, true, null);
    }

    public void testCreateNormalFolderOnProject() throws CoreException, InvocationTargetException, InterruptedException {
        IFolder folder = (IFolder)this.executeOperation(10, null, this.getNormalFolderCreationQuery(), null);
        NewProjectWizardTest.assertTrue((boolean)folder.exists());
        NewProjectWizardTest.assertTrue((boolean)folder.getName().equals(this.fNormalFolder));
        NewProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)folder.getFullPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testCreateSourceFolderOnProject() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = (IProjectFragment)this.executeOperation(10, null, this.getSourceFolderCreationQuery(), null);
        NewProjectWizardTest.assertTrue((boolean)root.getUnderlyingResource().exists());
        NewProjectWizardTest.assertTrue((boolean)root.getElementName().equals(this.fSubFolder));
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testCreateNormalFolderOnFragRoot() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment parentRoot = this.addToBuildpath((IPath)new Path(this.fSubFolder));
        BuildpathModifierQueries.ICreateFolderQuery folderQuery = new BuildpathModifierQueries.ICreateFolderQuery(){

            public boolean doQuery() {
                return true;
            }

            public boolean isSourceFolder() {
                return false;
            }

            public IFolder getCreatedFolder() {
                return NewProjectWizardTest.this.getFolderHandle(new Path(NewProjectWizardTest.this.fSubFolder).append(NewProjectWizardTest.this.fNormalFolder));
            }
        };
        IFolder folder = (IFolder)this.executeOperation(10, parentRoot, folderQuery, null);
        NewProjectWizardTest.assertTrue((boolean)folder.exists());
        NewProjectWizardTest.assertTrue((boolean)folder.getName().equals(this.fNormalFolder));
        NewProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)new Path(this.fNormalFolder), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(this.fNormalFolder), parentRoot.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.validateBuildpath();
    }

    public void testCreateSourceFolderOnFragRoot() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment parentRoot = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        BuildpathModifierQueries.ICreateFolderQuery folderQuery = new BuildpathModifierQueries.ICreateFolderQuery(){

            public boolean doQuery() {
                return true;
            }

            public boolean isSourceFolder() {
                return true;
            }

            public IFolder getCreatedFolder() {
                return NewProjectWizardTest.this.getFolderHandle(new Path(NewProjectWizardTest.this.fNormalFolder).append(NewProjectWizardTest.this.fSubFolder));
            }
        };
        IProjectFragment root = (IProjectFragment)this.executeOperation(10, parentRoot, folderQuery, null);
        NewProjectWizardTest.assertTrue((boolean)root.getUnderlyingResource().exists());
        NewProjectWizardTest.assertTrue((boolean)root.getElementName().equals(this.fSubFolder));
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(this.fSubFolder), parentRoot.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.validateBuildpath();
    }

    public void testCreateNormalFolderOnFrag() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        final IPath nfFolder = new Path(this.fNormalFolder).append(this.fSubFolder).append("nfFolder");
        IFolder fragment = this.getFolderHandle(new Path(this.fNormalFolder).append(this.fSubFolder));
        BuildpathModifierQueries.ICreateFolderQuery folderQuery = new BuildpathModifierQueries.ICreateFolderQuery(){

            public boolean doQuery() {
                return true;
            }

            public boolean isSourceFolder() {
                return false;
            }

            public IFolder getCreatedFolder() {
                return NewProjectWizardTest.this.getFolderHandle(nfFolder);
            }
        };
        IFolder folder = (IFolder)this.executeOperation(10, fragment, folderQuery, null);
        NewProjectWizardTest.assertTrue((boolean)folder.exists());
        NewProjectWizardTest.assertTrue((boolean)folder.getParent().equals((Object)fragment));
        NewProjectWizardTest.assertTrue((boolean)folder.getName().equals(nfFolder.lastSegment()));
        NewProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)folder.getFullPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(folder.getFullPath().removeFirstSegments(2), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.validateBuildpath();
    }

    public void testCreateSourceFolderOnFrag() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment parentRoot = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IFolder fragment = this.getFolderHandle(new Path(this.fNormalFolder).append(this.fSubFolder));
        final IPath srcFolder = new Path(this.fNormalFolder).append(this.fSubFolder).append("srcFolder");
        BuildpathModifierQueries.ICreateFolderQuery folderQuery = new BuildpathModifierQueries.ICreateFolderQuery(){

            public boolean doQuery() {
                return true;
            }

            public boolean isSourceFolder() {
                return true;
            }

            public IFolder getCreatedFolder() {
                return NewProjectWizardTest.this.getFolderHandle(srcFolder);
            }
        };
        IProjectFragment root = (IProjectFragment)this.executeOperation(10, fragment, folderQuery, null);
        NewProjectWizardTest.assertTrue((boolean)root.getUnderlyingResource().exists());
        NewProjectWizardTest.assertTrue((boolean)root.getUnderlyingResource().getParent().equals((Object)fragment));
        NewProjectWizardTest.assertTrue((boolean)root.getElementName().equals(srcFolder.lastSegment()));
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(root.getPath().removeFirstSegments(2), parentRoot.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.validateBuildpath();
    }

    public void testAddNormalFolderToBP() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        int numberOfEntries = this.fProject.getRawBuildpath().length;
        this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        int newNumberOfEntries = this.fProject.getRawBuildpath().length;
        NewProjectWizardTest.assertTrue((numberOfEntries + 1 == newNumberOfEntries ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testAddNestedNormalFolderToBP() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IFolder cpFolder = this.excludePackage();
        IProjectFragment root = this.fProject.findProjectFragment(cpFolder.getFullPath());
        IFolder folder = this.getFolderHandle(cpFolder.getProjectRelativePath().append(this.fSubFolder));
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(folder.getName()), entry.getExclusionPatterns(), null));
        this.addToBuildpath(folder.getProjectRelativePath());
        entry = root.getRawBuildpathEntry();
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(folder.getName()), entry.getExclusionPatterns(), null));
        this.validateBuildpath();
    }

    public void testAddPackageToBP() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        this.getFolderHandle(new Path(this.fNormalFolder).append(this.fSubFolder));
        IScriptFolder fragment = root.getScriptFolder(this.fSubFolder);
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int nrExclusions = entry.getExclusionPatterns().length;
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getExclusionPatterns(), null));
        this.addToBuildpath((IModelElement)fragment);
        entry = root.getRawBuildpathEntry();
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getExclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((entry.getExclusionPatterns().length - 1 == nrExclusions ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testAddIncludedPackageToBP() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IFolder cpFolder = this.includePackage();
        IProjectFragment root = this.fProject.findProjectFragment(cpFolder.getFullPath());
        IScriptFolder fragment = root.getScriptFolder(this.fSubFolder);
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int nrInclusions = entry.getInclusionPatterns().length;
        int nrExclusions = entry.getExclusionPatterns().length;
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getInclusionPatterns(), null));
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getExclusionPatterns(), null));
        this.addToBuildpath((IModelElement)fragment);
        entry = root.getRawBuildpathEntry();
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getInclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getExclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((entry.getInclusionPatterns().length + 1 == nrInclusions ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((entry.getExclusionPatterns().length - 1 == nrExclusions ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testAddExcludedPackageToBP() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IFolder cpFolder = this.excludePackage();
        IProjectFragment root = this.fProject.findProjectFragment(cpFolder.getFullPath());
        IScriptFolder element = root.getScriptFolder(this.fSubFolder);
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(element.getElementName()), entry.getExclusionPatterns(), null));
        this.addToBuildpath((IModelElement)element);
        root = this.fProject.findProjectFragment(element.getParent().getPath());
        entry = root.getRawBuildpathEntry();
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(element.getElementName()), entry.getExclusionPatterns(), null));
        this.validateBuildpath();
    }

    public void testAddProjectToBP() throws CoreException, InvocationTargetException, InterruptedException {
        Path srcPath = new Path("src2");
        IProjectFragment root = this.addToBuildpath((IPath)srcPath);
        IFolder normalFolder = this.getFolderHandle((IPath)new Path(this.fNormalFolder));
        IProjectFragment projectRoot = this.getProjectRoot(this.fProject.getCorrespondingResource());
        IScriptFolder fragment = projectRoot.createScriptFolder("", false, null);
        NewProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)this.fProject.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((this.fProject.findScriptFolder(normalFolder.getFullPath()) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((this.fProject.findScriptFolder(fragment.getPath()) == null ? 1 : 0) != 0);
        IScriptProject project = (IScriptProject)this.executeOperation(0, this.fProject, null, null);
        NewProjectWizardTest.assertTrue((boolean)project.equals(this.fProject));
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)this.fProject.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)BuildpathModifier.isExcluded((IResource)root.getUnderlyingResource(), (IScriptProject)this.fProject));
        NewProjectWizardTest.assertFalse((this.fProject.findScriptFolder(normalFolder.getFullPath()) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((this.fProject.findScriptFolder(fragment.getPath()) == null ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testAddArchiveFileToBP() throws InvocationTargetException, InterruptedException, CoreException, IOException {
        IPath libraryPath = this.fProject.getPath().append("src2").append("archive.zip");
        this.testRemoveArchiveFileFromBP();
        IFile zipFile = this.fProject.getProject().getFile(libraryPath.removeFirstSegments(1));
        NewProjectWizardTest.assertTrue((boolean)zipFile.getFileExtension().equals("zip"));
        IProjectFragment root = (IProjectFragment)this.executeOperation(13, zipFile, null, null);
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testAddZipFileToBP() throws InvocationTargetException, InterruptedException, CoreException {
        IPath libraryPath = this.fProject.getPath().append("src2").append("archive.zip");
        this.testRemoveZipFileFromBP();
        IFile zipFile = this.fProject.getProject().getFile(libraryPath.removeFirstSegments(1));
        NewProjectWizardTest.assertTrue((boolean)zipFile.getFileExtension().equals("zip"));
        IProjectFragment root = (IProjectFragment)this.executeOperation(13, zipFile, null, null);
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testAddInterpreterEnvironmentToBP() throws InvocationTargetException, InterruptedException, CoreException {
        IBuildpathEntry[] entries = this.fProject.getRawBuildpath();
        IBuildpathEntry entry = null;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 5) {
                entry = entries[i];
                break;
            }
            ++i;
        }
        NewProjectWizardTest.assertTrue((entry != null ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)entry.getPath(), (IScriptProject)this.fProject, (int)5) == null ? 1 : 0) != 0);
        this.testRemoveInterpreterEnvironmentFromBP();
        BuildPathContainer container = (BuildPathContainer)this.executeOperation(12, entry, null, null);
        NewProjectWizardTest.assertTrue((boolean)container.getBuildpathEntry().equals(entry));
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)entry.getPath(), (IScriptProject)this.fProject, (int)5) == null ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testRemoveFromBP() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        int before = this.fProject.getRawBuildpath().length;
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IFolder folder = (IFolder)this.executeOperation(1, root, null, null);
        NewProjectWizardTest.assertTrue((boolean)folder.getFullPath().equals((Object)root.getPath()));
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains((IPath)new Path(this.fNormalFolder), this.getPaths(), null));
        int after = this.fProject.getRawBuildpath().length;
        NewProjectWizardTest.assertTrue((before == after ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void removeProjectFromBP() throws CoreException, InvocationTargetException, InterruptedException {
        Path srcPath = new Path("src2");
        IProjectFragment root = this.addToBuildpath((IPath)srcPath);
        IFolder normalFolder = this.getFolderHandle((IPath)new Path(this.fNormalFolder));
        IProjectFragment projectRoot = this.getProjectRoot(this.fProject.getCorrespondingResource());
        IScriptFolder fragment = projectRoot.createScriptFolder("", false, null);
        projectRoot = (IProjectFragment)this.executeOperation(0, this.fProject, null, null);
        NewProjectWizardTest.assertTrue((boolean)projectRoot.equals(this.getProjectRoot(this.fProject.getCorrespondingResource())));
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)this.fProject.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((this.fProject.findScriptFolder(normalFolder.getFullPath()) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((this.fProject.findScriptFolder(fragment.getPath()) == null ? 1 : 0) != 0);
        IScriptProject jProject = (IScriptProject)this.executeOperation(1, this.fProject, null, null);
        NewProjectWizardTest.assertTrue((boolean)jProject.equals(this.fProject));
        NewProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)this.fProject.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((this.fProject.findScriptFolder(normalFolder.getFullPath()) == null ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((this.fProject.findScriptFolder(fragment.getPath()) == null ? 1 : 0) != 0);
        projectRoot = (IProjectFragment)this.executeOperation(0, this.fProject, null, null);
        NewProjectWizardTest.assertTrue((boolean)projectRoot.equals(this.getProjectRoot(this.fProject.getCorrespondingResource())));
        this.validateBuildpath();
    }

    public void testIncludePackage() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        this.includePackage();
        this.validateBuildpath();
    }

    public void testExcludePackage() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        this.excludePackage();
        this.validateBuildpath();
    }

    public void testExcludeIncludedPackage() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IFolder cpFolder = this.includePackage();
        IProjectFragment root = this.fProject.findProjectFragment(cpFolder.getFullPath());
        IScriptFolder fragment = root.getScriptFolder(this.fSubFolder);
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int nrIncluded = entry.getInclusionPatterns().length;
        int nrExcluded = entry.getExclusionPatterns().length;
        IFolder folder = (IFolder)this.executeOperation(2, fragment, null, null);
        entry = root.getRawBuildpathEntry();
        IPath[] inclusionPatterns = entry.getInclusionPatterns();
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        NewProjectWizardTest.assertTrue((inclusionPatterns.length + 1 == nrIncluded ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((exclusionPatterns.length - 1 == nrExcluded ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), inclusionPatterns, null));
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), exclusionPatterns, null));
        NewProjectWizardTest.assertTrue((boolean)folder.getFullPath().equals((Object)fragment.getPath()));
        this.validateBuildpath();
    }

    public void testIncludeExcludedFolder() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IFolder cpFolder = this.excludePackage();
        IProjectFragment root = this.fProject.findProjectFragment(cpFolder.getFullPath());
        IFolder folder = this.getFolderHandle(cpFolder.getProjectRelativePath().append(this.fSubFolder));
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int nrIncluded = entry.getInclusionPatterns().length;
        int nrExcluded = entry.getExclusionPatterns().length;
        IScriptFolder fragment = (IScriptFolder)this.executeOperation(8, folder, null, null);
        entry = root.getRawBuildpathEntry();
        IPath[] inclusionPatterns = entry.getInclusionPatterns();
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        NewProjectWizardTest.assertTrue((inclusionPatterns.length - 1 == nrIncluded ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((exclusionPatterns.length + 1 == nrExcluded ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(folder.getName()), inclusionPatterns, null));
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains((IPath)new Path(folder.getName()), exclusionPatterns, null));
        NewProjectWizardTest.assertTrue((boolean)fragment.getPath().equals((Object)folder.getFullPath()));
        this.validateBuildpath();
    }

    public void testRemoveInclusion() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IFolder cpFolder = this.includePackage();
        IProjectFragment root = this.fProject.findProjectFragment(cpFolder.getFullPath());
        IScriptFolder fragment = root.getScriptFolder(this.fSubFolder);
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int nrIncluded = entry.getInclusionPatterns().length;
        int nrExcluded = entry.getExclusionPatterns().length;
        IScriptFolder frag = (IScriptFolder)this.executeOperation(9, fragment, null, null);
        entry = root.getRawBuildpathEntry();
        IPath[] inclusionPatterns = entry.getInclusionPatterns();
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        NewProjectWizardTest.assertTrue((inclusionPatterns.length + 1 == nrIncluded ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((exclusionPatterns.length == nrExcluded ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), inclusionPatterns, null));
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), exclusionPatterns, null));
        NewProjectWizardTest.assertTrue((boolean)frag.getPath().equals((Object)fragment.getPath()));
        this.validateBuildpath();
    }

    public void testRemoveExclusion() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IFolder cpFolder = this.excludePackage();
        IProjectFragment root = this.fProject.findProjectFragment(cpFolder.getFullPath());
        IFolder folder = this.getFolderHandle(cpFolder.getProjectRelativePath().append(this.fSubFolder));
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int nrIncluded = entry.getInclusionPatterns().length;
        int nrExcluded = entry.getExclusionPatterns().length;
        IScriptFolder fragment = (IScriptFolder)this.executeOperation(3, folder, null, null);
        entry = root.getRawBuildpathEntry();
        IPath[] inclusionPatterns = entry.getInclusionPatterns();
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        NewProjectWizardTest.assertTrue((inclusionPatterns.length == nrIncluded ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((exclusionPatterns.length + 1 == nrExcluded ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains((IPath)new Path(folder.getName()), inclusionPatterns, null));
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains((IPath)new Path(folder.getName()), exclusionPatterns, null));
        NewProjectWizardTest.assertTrue((boolean)fragment.getPath().equals((Object)folder.getFullPath()));
        this.validateBuildpath();
    }

    public void testRemoveArchiveFileFromBP() throws InvocationTargetException, InterruptedException, CoreException, IOException {
        Path srcPath = new Path("src2");
        IProjectFragment parentRoot = this.addToBuildpath((IPath)srcPath);
        IPath libraryPath = parentRoot.getPath().append("archive.zip");
        IProjectFragment root = ScriptProjectHelper.addLibrary((IScriptProject)this.fProject, (IPath)libraryPath);
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        this.executeOperation(1, root, null, null);
        this.validateBuildpath();
    }

    public void testRemoveZipFileFromBP() throws InvocationTargetException, InterruptedException, CoreException {
        Path srcPath = new Path("src2");
        IProjectFragment parentRoot = this.addToBuildpath((IPath)srcPath);
        IPath libraryPath = parentRoot.getPath().append("archive.zip");
        IProjectFragment root = ScriptProjectHelper.addLibrary((IScriptProject)this.fProject, (IPath)libraryPath);
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        this.executeOperation(1, root, null, null);
        this.validateBuildpath();
    }

    public void testRemoveInterpreterEnvironmentFromBP() throws InvocationTargetException, InterruptedException, CoreException {
        IBuildpathEntry[] entries = this.fProject.getRawBuildpath();
        IBuildpathEntry entry = null;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 5) {
                entry = entries[i];
                break;
            }
            ++i;
        }
        NewProjectWizardTest.assertTrue((entry != null ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)entry.getPath(), (IScriptProject)this.fProject, (int)5) == null ? 1 : 0) != 0);
        BuildPathContainer container = new BuildPathContainer(this.fProject, entry);
        IScriptProject project = (IScriptProject)this.executeOperation(1, container, null, null);
        NewProjectWizardTest.assertTrue((boolean)project.equals(this.fProject));
        NewProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)entry.getPath(), (IScriptProject)this.fProject, (int)5) == null ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testEditFilters() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        final IScriptFolder includedPackage = root.getScriptFolder(this.fSubFolder);
        final IScriptFolder excludedPackage = root.getScriptFolder(String.valueOf(this.fSubFolder) + "2");
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains(new Path(includedPackage.getElementName()).addTrailingSeparator(), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains(new Path(excludedPackage.getElementName()).addTrailingSeparator(), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        BuildpathModifierQueries.IInclusionExclusionQuery query = new BuildpathModifierQueries.IInclusionExclusionQuery(){

            public boolean doQuery(BPListElement element, boolean focusOnExcluded) {
                return true;
            }

            public IPath[] getInclusionPattern() {
                return new IPath[]{new Path(includedPackage.getElementName()).addTrailingSeparator()};
            }

            public IPath[] getExclusionPattern() {
                return new IPath[]{new Path(excludedPackage.getElementName()).addTrailingSeparator()};
            }
        };
        root = (IProjectFragment)this.executeOperation(4, root, null, query);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(new Path(includedPackage.getElementName()).addTrailingSeparator(), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(new Path(excludedPackage.getElementName()).addTrailingSeparator(), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.validateBuildpath();
    }

    public void testResetFilters() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IFolder folder = this.getFolderHandle((IPath)new Path(this.fNormalFolder));
        IScriptFolder includedPackage = root.getScriptFolder(this.fSubFolder);
        IScriptFolder excludedPackage = root.getScriptFolder(String.valueOf(this.fSubFolder) + "2");
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        this.executeOperation(8, includedPackage, null, null);
        this.executeOperation(2, excludedPackage, null, null);
        this.addToBuildpath(folder.getProjectRelativePath().append(String.valueOf(this.fSubFolder) + "3"));
        IFolder subSrcFolder = this.getFolderHandle(folder.getProjectRelativePath().append(String.valueOf(this.fSubFolder) + "3"));
        int numberOnBP = this.fProject.getRawBuildpath().length;
        IProjectFragment editedRoot = (IProjectFragment)this.executeOperation(7, root, null, null);
        entry = editedRoot.getRawBuildpathEntry();
        NewProjectWizardTest.assertTrue((entry.getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((entry.getExclusionPatterns().length == 1 ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(folder.getFullPath(), this.getPaths(), null));
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(subSrcFolder.getFullPath(), this.getPaths(), null));
        NewProjectWizardTest.assertTrue((this.fProject.getRawBuildpath().length == numberOnBP ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)editedRoot.getPath().equals((Object)root.getPath()));
        this.validateBuildpath();
    }

    public void testIncludeSourceModule() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        ISourceModule newCu = (ISourceModule)this.executeOperation(8, cu, null, null);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(newCu.getPath().removeFirstSegments(2), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((boolean)newCu.getPath().equals((Object)cu.getPath()));
        this.validateBuildpath();
    }

    public void testExcludeSourceModule() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        IFile excludedFile = (IFile)this.executeOperation(2, cu, null, null);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(excludedFile.getFullPath().removeFirstSegments(2), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((boolean)excludedFile.getFullPath().equals((Object)cu.getPath()));
        this.validateBuildpath();
    }

    public void testIncludeExcludedFile() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        IFile excludedFile = (IFile)this.executeOperation(2, cu, null, null);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(excludedFile.getFullPath().removeFirstSegments(2), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        ISourceModule newCu = (ISourceModule)this.executeOperation(8, cu, null, null);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(newCu.getPath().removeFirstSegments(2), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((boolean)excludedFile.getFullPath().equals((Object)newCu.getPath()));
        this.validateBuildpath();
    }

    public void testExcludeIncludedFile() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        ISourceModule newCu = (ISourceModule)this.executeOperation(8, cu, null, null);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(cu.getPath().removeFirstSegments(2), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        IFile excludedFile = (IFile)this.executeOperation(2, newCu, null, null);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(excludedFile.getFullPath().removeFirstSegments(2), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((boolean)excludedFile.getFullPath().equals((Object)newCu.getPath()));
        this.validateBuildpath();
    }

    public void testUnincludeFile() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        ISourceModule newCu = (ISourceModule)this.executeOperation(8, cu, null, null);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(newCu.getPath().removeFirstSegments(2), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        newCu = (ISourceModule)this.executeOperation(9, newCu, null, null);
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains(newCu.getPath().removeFirstSegments(2), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((boolean)newCu.getPath().equals((Object)cu.getPath()));
        this.validateBuildpath();
    }

    public void testUnexcludeFile() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        IFile excludedFile = (IFile)this.executeOperation(2, cu, null, null);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(excludedFile.getFullPath().removeFirstSegments(2), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((boolean)excludedFile.getFullPath().equals((Object)cu.getPath()));
        ISourceModule newCu = (ISourceModule)this.executeOperation(3, excludedFile, null, null);
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains(excludedFile.getFullPath().removeFirstSegments(2), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((boolean)newCu.getPath().equals((Object)cu.getPath()));
        this.validateBuildpath();
    }

    public void testIncludeFileOnFolder() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment2 = root.createScriptFolder(String.valueOf(this.fSubFolder) + "2", false, null);
        this.executeOperation(8, fragment2, null, null);
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewProjectWizardTest.assertTrue((this.fProject.findElement(cu.getPath().makeRelative()) == null ? 1 : 0) != 0);
        ISourceModule newCu = (ISourceModule)this.executeOperation(8, cu.getUnderlyingResource(), null, null);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(newCu.getPath().removeFirstSegments(2), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((boolean)newCu.getPath().equals((Object)cu.getPath()));
        this.validateBuildpath();
    }

    public void testExcludeFileOnFolder() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment2 = root.createScriptFolder(String.valueOf(this.fSubFolder) + "2", false, null);
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        this.executeOperation(8, fragment2, null, null);
        NewProjectWizardTest.assertTrue((this.fProject.findElement(cu.getPath().makeRelative()) == null ? 1 : 0) != 0);
        ISourceModule newCu = (ISourceModule)this.executeOperation(8, cu.getUnderlyingResource(), null, null);
        IFile excludedFile = (IFile)this.executeOperation(2, newCu, null, null);
        NewProjectWizardTest.assertTrue((boolean)excludedFile.getFullPath().equals((Object)newCu.getPath()));
        this.validateBuildpath();
    }

    public void testUnincludeFileOnFolder() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment2 = root.createScriptFolder(String.valueOf(this.fSubFolder) + "2", false, null);
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        this.executeOperation(8, fragment2, null, null);
        NewProjectWizardTest.assertTrue((this.fProject.findElement(cu.getPath().makeRelative()) == null ? 1 : 0) != 0);
        ISourceModule newCu = (ISourceModule)this.executeOperation(8, cu.getUnderlyingResource(), null, null);
        IFile file = (IFile)this.executeOperation(9, newCu, null, null);
        NewProjectWizardTest.assertTrue((boolean)file.getFullPath().equals((Object)cu.getPath()));
        this.validateBuildpath();
    }

    public void testIncludeFileOnIncludedFragment() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        fragment = (IScriptFolder)this.executeOperation(8, fragment, null, null);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getInclusionPatterns().length == 1 ? 1 : 0) != 0);
        cu = (ISourceModule)this.executeOperation(8, cu, null, null);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getInclusionPatterns().length == 2 ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(cu.getPath().removeFirstSegments(2), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        this.validateBuildpath();
    }

    public void testExcludeFileOnIncludedFragment() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        fragment = (IScriptFolder)this.executeOperation(8, fragment, null, null);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getInclusionPatterns().length == 1 ? 1 : 0) != 0);
        IFile excludedFile = (IFile)this.executeOperation(2, cu, null, null);
        NewProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getInclusionPatterns().length == 1 ? 1 : 0) != 0);
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains(excludedFile.getFullPath().removeFirstSegments(2), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(excludedFile.getFullPath().removeFirstSegments(2), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.validateBuildpath();
    }

    public void testUnincludeOnIncludedFragment() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        fragment = (IScriptFolder)this.executeOperation(8, fragment, null, null);
        cu = (ISourceModule)this.executeOperation(8, cu, null, null);
        cu = (ISourceModule)this.executeOperation(9, cu, null, null);
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains(cu.getPath().removeFirstSegments(2), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        this.validateBuildpath();
    }

    public void testUnexcludeOnIncludedFragment() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IScriptFolder fragment = root.createScriptFolder(this.fSubFolder, false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        fragment = (IScriptFolder)this.executeOperation(8, fragment, null, null);
        IFile excludedFile = (IFile)this.executeOperation(2, cu, null, null);
        cu = (ISourceModule)this.executeOperation(3, excludedFile, null, null);
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains(cu.getPath().removeFirstSegments(2), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        NewProjectWizardTest.assertTrue((boolean)excludedFile.getFullPath().equals((Object)cu.getPath()));
        this.validateBuildpath();
    }

    protected Object executeOperation(int type, final Object selection, BuildpathModifierQueries.ICreateFolderQuery creationQuery, final BuildpathModifierQueries.IInclusionExclusionQuery inclQuery) throws InvocationTargetException, InterruptedException {
        final Object[] returnValue = new Object[1];
        IBuildpathInformationProvider provider = new IBuildpathInformationProvider(){

            public void handleResult(List result, CoreException exception, int operationType) {
                if (result.size() == 1) {
                    returnValue[0] = result.get(0);
                }
            }

            public IStructuredSelection getSelection() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(selection);
                return new StructuredSelection(list);
            }

            public IScriptProject getScriptProject() {
                return NewProjectWizardTest.this.fProject;
            }

            public BuildpathModifierQueries.IInclusionExclusionQuery getInclusionExclusionQuery() {
                return inclQuery;
            }

            public BuildpathModifierQueries.ILinkToQuery getLinkFolderQuery() throws ModelException {
                return null;
            }

            public BuildpathModifierQueries.IAddArchivesQuery getExternalArchivesQuery() throws ModelException {
                return null;
            }

            public BuildpathModifierQueries.IAddLibrariesQuery getLibrariesQuery() throws ModelException {
                return new BuildpathModifierQueries.IAddLibrariesQuery(this, selection){
                    final /* synthetic */ 6 this$1;
                    private final /* synthetic */ Object val$selection;
                    {
                        this.this$1 = var1_1;
                        this.val$selection = object;
                    }

                    public IBuildpathEntry[] doQuery(IScriptProject project, IBuildpathEntry[] entries) {
                        return new IBuildpathEntry[]{(IBuildpathEntry)this.val$selection};
                    }
                };
            }

            public void deleteCreatedResources() {
            }

            public BuildpathModifierQueries.IRemoveLinkedFolderQuery getRemoveLinkedFolderQuery() throws ModelException {
                return null;
            }

            public BuildpathModifierQueries.ICreateFolderQuery getCreateFolderQuery() throws ModelException {
                return null;
            }
        };
        AddSelectedSourceFolderOperation op = null;
        switch (type) {
            case 0: {
                op = new AddSelectedSourceFolderOperation(null, provider);
                break;
            }
            case 13: {
                op = new AddSelectedLibraryOperation(null, provider);
                break;
            }
            case 1: {
                op = new RemoveFromBuildpathOperation(null, provider);
                break;
            }
            case 8: {
                op = new IncludeOperation(null, provider);
                break;
            }
            case 9: {
                op = new UnincludeOperation(null, provider);
                break;
            }
            case 2: {
                op = new ExcludeOperation(null, provider);
                break;
            }
            case 3: {
                op = new UnexcludeOperation(null, provider);
                break;
            }
            case 4: {
                op = new EditFiltersOperation(null, provider);
                break;
            }
            case 7: {
                op = new ResetOperation(null, provider);
                break;
            }
            case 12: {
                op = new AddLibraryOperation(null, provider);
            }
        }
        op.run(null);
        return returnValue[0];
    }

    protected IProjectFragment addToBuildpath(IPath path) throws CoreException, InvocationTargetException, InterruptedException {
        IPath[] paths = this.getPaths();
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains(path, paths, null));
        IProjectFragment root = (IProjectFragment)this.executeOperation(0, this.getFolderHandle(path), null, null);
        paths = this.getPaths();
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(root.getPath(), this.getPaths(), null));
        return root;
    }

    protected IProjectFragment addToBuildpath(IModelElement element) throws CoreException, InvocationTargetException, InterruptedException {
        IPath[] paths = this.getPaths();
        NewProjectWizardTest.assertFalse((boolean)NewProjectWizardTest.contains(element.getPath(), paths, null));
        IProjectFragment root = (IProjectFragment)this.executeOperation(0, element, null, null);
        paths = this.getPaths();
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains(element.getPath(), paths, null));
        return root;
    }

    protected IFolder includePackage() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IFolder cpFolder = this.getFolderHandle((IPath)new Path(this.fNormalFolder));
        IFolder folder = this.getFolderHandle(cpFolder.getProjectRelativePath().append(this.fSubFolder));
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int before = entry.getInclusionPatterns().length;
        this.executeOperation(8, folder, null, null);
        entry = root.getRawBuildpathEntry();
        IPath[] inclusionPatterns = entry.getInclusionPatterns();
        int after = inclusionPatterns.length;
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(folder.getName()), inclusionPatterns, null));
        NewProjectWizardTest.assertTrue((before + 1 == after ? 1 : 0) != 0);
        return cpFolder;
    }

    protected IFolder excludePackage() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        IFolder cpFolder = this.getFolderHandle((IPath)new Path(this.fNormalFolder));
        IFolder folder = this.getFolderHandle(cpFolder.getProjectRelativePath().append(this.fSubFolder));
        IScriptFolder fragment = root.getScriptFolder(folder.getName());
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int nrExcluded = entry.getExclusionPatterns().length;
        this.executeOperation(2, fragment, null, null);
        entry = root.getRawBuildpathEntry();
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        NewProjectWizardTest.assertTrue((nrExcluded + 1 == exclusionPatterns.length ? 1 : 0) != 0);
        NewProjectWizardTest.assertTrue((boolean)NewProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), exclusionPatterns, null));
        return cpFolder;
    }

    protected IFolder getFolderHandle(IPath path) {
        IFolder folder = this.fProject.getProject().getFolder(path);
        try {
            if (!folder.exists()) {
                folder.create(true, false, null);
            }
        }
        catch (CoreException coreException) {}
        return folder;
    }

    protected ISourceModule createISourceModule(String className, IScriptFolder fragment) throws ModelException {
        String packString = fragment.getElementName().equals("") ? fragment.getElementName() : "package " + fragment.getElementName() + ";\n";
        StringBuffer content = this.getFileContent(className, packString);
        return fragment.createSourceModule(String.valueOf(className) + ".java", content.toString(), false, null);
    }

    protected StringBuffer getFileContent(String className, String packageHeader) {
        StringBuffer buf = new StringBuffer();
        buf.append(packageHeader);
        buf.append("\n");
        buf.append("public class " + className + " {\n");
        buf.append("    public void foo() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        return buf;
    }

    protected BuildpathModifierQueries.ICreateFolderQuery getSourceFolderCreationQuery() {
        return new BuildpathModifierQueries.ICreateFolderQuery(){

            public boolean doQuery() {
                return true;
            }

            public boolean isSourceFolder() {
                return true;
            }

            public IFolder getCreatedFolder() {
                return NewProjectWizardTest.this.getFolderHandle((IPath)new Path(NewProjectWizardTest.this.fSubFolder));
            }
        };
    }

    protected BuildpathModifierQueries.ICreateFolderQuery getNormalFolderCreationQuery() {
        return new BuildpathModifierQueries.ICreateFolderQuery(){

            public boolean doQuery() {
                return true;
            }

            public boolean isSourceFolder() {
                return false;
            }

            public IFolder getCreatedFolder() {
                return NewProjectWizardTest.this.getFolderHandle((IPath)new Path(NewProjectWizardTest.this.fNormalFolder));
            }
        };
    }

    protected IPath[] getPaths() throws ModelException {
        IBuildpathEntry[] entries = this.fProject.getRawBuildpath();
        IPath[] paths = new IPath[entries.length];
        int i = 0;
        while (i < entries.length) {
            paths[i] = entries[i].getPath();
            ++i;
        }
        return paths;
    }

    protected void validateBuildpath() throws ModelException {
        IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)this.fProject, (IBuildpathEntry[])this.fProject.getRawBuildpath());
        NewProjectWizardTest.assertFalse((status.getSeverity() == 4 ? 1 : 0) != 0);
    }

    protected IProjectFragment getProjectRoot(IResource resource) throws ModelException {
        return BuildpathModifier.getFragmentRoot((IResource)resource, (IScriptProject)this.fProject, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean contains(IPath path, IPath[] paths, IProgressMonitor monitor) {
        block9: {
            block8: {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                if (path == null) {
                    return false;
                }
                try {
                    monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_ComparePaths, paths.length);
                    if (path.getFileExtension() == null) {
                        path = new Path(NewProjectWizardTest.completeName(path.toString()));
                    }
                    int i = 0;
                    while (i < paths.length) {
                        if (paths[i].equals((Object)path)) {
                            Object var4_4 = null;
                            break block8;
                        }
                        monitor.worked(1);
                        ++i;
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return true;
        }
        Object var4_6 = null;
        monitor.done();
        return false;
    }

    private static String completeName(String name) {
        if (!name.endsWith(".java")) {
            name = String.valueOf(name) + "/";
            name = name.replace('.', '/');
            return name;
        }
        return name;
    }
}

