/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.scriptview;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.scriptview.ScriptMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class BuildPathContainer
implements IAdaptable,
IWorkbenchAdapter {
    private IScriptProject fProject;
    private IBuildpathEntry fBuildPathEntry;
    private IBuildpathContainer fContainer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BuildPathContainer(IScriptProject parent, IBuildpathEntry entry) {
        this.fProject = parent;
        this.fBuildPathEntry = entry;
        try {
            this.fContainer = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)parent);
        }
        catch (ModelException modelException) {
            this.fContainer = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BuildPathContainer) {
            BuildPathContainer other = (BuildPathContainer)obj;
            if (this.fProject.equals(other.fProject) && this.fBuildPathEntry.equals(other.fBuildPathEntry)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.fProject.hashCode() * 17 + this.fBuildPathEntry.hashCode();
    }

    public Object[] getProjectFragments() {
        IProjectFragment[] fragments = this.fProject.findProjectFragments(this.fBuildPathEntry);
        ArrayList<IProjectFragment> frags = new ArrayList<IProjectFragment>();
        int i = 0;
        while (i < fragments.length) {
            try {
                if (fragments[i].hasChildren()) {
                    frags.add(fragments[i]);
                }
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return frags.toArray();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2 && this.fContainer instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)this.fContainer;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return iAdaptable.getAdapter((Class)clazz3);
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        return BuildPathContainer.concatenate(this.getProjectFragments(), this.getRequiredProjects());
    }

    private Object[] getRequiredProjects() {
        ArrayList<RequiredProjectWrapper> list = new ArrayList<RequiredProjectWrapper>();
        if (this.fContainer != null) {
            IBuildpathEntry[] buildpathEntries = this.fContainer.getBuildpathEntries();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < buildpathEntries.length) {
                IResource resource;
                IBuildpathEntry entry = buildpathEntries[i];
                if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) instanceof IProject) {
                    list.add(new RequiredProjectWrapper(DLTKCore.create((IResource)resource)));
                }
                ++i;
            }
        }
        return list.toArray();
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return DLTKPluginImages.DESC_OBJS_LIBRARY;
    }

    public String getLabel(Object o) {
        if (this.fContainer != null) {
            return this.fContainer.getDescription();
        }
        IPath path = this.fBuildPathEntry.getPath();
        String containerId = path.segment(0);
        BuildpathContainerInitializer initializer = DLTKCore.getBuildpathContainerInitializer((String)containerId);
        if (initializer != null) {
            String description = initializer.getDescription(path, this.fProject);
            return Messages.format(ScriptMessages.BuildPathContainer_unbound_label, description);
        }
        return Messages.format(ScriptMessages.BuildPathContainer_unknown_label, path.toString());
    }

    public Object getParent(Object o) {
        return this.getScriptProject();
    }

    public IScriptProject getScriptProject() {
        return this.fProject;
    }

    public IBuildpathEntry getBuildpathEntry() {
        return this.fBuildPathEntry;
    }

    public static boolean contains(IScriptProject project, IBuildpathEntry entry, IProjectFragment root) {
        IProjectFragment[] roots = project.findProjectFragments(entry);
        int i = 0;
        while (i < roots.length) {
            if (roots[i].equals(root)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class RequiredProjectWrapper
    implements IAdaptable,
    IWorkbenchAdapter {
        private final IModelElement fProject;
        private static ImageDescriptor DESC_OBJ_PROJECT;

        public RequiredProjectWrapper(IModelElement project) {
            ISharedImages images = DLTKUIPlugin.getDefault().getWorkbench().getSharedImages();
            DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
            this.fProject = project;
        }

        public IModelElement getProject() {
            return this.fProject;
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return this;
            }
            return null;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return DESC_OBJ_PROJECT;
        }

        public String getLabel(Object o) {
            return this.fProject.getElementName();
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

