/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.BuildpathEntry;

public class BuildpathDetector
implements IResourceProxyVisitor {
    private HashMap fSourceFolders = new HashMap();
    private List fClassFiles;
    private HashSet fJARFiles = new HashSet(10);
    private IProject fProject;
    private IBuildpathEntry[] fResultBuildpath;
    private IProgressMonitor fMonitor;

    public BuildpathDetector(IProject project, IProgressMonitor monitor) throws CoreException {
        this.fClassFiles = new ArrayList(100);
        this.fProject = project;
        this.fResultBuildpath = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.detectBuildpath(monitor);
    }

    private boolean isNested(IPath path, Iterator iter) {
        while (iter.hasNext()) {
            IPath other = (IPath)iter.next();
            if (!other.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void detectBuildpath(IProgressMonitor monitor) throws CoreException {
        try {
            IBuildpathEntry[] entries;
            block11: {
                block10: {
                    ArrayList cpEntries;
                    block9: {
                        monitor.beginTask("Buildpath detecting...", 4);
                        this.fMonitor = monitor;
                        this.fProject.accept((IResourceProxyVisitor)this, 0);
                        monitor.worked(1);
                        cpEntries = new ArrayList();
                        this.detectSourceFolders(cpEntries);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        monitor.worked(1);
                        this.detectLibraries(cpEntries);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        monitor.worked(1);
                        if (!cpEntries.isEmpty() || !this.fClassFiles.isEmpty()) break block9;
                        break block10;
                    }
                    entries = cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
                    if (BuildpathEntry.validateBuildpath((IScriptProject)DLTKCore.create((IProject)this.fProject), (IBuildpathEntry[])entries).isOK()) break block11;
                }
                Object var4_3 = null;
                monitor.done();
                return;
            }
            this.fResultBuildpath = entries;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private void detectLibraries(ArrayList cpEntries) {
        ArrayList<IBuildpathEntry> res = new ArrayList<IBuildpathEntry>();
        Set sourceFolderSet = this.fSourceFolders.keySet();
        Iterator iter = this.fJARFiles.iterator();
        while (iter.hasNext()) {
            IPath path = (IPath)iter.next();
            if (this.isNested(path, sourceFolderSet.iterator())) continue;
            IBuildpathEntry entry = DLTKCore.newLibraryEntry((IPath)path);
            res.add(entry);
        }
        Collections.sort(res, new CPSorter());
        cpEntries.addAll(res);
    }

    private void detectSourceFolders(ArrayList resEntries) {
        ArrayList<IBuildpathEntry> res = new ArrayList<IBuildpathEntry>();
        Set sourceFolderSet = this.fSourceFolders.keySet();
        Iterator iter = sourceFolderSet.iterator();
        while (iter.hasNext()) {
            IPath path = (IPath)iter.next();
            ArrayList<IPath> excluded = new ArrayList<IPath>();
            Iterator inner = sourceFolderSet.iterator();
            while (inner.hasNext()) {
                IPath other = (IPath)inner.next();
                if (path.equals((Object)other) || !path.isPrefixOf(other)) continue;
                IPath pathToExclude = other.removeFirstSegments(path.segmentCount()).addTrailingSeparator();
                excluded.add(pathToExclude);
            }
            IPath[] excludedPaths = excluded.toArray(new IPath[excluded.size()]);
            IBuildpathEntry entry = DLTKCore.newSourceEntry((IPath)path, (IPath[])excludedPaths);
            res.add(entry);
        }
        Collections.sort(res, new CPSorter());
        resEntries.addAll(res);
    }

    private boolean hasExtension(String name, String ext) {
        return name.endsWith(ext) && ext.length() != name.length();
    }

    private boolean isValidCUResource(IResource res) {
        IDLTKLanguageToolkit tk = DLTKLanguageManager.findToolkit((IResource)res);
        if (tk != null) {
            return !tk.validateSourceModule(res).matches(4);
        }
        return false;
    }

    public boolean visit(IResourceProxy proxy) {
        if (this.fMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (proxy.getType() == 1) {
            String name = proxy.getName();
            IResource res = proxy.requestResource();
            if (this.isValidCUResource(res)) {
                if (DLTKCore.DEBUG) {
                    System.err.println("Add language dependent detecting of buildpaths here...");
                }
            } else if (this.hasExtension(name, ".zip")) {
                this.fJARFiles.add(proxy.requestFullPath());
            }
            return false;
        }
        return true;
    }

    public IBuildpathEntry[] getBuildpath() {
        return this.fResultBuildpath;
    }

    private static class CPSorter
    implements Comparator {
        private Collator fCollator = Collator.getInstance();

        private CPSorter() {
        }

        public int compare(Object o1, Object o2) {
            IBuildpathEntry e1 = (IBuildpathEntry)o1;
            IBuildpathEntry e2 = (IBuildpathEntry)o2;
            return this.fCollator.compare(e1.getPath().toString(), e2.getPath().toString());
        }
    }
}

