/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalComputer;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ScriptTextMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public abstract class ScriptCompletionProposalComputer
implements IScriptCompletionProposalComputer {
    private String fErrorMessage;

    private List addContextInformations(ScriptContentAssistInvocationContext context, int offset, IProgressMonitor monitor) {
        List proposals = this.computeScriptCompletionProposals(offset, context, monitor);
        ArrayList<ContextInformationWrapper> result = new ArrayList<ContextInformationWrapper>(proposals.size());
        Iterator it = proposals.iterator();
        while (it.hasNext()) {
            ICompletionProposal proposal = (ICompletionProposal)it.next();
            IContextInformation contextInformation = proposal.getContextInformation();
            if (contextInformation == null) continue;
            ContextInformationWrapper wrapper = new ContextInformationWrapper(contextInformation);
            wrapper.setContextInformationPosition(offset);
            result.add(wrapper);
        }
        return result;
    }

    private void handleCodeCompletionException(ModelException e, ScriptContentAssistInvocationContext context) {
        ISourceModule module = context.getSourceModule();
        Shell shell = context.getViewer().getTextWidget().getShell();
        if (e.isDoesNotExist() && !module.getScriptProject().isOnBuildpath((IModelElement)module)) {
            IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
            boolean value = store.getBoolean("org.eclipse.dltk.ui.notification.not_on_buildpath");
            if (!value) {
                MessageDialog.openInformation((Shell)shell, (String)ScriptTextMessages.CompletionProcessor_error_notOnBuildPath_title, (String)ScriptTextMessages.CompletionProcessor_error_notOnBuildPath_message);
            }
            store.setValue("org.eclipse.dltk.ui.notification.not_on_buildpath", true);
        } else {
            ErrorDialog.openError((Shell)shell, (String)ScriptTextMessages.CompletionProcessor_error_accessing_title, (String)ScriptTextMessages.CompletionProcessor_error_accessing_message, (IStatus)e.getStatus());
        }
    }

    protected List computeTemplateCompletionProposals(int offset, ScriptContentAssistInvocationContext context, IProgressMonitor monitor) {
        TemplateCompletionProcessor templateProcessor = this.createTemplateProposalComputer(context);
        if (templateProcessor != null) {
            ICompletionProposal[] tempalteProposals = templateProcessor.computeCompletionProposals(context.getViewer(), offset);
            return Arrays.asList(tempalteProposals);
        }
        return Collections.EMPTY_LIST;
    }

    protected List computeScriptCompletionProposals(int offset, ScriptContentAssistInvocationContext context, IProgressMonitor monitor) {
        ISourceModule sourceModule = context.getSourceModule();
        if (sourceModule == null) {
            return Collections.EMPTY_LIST;
        }
        ScriptCompletionProposalCollector collector = this.createCollector(context);
        if (collector == null) {
            return Collections.EMPTY_LIST;
        }
        collector.setInvocationContext(context);
        Point selection = context.getViewer().getSelectedRange();
        if (selection.y > 0) {
            collector.setReplacementLength(selection.y);
        }
        try {
            IModelElement element = sourceModule.getElementAt(offset);
            if (element != null && DLTKCore.DEBUG_COMPLETION) {
                System.out.println("========= Model element: " + element.getClass());
            }
            sourceModule.codeComplete(offset, (CompletionRequestor)collector);
        }
        catch (ModelException e) {
            this.handleCodeCompletionException(e, context);
        }
        IScriptCompletionProposal[] proposals = collector.getScriptCompletionProposals();
        if (proposals.length == 0) {
            String error = collector.getErrorMessage();
            if (error.length() > 0) {
                this.fErrorMessage = error;
            }
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(proposals);
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof ScriptContentAssistInvocationContext) {
            ScriptContentAssistInvocationContext scriptContext = (ScriptContentAssistInvocationContext)context;
            ArrayList proposals = new ArrayList();
            proposals.addAll(this.computeScriptCompletionProposals(context.getInvocationOffset(), scriptContext, monitor));
            proposals.addAll(this.computeTemplateCompletionProposals(context.getInvocationOffset(), scriptContext, monitor));
            return proposals;
        }
        return Collections.EMPTY_LIST;
    }

    protected int guessContextInformationPosition(ContentAssistInvocationContext context) {
        return context.getInvocationOffset();
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof ScriptContentAssistInvocationContext) {
            ScriptContentAssistInvocationContext scriptContext = (ScriptContentAssistInvocationContext)context;
            int contextInformationPosition = this.guessContextInformationPosition(scriptContext);
            List result = this.addContextInformations(scriptContext, contextInformationPosition, monitor);
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
        this.fErrorMessage = null;
    }

    protected TemplateCompletionProcessor createTemplateProposalComputer(ScriptContentAssistInvocationContext context) {
        return null;
    }

    protected ScriptCompletionProposalCollector createCollector(ScriptContentAssistInvocationContext context) {
        return null;
    }

    private static final class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation contextInformation) {
            this.fContextInformation = contextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int position) {
            this.fPosition = position;
        }

        public boolean equals(Object object) {
            if (object instanceof ContextInformationWrapper) {
                return this.fContextInformation.equals((Object)((ContextInformationWrapper)object).fContextInformation);
            }
            return this.fContextInformation.equals(object);
        }
    }
}

