/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler;

import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.ISourceElementRequestor;

public class SourceElementRequestVisitor
extends ASTVisitor {
    protected ISourceElementRequestor fRequestor = null;
    protected boolean fInClass = false;
    protected boolean fInMethod = false;
    protected MethodDeclaration fCurrentMethod = null;
    protected Stack fNodes = new Stack();

    protected SourceElementRequestVisitor(ISourceElementRequestor requesor) {
        this.fRequestor = requesor;
    }

    protected MethodDeclaration getCurrentMethod() {
        return this.fCurrentMethod;
    }

    protected String makeLanguageDependentValue(ASTNode expr) {
        return "";
    }

    protected void onEndVisitMethod(MethodDeclaration method) {
    }

    protected String[] processSuperClasses(TypeDeclaration type) {
        List names = type.getSuperClassNames();
        if (names == null) {
            return null;
        }
        if (names.isEmpty()) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    protected void onEndVisitClass(TypeDeclaration type) {
    }

    protected String makeValue(ASTNode stmt) {
        String value = "";
        value = stmt instanceof StringLiteral ? "\"" + ((StringLiteral)stmt).getValue() + "\"" : (stmt instanceof Literal ? ((Literal)stmt).getValue() : String.valueOf(value) + this.makeLanguageDependentValue(stmt));
        return value;
    }

    public boolean endvisit(MethodDeclaration method) throws Exception {
        this.fRequestor.exitMethod(method.sourceEnd());
        this.fInMethod = false;
        this.fCurrentMethod = null;
        this.onEndVisitMethod(method);
        this.fNodes.pop();
        return true;
    }

    public boolean endvisit(TypeDeclaration type) throws Exception {
        this.fRequestor.exitType(type.sourceEnd());
        this.fInClass = false;
        this.onEndVisitClass(type);
        this.fNodes.pop();
        return true;
    }

    public boolean visit(MethodDeclaration method) throws Exception {
        this.fNodes.push(method);
        List args = method.getArguments();
        String[] parameter = new String[args.size()];
        int a = 0;
        while (a < args.size()) {
            Argument arg = (Argument)args.get(a);
            parameter[a] = arg.getName();
            ++a;
        }
        ISourceElementRequestor.MethodInfo mi = new ISourceElementRequestor.MethodInfo();
        mi.parameterNames = parameter;
        mi.name = method.getName();
        mi.modifiers = method.getModifiers();
        mi.nameSourceStart = method.getNameStart();
        mi.nameSourceEnd = method.getNameEnd() - 1;
        mi.declarationStart = method.sourceStart();
        this.fRequestor.enterMethod(mi);
        this.fInMethod = true;
        this.fCurrentMethod = method;
        return true;
    }

    public boolean visit(TypeDeclaration type) throws Exception {
        this.fNodes.push(type);
        ISourceElementRequestor.TypeInfo info = new ISourceElementRequestor.TypeInfo();
        info.modifiers = type.getModifiers();
        info.name = type.getName();
        info.nameSourceStart = type.getNameStart();
        info.nameSourceEnd = type.getNameEnd() - 1;
        info.declarationStart = type.sourceStart();
        info.superclasses = this.processSuperClasses(type);
        this.fRequestor.enterType(info);
        this.fInClass = true;
        return true;
    }

    public boolean endvisit(ModuleDeclaration declaration) throws Exception {
        this.fRequestor.exitModule(declaration.sourceEnd());
        this.fNodes.pop();
        return true;
    }

    public boolean visit(ModuleDeclaration declaration) throws Exception {
        this.fNodes.push(declaration);
        this.fRequestor.enterModule();
        return true;
    }

    public boolean endvisit(Expression expression) throws Exception {
        this.fNodes.pop();
        return true;
    }

    public boolean endvisit(Statement statement) throws Exception {
        this.fNodes.pop();
        return true;
    }

    public boolean visit(Expression expression) throws Exception {
        this.fNodes.push(expression);
        return true;
    }

    public boolean visit(Statement statement) throws Exception {
        this.fNodes.push(statement);
        return true;
    }
}

