/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterLibraryBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.IAddInterpreterDialogRequestor;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AddScriptInterpreterDialog
extends StatusDialog {
    private IAddInterpreterDialogRequestor fRequestor;
    private IInterpreterInstallType[] fInterpreterTypes;
    private IInterpreterInstallType fSelectedInterpreterType;
    private ComboDialogField fInterpreterTypeCombo;
    private IInterpreterInstall fEditedInterpreter;
    private AbstractInterpreterLibraryBlock fLibraryBlock;
    private StringButtonDialogField fInterpreterPath;
    private StringDialogField fInterpreterName;
    private StringDialogField fInterpreterArgs;
    private IStatus[] fStati;
    private int fPrevIndex = -1;

    protected boolean useInterpreterArgs() {
        return true;
    }

    public AddScriptInterpreterDialog(IAddInterpreterDialogRequestor requestor, Shell shell, IInterpreterInstallType[] interpreterInstallTypes, IInterpreterInstall editedInterpreter) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRequestor = requestor;
        this.fStati = new IStatus[5];
        int i = 0;
        while (i < this.fStati.length) {
            this.fStati[i] = new StatusInfo();
            ++i;
        }
        this.fInterpreterTypes = interpreterInstallTypes;
        this.fSelectedInterpreterType = editedInterpreter != null ? editedInterpreter.getInterpreterInstallType() : interpreterInstallTypes[0];
        this.fEditedInterpreter = editedInterpreter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected void createDialogFields() {
        this.fInterpreterTypeCombo = new ComboDialogField(8);
        this.fInterpreterTypeCombo.setLabelText(InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentType);
        this.fInterpreterTypeCombo.setItems(this.getInterpreterTypeNames());
        this.fInterpreterName = new StringDialogField();
        this.fInterpreterName.setLabelText(InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentName);
        this.fInterpreterPath = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                AddScriptInterpreterDialog.this.browseForInstallation();
            }
        });
        this.fInterpreterPath.setLabelText(InterpretersMessages.addInterpreterDialog_InterpreterExecutableName);
        this.fInterpreterPath.setButtonLabel(InterpretersMessages.addInterpreterDialog_browse1);
        if (this.useInterpreterArgs()) {
            this.fInterpreterArgs = new StringDialogField();
            this.fInterpreterArgs.setLabelText(InterpretersMessages.AddInterpreterDialog_iArgs);
        }
    }

    protected void createFieldListeners() {
        this.fInterpreterTypeCombo.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddScriptInterpreterDialog.this.updateInterpreterType();
            }
        });
        this.fInterpreterName.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddScriptInterpreterDialog.this.setInterpreterNameStatus(AddScriptInterpreterDialog.this.validateInterpreterName());
                AddScriptInterpreterDialog.this.updateStatusLine();
            }
        });
        this.fInterpreterPath.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddScriptInterpreterDialog.this.setInterpreterLocationStatus(AddScriptInterpreterDialog.this.validateInterpreterLocation());
                AddScriptInterpreterDialog.this.updateStatusLine();
            }
        });
    }

    protected String getInterpreterName() {
        return this.fInterpreterName.getText();
    }

    protected abstract AbstractInterpreterLibraryBlock createLibraryBlock(AddScriptInterpreterDialog var1);

    protected Control createDialogArea(Composite ancestor) {
        this.createDialogFields();
        Composite parent = (Composite)super.createDialogArea(ancestor);
        ((GridLayout)parent.getLayout()).numColumns = 3;
        this.fInterpreterTypeCombo.doFillIntoGrid(parent, 3);
        ((GridData)this.fInterpreterTypeCombo.getComboControl(null).getLayoutData()).widthHint = this.convertWidthInCharsToPixels(50);
        this.fInterpreterName.doFillIntoGrid(parent, 3);
        this.fInterpreterPath.doFillIntoGrid(parent, 3);
        if (this.useInterpreterArgs()) {
            this.fInterpreterArgs.doFillIntoGrid(parent, 3);
            ((GridData)this.fInterpreterArgs.getTextControl(null).getLayoutData()).widthHint = this.convertWidthInCharsToPixels(50);
        }
        Label l = new Label(parent, 0);
        l.setText(InterpretersMessages.AddInterpreterDialog_Interpreter_system_libraries__1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        l.setLayoutData((Object)gd);
        this.fLibraryBlock = this.createLibraryBlock(this);
        Control block = this.fLibraryBlock.createControl(parent);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        block.setLayoutData((Object)gd);
        Text t = this.fInterpreterPath.getTextControl(parent);
        gd = (GridData)t.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.initializeFields();
        this.createFieldListeners();
        AddScriptInterpreterDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void updateInterpreterType() {
        int selIndex = this.fInterpreterTypeCombo.getSelectionIndex();
        if (selIndex == this.fPrevIndex) {
            return;
        }
        this.fPrevIndex = selIndex;
        if (selIndex >= 0 && selIndex < this.fInterpreterTypes.length) {
            this.fSelectedInterpreterType = this.fInterpreterTypes[selIndex];
        }
        this.setInterpreterLocationStatus(this.validateInterpreterLocation());
        this.fLibraryBlock.initializeFrom(this.fEditedInterpreter, this.fSelectedInterpreterType);
        this.updateStatusLine();
    }

    public void create() {
        super.create();
        this.fInterpreterName.setFocus();
        this.selectInterpreterType();
    }

    private String[] getInterpreterTypeNames() {
        String[] names = new String[this.fInterpreterTypes.length];
        int i = 0;
        while (i < this.fInterpreterTypes.length) {
            names[i] = this.fInterpreterTypes[i].getName();
            ++i;
        }
        return names;
    }

    private void selectInterpreterType() {
        int i = 0;
        while (i < this.fInterpreterTypes.length) {
            if (this.fSelectedInterpreterType == this.fInterpreterTypes[i]) {
                this.fInterpreterTypeCombo.selectItem(i);
                return;
            }
            ++i;
        }
    }

    private void initializeFields() {
        this.fInterpreterTypeCombo.setItems(this.getInterpreterTypeNames());
        if (this.fEditedInterpreter == null) {
            this.fInterpreterName.setText("");
            this.fInterpreterPath.setText("");
            this.fLibraryBlock.initializeFrom(null, this.fSelectedInterpreterType);
            if (this.useInterpreterArgs()) {
                this.fInterpreterArgs.setText("");
            }
        } else {
            this.fInterpreterTypeCombo.setEnabled(false);
            this.fInterpreterName.setText(this.fEditedInterpreter.getName());
            this.fInterpreterPath.setText(this.fEditedInterpreter.getInstallLocation().toString());
            this.fLibraryBlock.initializeFrom(this.fEditedInterpreter, this.fSelectedInterpreterType);
            String InterpreterArgs = this.fEditedInterpreter.getInterpreterArgs();
            if (InterpreterArgs != null) {
                this.fInterpreterArgs.setText(InterpreterArgs);
            }
        }
        this.setInterpreterNameStatus(this.validateInterpreterName());
        this.updateStatusLine();
    }

    private IInterpreterInstallType getInterpreterType() {
        return this.fSelectedInterpreterType;
    }

    private IStatus validateInterpreterLocation() {
        String locationName = this.fInterpreterPath.getText();
        StatusInfo s = null;
        File file = null;
        if (locationName.length() == 0) {
            s = new StatusInfo(1, InterpretersMessages.addInterpreterDialog_enterLocation);
        } else {
            file = new File(locationName);
            if (!file.exists()) {
                s = new StatusInfo(4, InterpretersMessages.addInterpreterDialog_locationNotExists);
            } else {
                final IStatus[] temp = new IStatus[1];
                final File tempFile = file;
                Runnable r = new Runnable(){

                    public void run() {
                        temp[0] = AddScriptInterpreterDialog.this.getInterpreterType().validateInstallLocation(tempFile);
                    }
                };
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
                s = temp[0];
            }
        }
        if (s.isOK()) {
            this.fLibraryBlock.setHomeDirectory(file);
            String name = this.fInterpreterName.getText();
            if (name == null || name.trim().length() == 0) {
                try {
                    String genName = null;
                    Path path = new Path(file.getCanonicalPath());
                    int segs = path.segmentCount();
                    if (segs == 1) {
                        genName = path.segment(0);
                    } else if (segs >= 2) {
                        String last;
                        genName = last = path.lastSegment();
                    }
                    if (genName != null) {
                        this.fInterpreterName.setText(genName);
                    }
                }
                catch (IOException iOException) {}
            }
        } else {
            this.fLibraryBlock.setHomeDirectory(null);
        }
        this.fLibraryBlock.restoreDefaultLibraries();
        return s;
    }

    private IStatus validateInterpreterName() {
        StatusInfo status = new StatusInfo();
        String name = this.fInterpreterName.getText();
        if (name == null || name.trim().length() == 0) {
            status.setInfo(InterpretersMessages.addInterpreterDialog_enterName);
        } else if (this.fRequestor.isDuplicateName(name) && (this.fEditedInterpreter == null || !name.equals(this.fEditedInterpreter.getName()))) {
            status.setError(InterpretersMessages.addInterpreterDialog_duplicateName);
        }
        return status;
    }

    public void updateStatusLine() {
        IStatus max = null;
        int i = 0;
        while (i < this.fStati.length) {
            IStatus curr = this.fStati[i];
            if (curr.matches(4)) {
                this.updateStatus(curr);
                return;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        this.updateStatus(max);
    }

    private void browseForInstallation() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterPath(this.fInterpreterPath.getText());
        if (Platform.getOS().equals("win32")) {
            dialog.setFilterExtensions(new String[]{"*.exe;*.bat;*.exe"});
        } else {
            dialog.setFilterExtensions(new String[]{"*"});
        }
        dialog.setFilterNames(new String[]{"Executables"});
        String newPath = dialog.open();
        if (newPath != null) {
            this.fInterpreterPath.setText(newPath);
        }
    }

    protected void okPressed() {
        this.doOkPressed();
        super.okPressed();
    }

    private void doOkPressed() {
        if (this.fEditedInterpreter == null) {
            InterpreterStandin Interpreter = new InterpreterStandin(this.fSelectedInterpreterType, this.createUniqueId(this.fSelectedInterpreterType));
            this.setFieldValuesToInterpreter((IInterpreterInstall)Interpreter);
            this.fRequestor.interpreterAdded((IInterpreterInstall)Interpreter);
        } else {
            this.setFieldValuesToInterpreter(this.fEditedInterpreter);
        }
    }

    private String createUniqueId(IInterpreterInstallType InterpreterType) {
        String id = null;
        while (InterpreterType.findInterpreterInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    protected void setFieldValuesToInterpreter(IInterpreterInstall Interpreter) {
        File dir = new File(this.fInterpreterPath.getText());
        Interpreter.setInstallLocation(dir);
        Interpreter.setName(this.fInterpreterName.getText());
        if (this.useInterpreterArgs()) {
            String argString = this.fInterpreterArgs.getText().trim();
            if (argString != null && argString.length() > 0) {
                Interpreter.setInterpreterArgs(argString);
            } else {
                Interpreter.setInterpreterArgs(null);
            }
        } else {
            Interpreter.setInterpreterArgs(null);
        }
        this.fLibraryBlock.performApply(Interpreter);
    }

    private void setInterpreterNameStatus(IStatus status) {
        this.fStati[0] = status;
    }

    private void setInterpreterLocationStatus(IStatus status) {
        this.fStati[1] = status;
    }

    protected IStatus getSystemLibraryStatus() {
        return this.fStati[3];
    }

    public void setSystemLibraryStatus(IStatus status) {
        this.fStati[3] = status;
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(status.getSeverity() == 0);
        }
    }

    public void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
    }

    protected String getDialogSettingsSectionName() {
        return "ADD_INTERPRETER_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DLTKDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }
}

