/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.infoviews;

import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IWorkingCopyManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;

class TextSelectionConverter {
    private static final IModelElement[] EMPTY_RESULT = new IModelElement[0];

    private TextSelectionConverter() {
    }

    public static IModelElement[] codeResolve(ScriptEditor editor, ITextSelection selection) throws ModelException {
        return TextSelectionConverter.codeResolve(TextSelectionConverter.getInput(editor), selection);
    }

    public static IModelElement getElementAtOffset(ScriptEditor editor, ITextSelection selection) throws ModelException {
        return TextSelectionConverter.getElementAtOffset(TextSelectionConverter.getInput(editor), selection);
    }

    private static IModelElement getInput(ScriptEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        IWorkingCopyManager manager = DLTKUIPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    private static IModelElement[] codeResolve(IModelElement input, ITextSelection selection) throws ModelException {
        if (input instanceof ICodeAssist) {
            IModelElement[] elements;
            ISourceModule cunit;
            if (input instanceof ISourceModule && (cunit = (ISourceModule)input).isWorkingCopy()) {
                ScriptModelUtil.reconcile((ISourceModule)cunit);
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset(), selection.getLength())) != null && elements.length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    private static IModelElement getElementAtOffset(IModelElement input, ITextSelection selection) throws ModelException {
        if (input instanceof ISourceModule) {
            IModelElement ref;
            ISourceModule cunit = (ISourceModule)input;
            if (cunit.isWorkingCopy()) {
                ScriptModelUtil.reconcile((ISourceModule)cunit);
            }
            if ((ref = cunit.getElementAt(selection.getOffset())) == null) {
                return input;
            }
            return ref;
        }
        return null;
    }
}

