/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.MembersOrderPreferenceCache;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ModelElementSorter
extends ViewerSorter {
    private static final int PROJECTS = 1;
    private static final int PROJECTFRAGMENT = 2;
    private static final int SCRIPTFOLDER = 4;
    private static final int SOURCEMODULES = 5;
    private static final int RESOURCEFOLDERS = 6;
    private static final int RESOURCES = 7;
    private static final int STORAGE = 8;
    private static final int PACKAGE_DECL = 9;
    private static final int MEMBERSOFFSET = 10;
    private static final int SCRIPT_ELEMENTS = 50;
    private static final int OTHERS = 51;
    private static final int CONTAINER = 60;
    private MembersOrderPreferenceCache fMemberOrderCache = DLTKUIPlugin.getDefault().getMemberOrderPreferenceCache();
    private Collator fNewCollator = null;
    static /* synthetic */ Class class$0;

    public ModelElementSorter() {
        super(null);
    }

    public int category(Object element) {
        if (element instanceof IModelElement) {
            block19: {
                try {
                    IModelElement je = (IModelElement)element;
                    switch (je.getElementType()) {
                        case 9: {
                            IMethod method = (IMethod)je;
                            if (method.isConstructor()) {
                                return this.getMemberCategory(1);
                            }
                            return this.getMemberCategory(2);
                        }
                        case 8: {
                            return this.getMemberCategory(3);
                        }
                        case 7: {
                            return this.getMemberCategory(0);
                        }
                        case 10: {
                            return 9;
                        }
                        case 4: {
                            return 4;
                        }
                        case 3: {
                            return 2;
                        }
                        case 2: {
                            return 1;
                        }
                        case 5: {
                            return 5;
                        }
                    }
                }
                catch (ModelException e) {
                    if (e.isDoesNotExist()) break block19;
                    DLTKUIPlugin.log(e);
                }
            }
            return 50;
        }
        if (element instanceof IFile) {
            return 7;
        }
        if (element instanceof IProject) {
            return 1;
        }
        if (element instanceof IContainer) {
            return 6;
        }
        if (element instanceof IStorage) {
            return 8;
        }
        if (element instanceof BuildPathContainer) {
            return 60;
        }
        return 51;
    }

    private int getMemberCategory(int kind) {
        int offset = this.fMemberOrderCache.getCategoryIndex(kind);
        return offset + 10;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cmp;
        String name2;
        String name1;
        int cat2;
        int cat1 = this.category(e1);
        if (this.needsBuildpathComparision(e1, cat1, e2, cat2 = this.category(e2))) {
            int p2;
            int p1;
            IProjectFragment root1 = this.getProjectFragment(e1);
            IProjectFragment root2 = this.getProjectFragment(e2);
            if (root1 == null) {
                if (root2 == null) {
                    return 0;
                }
                return 1;
            }
            if (root2 == null) {
                return -1;
            }
            if (!root1.getPath().equals((Object)root2.getPath()) && (p1 = this.getBuildpathIndex(root1)) != (p2 = this.getBuildpathIndex(root2))) {
                return p1 - p2;
            }
        }
        if (cat1 != cat2) {
            return cat1 - cat2;
        }
        if (cat1 == 1 || cat1 == 7 || cat1 == 6 || cat1 == 8 || cat1 == 51) {
            name1 = this.getNonScriptElementLabel(viewer, e1);
            name2 = this.getNonScriptElementLabel(viewer, e2);
            if (name1 != null && name2 != null) {
                return this.getNewCollator().compare(name1, name2);
            }
            return 0;
        }
        name1 = this.getElementName(e1);
        name2 = this.getElementName(e2);
        if (e1 instanceof IType) {
            if (name1.length() == 0) {
                if (name2.length() == 0) {
                    try {
                        String[] sc1 = ((IType)e1).getSuperClasses();
                        String[] sc2 = ((IType)e2).getSuperClasses();
                        if (sc1 != null && sc2 != null && sc1.length > 0 && sc2.length > 0) {
                            return this.getNewCollator().compare(sc1[0], sc2[0]);
                        }
                        return 0;
                    }
                    catch (ModelException modelException) {
                        return 0;
                    }
                }
                return 1;
            }
            if (name2.length() == 0) {
                return -1;
            }
        }
        if ((cmp = this.getNewCollator().compare(name1, name2)) != 0) {
            return cmp;
        }
        if (e1 instanceof IMethod) {
            String[] params2;
            String[] params1;
            block24: {
                params1 = null;
                try {
                    params1 = ((IMethod)e1).getParameters();
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
                params2 = null;
                try {
                    params2 = ((IMethod)e2).getParameters();
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block24;
                    e.printStackTrace();
                }
            }
            if (params1 != null && params2 != null) {
                int len = Math.min(params1.length, params2.length);
                int i = 0;
                while (i < len) {
                    cmp = this.getNewCollator().compare(params1[i], params2[i]);
                    if (cmp != 0) {
                        return cmp;
                    }
                    ++i;
                }
            }
            return params1.length - params2.length;
        }
        return 0;
    }

    private IProjectFragment getProjectFragment(Object element) {
        if (element instanceof BuildPathContainer) {
            BuildPathContainer cp = (BuildPathContainer)element;
            Object[] roots = cp.getProjectFragments();
            if (roots.length > 0) {
                return (IProjectFragment)roots[0];
            }
            return null;
        }
        return ScriptModelUtil.getProjectFragment((IModelElement)((IModelElement)element));
    }

    private String getNonScriptElementLabel(Viewer viewer, Object element) {
        IBaseLabelProvider prov;
        if (element instanceof IAdaptable) {
            IWorkbenchAdapter adapter;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return adapter.getLabel(element);
            }
        }
        if (viewer instanceof ContentViewer && (prov = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            return ((ILabelProvider)prov).getText(element);
        }
        return null;
    }

    private int getBuildpathIndex(IProjectFragment root) {
        try {
            IPath rootPath = root.getPath();
            IProjectFragment[] roots = root.getScriptProject().getProjectFragments();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getPath().equals((Object)rootPath)) {
                    return i;
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
        return Integer.MAX_VALUE;
    }

    private final Comparator getNewCollator() {
        if (this.fNewCollator == null) {
            this.fNewCollator = Collator.getInstance();
        }
        return this.fNewCollator;
    }

    private boolean needsBuildpathComparision(Object e1, int cat1, Object e2, int cat2) {
        if (cat1 == 2 && cat2 == 2 || cat1 == 60 && cat2 == 60 || cat1 == 4 && ((IScriptFolder)e1).getParent().getResource() instanceof IProject && cat2 == 2 || cat1 == 2 && cat2 == 4 && ((IScriptFolder)e2).getParent().getResource() instanceof IProject) {
            IScriptProject p1 = this.getScriptProject(e1);
            return p1 != null && p1.equals(this.getScriptProject(e2));
        }
        return false;
    }

    private IScriptProject getScriptProject(Object element) {
        if (element instanceof IModelElement) {
            return ((IModelElement)element).getScriptProject();
        }
        if (element instanceof BuildPathContainer) {
            return ((BuildPathContainer)element).getScriptProject();
        }
        return null;
    }

    protected String getElementName(Object element) {
        if (element instanceof IModelElement) {
            return ((IModelElement)element).getElementName();
        }
        if (element instanceof BuildPathContainer) {
            return ((BuildPathContainer)element).getLabel(element);
        }
        return element.toString();
    }
}

