/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.launching.debug;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.launching.DebuggingEngineRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.tcl.internal.debug.TclDebugPreferences;

public class ActiveStateDebuggerRunner
extends DebuggingEngineRunner {
    private static final String HOST_KEY = "-host-ide";
    private static final String PORT_KEY = "-port-ide";
    private static final String SHELL_KEY = "-app-shell";
    private static final String IDE_KEY = "-ide-key";
    private static final String SCRIPT_KEY = "-app-file";
    private static final String ARGS_SEPARATOR = "--";

    protected File getEngine() throws CoreException {
        File engine = new File(TclDebugPreferences.getDebuggingEnginePath());
        if (!engine.isFile()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.tcl.launching", 180, "Tcl debugging engine not configured", null));
        }
        return engine;
    }

    public ActiveStateDebuggerRunner(IInterpreterInstall install) {
        super(install);
    }

    protected InterpreterConfig alterConfig(String exe, InterpreterConfig config) throws CoreException {
        String host = (String)config.getProperty("host");
        String port = (String)config.getProperty("port");
        String sessionId = (String)config.getProperty("sessionId");
        InterpreterConfig newConfig = new InterpreterConfig();
        newConfig.addEnvVars(config.getEnvVars());
        newConfig.setWorkingDirectory(config.getWorkingDirectory());
        newConfig.setProperty("OVERRIDE_EXE", (Object)this.getEngine().toString());
        newConfig.addInterpreterArg(HOST_KEY);
        newConfig.addInterpreterArg(host);
        newConfig.addInterpreterArg(PORT_KEY);
        newConfig.addInterpreterArg(port);
        newConfig.addInterpreterArg(SHELL_KEY);
        newConfig.addInterpreterArg(exe);
        newConfig.addInterpreterArg(IDE_KEY);
        newConfig.addInterpreterArg(sessionId);
        newConfig.addInterpreterArg(SCRIPT_KEY);
        newConfig.setScriptFile(config.getScriptFile());
        newConfig.addScriptArg(ARGS_SEPARATOR);
        newConfig.addScriptArgs(config.getScriptArgs());
        return newConfig;
    }
}

