/*
 * Decompiled with CFR 0.152.
 */
package com.xored.org.mozilla.javascript;

import com.xored.org.mozilla.javascript.BaseFunction;
import com.xored.org.mozilla.javascript.Context;
import com.xored.org.mozilla.javascript.Decompiler;
import com.xored.org.mozilla.javascript.NativeCall;
import com.xored.org.mozilla.javascript.ScriptRuntime;
import com.xored.org.mozilla.javascript.Scriptable;
import com.xored.org.mozilla.javascript.UintMap;
import com.xored.org.mozilla.javascript.debug.DebuggableScript;

public abstract class NativeFunction
extends BaseFunction {
    public final void initScriptFunction(Context cx, Scriptable scope) {
        ScriptRuntime.setFunctionProtoAndParent(this, scope);
    }

    final String decompile(int indent, int flags) {
        String encodedSource = this.getEncodedSource();
        if (encodedSource == null) {
            return super.decompile(indent, flags);
        }
        UintMap properties = new UintMap(1);
        properties.put(1, indent);
        return new Decompiler().decompile(encodedSource, flags, properties);
    }

    public int getLength() {
        int paramCount = this.getParamCount();
        if (this.getLanguageVersion() != 120) {
            return paramCount;
        }
        Context cx = Context.getContext();
        NativeCall activation = ScriptRuntime.findFunctionActivation(cx, this);
        if (activation == null) {
            return paramCount;
        }
        return activation.originalArgs.length;
    }

    public int getArity() {
        return this.getParamCount();
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }

    public String getEncodedSource() {
        return null;
    }

    public DebuggableScript getDebuggableView() {
        return null;
    }

    protected abstract int getLanguageVersion();

    protected abstract int getParamCount();

    protected abstract int getParamAndVarCount();

    protected abstract String getParamOrVarName(int var1);
}

