/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser;

import com.xored.org.mozilla.javascript.CompilerEnvirons;
import com.xored.org.mozilla.javascript.ErrorReporter;
import com.xored.org.mozilla.javascript.EvaluatorException;
import com.xored.org.mozilla.javascript.FunctionNode;
import com.xored.org.mozilla.javascript.Parser;
import com.xored.org.mozilla.javascript.ScriptOrFnNode;
import java.io.CharArrayReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.javascript.parser.JavaScriptModuleDeclaration;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.TypeInferencer;

public class JavaScriptSourceParser
extends AbstractSourceParser {
    ModelElement element;

    public JavaScriptSourceParser(IModelElement parent) {
        this.element = (ModelElement)parent;
    }

    public JavaScriptSourceParser() {
    }

    public ModuleDeclaration parse(char[] fileName, char[] content, IProblemReporter r) {
        JavaScriptModuleDeclaration moduleDeclaration = new JavaScriptModuleDeclaration(content.length);
        CompilerEnvirons cenv = new CompilerEnvirons();
        ErrorReporter reporter = new ErrorReporter(){

            public void error(String arg0, String arg1, int arg2, String arg3, int arg4) {
            }

            public EvaluatorException runtimeError(String arg0, String arg1, int arg2, String arg3, int arg4) {
                return null;
            }

            public void warning(String arg0, String arg1, int arg2, String arg3, int arg4) {
            }
        };
        Parser parser = new Parser(cenv, reporter);
        try {
            ScriptOrFnNode parse = parser.parse(new CharArrayReader(content), "", 0);
            TypeInferencer interferencer = new TypeInferencer(this.element, new ReferenceResolverContext(null, new HashMap()));
            ReferenceRecordingRequestor referenceRecordingRequestor = new ReferenceRecordingRequestor();
            interferencer.setRequestor(referenceRecordingRequestor);
            interferencer.doInterferencing(parse, Integer.MAX_VALUE);
            moduleDeclaration.setCollection(interferencer.getCollection());
            moduleDeclaration.setFunctionMap(interferencer.getFunctionMap());
            moduleDeclaration.setReferences(referenceRecordingRequestor.references);
            this.processNode(parse, moduleDeclaration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return moduleDeclaration;
    }

    private void processNode(ScriptOrFnNode parse, ModuleDeclaration moduleDeclaration) {
        FunctionNode n;
        int a = 0;
        while (a < parse.getFunctionCount()) {
            FunctionNode functionNode = parse.getFunctionNode(a);
            functionNode.getFunctionName();
            ISourceElementRequestor.MethodInfo methodInfo = new ISourceElementRequestor.MethodInfo();
            String functionName = functionNode.getFunctionName();
            if (functionName.length() != 0) {
                methodInfo.name = functionName;
                String functionComments = functionNode.getFunctionComments();
                int declarationStart = functionNode.getEncodedSourceStart();
                String[] paramsAndVars = functionNode.getParamAndVarNames();
                String[] params = new String[functionNode.getParamCount()];
                int i = 0;
                while (i < params.length) {
                    params[i] = paramsAndVars[i];
                    ++i;
                }
                int nameSourceStart = functionNode.nameStart;
                int nameSourceEnd = functionNode.nameEnd;
                this.processNode(functionNode, null);
                MethodDeclaration decl = new MethodDeclaration(functionName, nameSourceStart, nameSourceEnd, declarationStart, functionNode.getEncodedSourceEnd());
                decl.setComments(functionComments);
                if (moduleDeclaration != null) {
                    moduleDeclaration.addStatement((Statement)decl);
                }
            }
            ++a;
        }
        String[] paramsAndVars = parse.getParamAndVarNames();
        String[] params = new String[parse.getParamCount()];
        int i = 0;
        while (i < params.length) {
            params[i] = paramsAndVars[i];
            ++i;
        }
        int of = 0;
        if (parse instanceof FunctionNode && (n = (FunctionNode)parse).getFunctionType() != 1) {
            of = 1;
        }
        int i2 = params.length;
        while (i2 < paramsAndVars.length - of) {
            String name = paramsAndVars[i2];
            ScriptOrFnNode.Position p = parse.getPosition(i2);
            FieldDeclaration decl = new FieldDeclaration(name, p.start, p.start + name.length(), p.start, p.start + name.length());
            decl.setComments(parse.getParamComments(name));
            if (moduleDeclaration != null) {
                moduleDeclaration.addStatement((Statement)decl);
            }
            ++i2;
        }
    }

    private final class ReferenceRecordingRequestor
    implements ISourceElementRequestor {
        ArrayList references = new ArrayList();

        private ReferenceRecordingRequestor() {
        }

        public void acceptFieldReference(char[] fieldName, int sourcePosition) {
        }

        public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition, int sourceEndPosition) {
            this.references.add(new SimpleReference(sourcePosition, sourceEndPosition, new String(methodName)));
        }

        public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        }

        public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
        }

        public void acceptTypeReference(char[] typeName, int sourcePosition) {
        }

        public void enterField(ISourceElementRequestor.FieldInfo info) {
        }

        public boolean enterFieldCheckDuplicates(ISourceElementRequestor.FieldInfo info) {
            return false;
        }

        public boolean enterFieldWithParentType(ISourceElementRequestor.FieldInfo info, String parentName, String delimiter) {
            return false;
        }

        public void enterMethod(ISourceElementRequestor.MethodInfo info) {
        }

        public void enterMethodRemoveSame(ISourceElementRequestor.MethodInfo info) {
        }

        public boolean enterMethodWithParentType(ISourceElementRequestor.MethodInfo info, String parentName, String delimiter) {
            return false;
        }

        public void enterModule() {
        }

        public void enterModuleRoot() {
        }

        public void enterType(ISourceElementRequestor.TypeInfo info) {
        }

        public boolean enterTypeAppend(String fullName, String delimiter) {
            return false;
        }

        public void exitField(int declarationEnd) {
        }

        public void exitMethod(int declarationEnd) {
        }

        public void exitModule(int declarationEnd) {
        }

        public void exitModuleRoot() {
        }

        public void exitType(int declarationEnd) {
        }
    }
}

