/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.base.DLTKChange;
import org.eclipse.dltk.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.dltk.internal.ui.model.DLTKElementResourceMapping;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;

abstract class PackageReorgChange
extends DLTKChange {
    private String fPackageHandle;
    private String fDestinationHandle;
    private INewNameQuery fNameQuery;
    static /* synthetic */ Class class$0;

    PackageReorgChange(IScriptFolder pack, IProjectFragment dest, INewNameQuery nameQuery) {
        this.fPackageHandle = pack.getHandleIdentifier();
        this.fDestinationHandle = dest.getHandleIdentifier();
        this.fNameQuery = nameQuery;
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws ModelException;

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return this.isValid(pm, 0);
    }

    public final Change perform(IProgressMonitor pm) throws CoreException {
        Change change;
        pm.beginTask(this.getName(), 1);
        try {
            IScriptFolder pack = this.getPackage();
            ResourceMapping mapping = DLTKElementResourceMapping.create(pack);
            Change result = this.doPerformReorg(pm);
            this.markAsExecuted(pack, mapping);
            change = result;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return change;
    }

    public Object getModifiedElement() {
        return this.getPackage();
    }

    IProjectFragment getDestination() {
        return (IProjectFragment)DLTKCore.create((String)this.fDestinationHandle);
    }

    IScriptFolder getPackage() {
        return (IScriptFolder)DLTKCore.create((String)this.fPackageHandle);
    }

    String getNewName() {
        if (this.fNameQuery == null) {
            return null;
        }
        return this.fNameQuery.getNewName();
    }

    private void markAsExecuted(IScriptFolder pack, ResourceMapping mapping) {
        ReorgExecutionLog log;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((log = (ReorgExecutionLog)this.getAdapter(clazz)) != null) {
            log.markAsProcessed((Object)pack);
            log.markAsProcessed((Object)mapping);
        }
    }
}

