/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.log;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.dbgp.IDbgpRawListener;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.log.ScriptDebugLogView;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class ScriptDebugLogManager
implements ILaunchListener,
IDebugEventSetListener,
IDbgpRawListener {
    private static ScriptDebugLogManager instance;
    private ScriptDebugLogView view;

    private ScriptDebugLogManager() {
    }

    public static ScriptDebugLogManager getInstance() {
        if (instance == null) {
            instance = new ScriptDebugLogManager();
        }
        return instance;
    }

    public void dbgpPacketReceived(String content) {
        this.append("<< " + content);
    }

    public void dbgpPacketSent(String content) {
        this.append(">> " + content);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.view == null) {
            return;
        }
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            this.append("Event: " + ScriptDebugLogManager.getDebugEventKind(event.getKind()) + " from " + event.getSource().getClass().getName());
            if (event.getKind() == 4) {
                this.handleCreateEvent(event);
            } else if (event.getKind() == 8) {
                this.handleTerminateEvent(event);
            }
            ++i;
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
        IDebugTarget target = launch.getDebugTarget();
        boolean loggingEnabled = LaunchConfigurationUtils.isDbgpLoggingEnabled((ILaunchConfiguration)launch.getLaunchConfiguration());
        if (!(target instanceof IScriptDebugTarget) || !loggingEnabled) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = DLTKDebugUIPlugin.getActivePage();
                if (page != null) {
                    try {
                        ScriptDebugLogManager.this.view = (ScriptDebugLogView)page.showView("org.eclipse.dltk.debug.ui.dbgpLogView");
                        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)ScriptDebugLogManager.this);
                    }
                    catch (PartInitException e) {
                        DLTKDebugUIPlugin.log(e);
                    }
                }
            }
        });
    }

    public void launchRemoved(ILaunch launch) {
    }

    protected synchronized void append(final String text) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ScriptDebugLogManager.this.view.append(String.valueOf(text) + "\n");
            }
        });
    }

    private static String getDebugEventKind(int kind) {
        String eventName = "UNKNOWN";
        switch (kind) {
            case 4: {
                eventName = "CREATE";
                break;
            }
            case 8: {
                eventName = "TERMINATE";
                break;
            }
            case 16: {
                eventName = "CHANGE";
                break;
            }
            case 2: {
                eventName = "SUSPEND";
                break;
            }
            case 1: {
                eventName = "RESUME";
                break;
            }
            case 32: {
                eventName = "MODEL_SPECIFIC";
            }
        }
        return eventName;
    }

    private void handleCreateEvent(DebugEvent event) {
        if (event.getSource() instanceof IScriptThread) {
            ((IScriptThread)event.getSource()).getDbgpSession().addRawListener((IDbgpRawListener)this);
        }
    }

    private void handleTerminateEvent(DebugEvent event) {
        if (event.getSource() instanceof IScriptThread) {
            ((IScriptThread)event.getSource()).getDbgpSession().removeRawListenr((IDbgpRawListener)this);
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        }
    }
}

