/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui;

import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.tcl.core.TclLanguageToolkit;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.text.SimpleTclSourceViewerConfiguration;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;

public class TclUILanguageToolkit
implements IDLTKUILanguageToolkit {
    private static TclUILanguageToolkit sToolkit = null;
    private static TclScriptElementLabels sInstance = new TclScriptElementLabels();
    private static final String INTERPRETERS_PREFERENCE_PAGE_ID = "org.eclipse.dltk.tcl.preferences.interpreters";
    private static final String DEBUG_PREFERENCE_PAGE_ID = "org.eclipse.dltk.tcl.preferences.debug";
    private static final String[] EDITOR_PREFERENCE_PAGES_IDS = new String[]{"org.eclipse.dltk.tcl.preferences.editor", "org.eclipse.dltk.tcl.preferences.templates", "org.eclipse.dltk.tcl.preferences.editor.syntaxcoloring", "org.eclipse.dltk.tcl.preferences.editor.hovers", "org.eclipse.dltk.tcl.preferences.editor.smarttyping", "org.eclipse.dltk.tcl.preferences.editor.folding", "org.eclipse.dltk.tcl.ui.assistance"};

    public static IDLTKUILanguageToolkit getInstance() {
        if (sToolkit == null) {
            sToolkit = new TclUILanguageToolkit();
        }
        return sToolkit;
    }

    public ScriptElementLabels getScriptElementLabels() {
        return sInstance;
    }

    public IPreferenceStore getPreferenceStore() {
        return TclUI.getDefault().getPreferenceStore();
    }

    public IDLTKLanguageToolkit getCoreToolkit() {
        return TclLanguageToolkit.getDefault();
    }

    public IDialogSettings getDialogSettings() {
        return TclUI.getDefault().getDialogSettings();
    }

    public String getPartitioningId() {
        return "__tcl_partitioning";
    }

    public String getEditorId(Object inputElement) {
        return "org.eclipse.dltk.tcl.ui.editor.TclEditor";
    }

    public String getInterpreterContainerId() {
        return "org.eclipse.dltk.tcl.launching.INTERPRETER_CONTAINER";
    }

    public ScriptUILabelProvider createScriptUILabelProvider() {
        return null;
    }

    public boolean getProvideMembers(ISourceModule element) {
        return true;
    }

    public ScriptTextTools getTextTools() {
        return TclUI.getDefault().internalgetTextTools();
    }

    public ScriptSourceViewerConfiguration createSourceViewerConfiguration() {
        return new SimpleTclSourceViewerConfiguration(this.getTextTools().getColorManager(), this.getPreferenceStore(), null, this.getPartitioningId(), false);
    }

    public String getInterpreterPreferencePage() {
        return INTERPRETERS_PREFERENCE_PAGE_ID;
    }

    public String getDebugPreferencePage() {
        return DEBUG_PREFERENCE_PAGE_ID;
    }

    public String[] getEditorPreferencePages() {
        return EDITOR_PREFERENCE_PAGES_IDS;
    }

    private static class TclScriptElementLabels
    extends ScriptElementLabels {
        private TclScriptElementLabels() {
        }

        public void getElementLabel(IModelElement element, long flags, StringBuffer buf) {
            StringBuffer buffer = new StringBuffer(60);
            super.getElementLabel(element, flags, buffer);
            String s = buffer.toString();
            if (s != null && !s.startsWith(element.getElementName()) && s.indexOf(36) != -1) {
                s = s.replaceAll("\\$", "::");
            }
            buf.append(s);
        }

        protected char getTypeDelimiter() {
            return '$';
        }
    }
}

