/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ScriptContentDescriber;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;

public class DLTKContentTypeManager {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidFileNameForContentType(IDLTKLanguageToolkit toolkit, IPath path) {
        Object var8_10;
        IContentDescription description;
        BufferedInputStream stream;
        IContentType type;
        int i;
        IContentType[] derived;
        Object file;
        if (DLTKContentTypeManager.isValidFileNameForContentType(toolkit, path.lastSegment())) {
            return true;
        }
        if (EnvironmentPathUtils.isFull(path) && (file = EnvironmentPathUtils.getFile(path)).exists() && file.isFile() && file.getName().indexOf(46) == -1) {
            derived = DLTKContentTypeManager.getDerivedContentTypes(toolkit.getLanguageContentType());
            i = 0;
            while (i < derived.length) {
                type = derived[i];
                stream = null;
                try {
                    block15: {
                        try {
                            stream = new BufferedInputStream(file.openInputStream(null), 2048);
                            description = type.getDescriptionFor((InputStream)stream, IContentDescription.ALL);
                            if (description == null || !DLTKContentTypeManager.checkDescription(type, description)) break block15;
                            var8_10 = null;
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break block15;
                            e.printStackTrace();
                        }
                        DLTKContentTypeManager.closeStream(stream);
                        return true;
                    }
                    var8_10 = null;
                }
                catch (Throwable throwable) {
                    var8_10 = null;
                    DLTKContentTypeManager.closeStream(stream);
                    throw throwable;
                }
                DLTKContentTypeManager.closeStream(stream);
                ++i;
            }
        }
        if (path.isAbsolute() && ((File)(file = path.toFile())).exists() && ((File)file).isFile() && ((File)file).getName().indexOf(46) == -1) {
            derived = DLTKContentTypeManager.getDerivedContentTypes(toolkit.getLanguageContentType());
            i = 0;
            while (i < derived.length) {
                type = derived[i];
                stream = null;
                try {
                    block16: {
                        try {
                            stream = new BufferedInputStream(new FileInputStream((File)file), 2048);
                            description = type.getDescriptionFor((InputStream)stream, IContentDescription.ALL);
                            if (description == null || !DLTKContentTypeManager.checkDescription(type, description)) break block16;
                            var8_10 = null;
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break block16;
                            e.printStackTrace();
                        }
                        DLTKContentTypeManager.closeStream(stream);
                        return true;
                    }
                    var8_10 = null;
                }
                catch (Throwable throwable) {
                    var8_10 = null;
                    DLTKContentTypeManager.closeStream(stream);
                    throw throwable;
                }
                DLTKContentTypeManager.closeStream(stream);
                ++i;
            }
        }
        return false;
    }

    private static void closeStream(InputStream stream) {
        block3: {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean isValidFileNameForContentType(IDLTKLanguageToolkit toolkit, String name) {
        IContentType[] derived = DLTKContentTypeManager.getDerivedContentTypes(toolkit.getLanguageContentType());
        int i = 0;
        while (i < derived.length) {
            IContentType type = derived[i];
            if (type.isAssociatedWith(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidResourceForContentType(IDLTKLanguageToolkit toolkit, IResource resource) {
        Preferences preferences;
        String value;
        IStatus status;
        if (resource instanceof IFile && (status = toolkit.validateSourceModule(resource)).getSeverity() != 0) {
            return false;
        }
        String lastSegment = resource.getFullPath().lastSegment();
        if (lastSegment != null && DLTKContentTypeManager.isValidFileNameForContentType(toolkit, lastSegment)) {
            return true;
        }
        if (!resource.isAccessible()) {
            return false;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        IEnvironment environment = EnvironmentManager.getEnvironment(project);
        if (environment == null) {
            return false;
        }
        if (!EnvironmentManager.isLocal(environment) && "disabled".equals(value = (preferences = DLTKCore.getPlugin().getPluginPreferences()).getString("org.eclipse.dltk.core.nonLocalEmptyFileContentCheking"))) {
            return false;
        }
        if (resource instanceof IFile) {
            IFile file;
            block22: {
                file = (IFile)resource;
                IContentType masterType = DLTKContentTypeManager.getMasterContentType(toolkit.getLanguageContentType());
                if (masterType == null) {
                    return false;
                }
                try {
                    IContentDescription descr = file.getContentDescription();
                    if (descr != null && descr.getContentType().isKindOf(masterType)) {
                        return true;
                    }
                }
                catch (CoreException e1) {
                    if (!DLTKCore.DEBUG) break block22;
                    e1.printStackTrace();
                }
            }
            IContentType[] derived = DLTKContentTypeManager.getDerivedContentTypes(toolkit.getLanguageContentType());
            String name = resource.getName();
            int i = 0;
            while (i < derived.length) {
                IContentType type = derived[i];
                if (type.isAssociatedWith(name)) {
                    return true;
                }
                ++i;
            }
            IPath path = file.getFullPath();
            if (path.getFileExtension() == null) {
                int i2 = 0;
                while (i2 < derived.length) {
                    Object var15_20;
                    IContentType type = derived[i2];
                    BufferedInputStream contents = null;
                    try {
                        block23: {
                            try {
                                contents = new BufferedInputStream(file.getContents(), 2048);
                                IContentDescription description = type.getDescriptionFor((InputStream)contents, IContentDescription.ALL);
                                if (description == null || !DLTKContentTypeManager.checkDescription(type, description)) break block23;
                                var15_20 = null;
                            }
                            catch (IOException e) {
                                if (DLTKCore.DEBUG) {
                                    e.printStackTrace();
                                }
                                break block23;
                            }
                            catch (CoreException e) {
                                if (!DLTKCore.DEBUG) break block23;
                                e.printStackTrace();
                            }
                            DLTKContentTypeManager.closeStream(contents);
                            return true;
                        }
                        var15_20 = null;
                    }
                    catch (Throwable throwable) {
                        var15_20 = null;
                        DLTKContentTypeManager.closeStream(contents);
                        throw throwable;
                    }
                    DLTKContentTypeManager.closeStream(contents);
                    ++i2;
                }
            }
        }
        return false;
    }

    private static IContentType getMasterContentType(String languageContentType) {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType masterContentType = manager.getContentType(languageContentType);
        return masterContentType;
    }

    private static boolean checkDescription(IContentType type, IContentDescription description) {
        Object object = description.getProperty(ScriptContentDescriber.DLTK_VALID);
        if (object != null && ScriptContentDescriber.TRUE.equals(object)) {
            return description.getContentType().isKindOf(type);
        }
        return false;
    }

    private static IContentType[] getDerivedContentTypes(String name) {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType masterContentType = manager.getContentType(name);
        if (masterContentType == null) {
            return new IContentType[0];
        }
        IContentType[] types = manager.getAllContentTypes();
        HashSet<IContentType> derived = new HashSet<IContentType>();
        int i = 0;
        while (i < types.length) {
            if (types[i].isKindOf(masterContentType)) {
                derived.add(types[i]);
            }
            ++i;
        }
        return derived.toArray(new IContentType[derived.size()]);
    }
}

