/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.parser.SourceParserManager;
import org.eclipse.dltk.codeassist.ICompletionEngine;
import org.eclipse.dltk.codeassist.ISelectionEngine;
import org.eclipse.dltk.compiler.problem.DefaultProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ICallHierarchyFactory;
import org.eclipse.dltk.core.ICallProcessor;
import org.eclipse.dltk.core.ICalleeProcessor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IFileHierarchyResolver;
import org.eclipse.dltk.core.IInterpreterContainerExtension;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISearchFactory;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.PriorityDLTKExtensionManager;
import org.eclipse.dltk.core.search.DLTKSearchParticipant;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.IMatchLocatorParser;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.MatchLocatorParser;
import org.eclipse.dltk.internal.core.InternalDLTKLanguageManager;

public class DLTKLanguageManager {
    public static IDLTKLanguageToolkit getLanguageToolkit(String natureId) {
        return (IDLTKLanguageToolkit)InternalDLTKLanguageManager.getLanguageToolkitsManager().getObject(natureId);
    }

    public static IDLTKLanguageToolkit[] getLanguageToolkits() {
        PriorityDLTKExtensionManager.ElementInfo[] elementInfos = InternalDLTKLanguageManager.getLanguageToolkitsManager().getElementInfos();
        IDLTKLanguageToolkit[] toolkits = new IDLTKLanguageToolkit[elementInfos.length];
        int j = 0;
        while (j < elementInfos.length) {
            toolkits[j] = (IDLTKLanguageToolkit)InternalDLTKLanguageManager.getLanguageToolkitsManager().getInitObject(elementInfos[j]);
            ++j;
        }
        return toolkits;
    }

    private static IDLTKLanguageToolkit findAppropriateToolkitByObject(Object object) {
        PriorityDLTKExtensionManager.ElementInfo[] elementInfos = InternalDLTKLanguageManager.getLanguageToolkitsManager().getElementInfos();
        int j = 0;
        while (j < elementInfos.length) {
            IDLTKLanguageToolkit toolkit = (IDLTKLanguageToolkit)InternalDLTKLanguageManager.getLanguageToolkitsManager().getInitObject(elementInfos[j]);
            if (object instanceof IResource) {
                if (DLTKContentTypeManager.isValidResourceForContentType(toolkit, (IResource)object)) {
                    return toolkit;
                }
            } else if (object instanceof IPath) {
                if (DLTKContentTypeManager.isValidFileNameForContentType(toolkit, (IPath)object)) {
                    return toolkit;
                }
            } else {
                return null;
            }
            ++j;
        }
        return null;
    }

    public static boolean hasScriptNature(IProject project) {
        return InternalDLTKLanguageManager.getLanguageToolkitsManager().findScriptNature(project) != null;
    }

    public static IDLTKLanguageToolkit getLanguageToolkit(IModelElement element) {
        IDLTKLanguageToolkit toolkit = (IDLTKLanguageToolkit)InternalDLTKLanguageManager.getLanguageToolkitsManager().getObject(element);
        if (toolkit == null && element != null && element.getElementType() == 5) {
            IDLTKLanguageToolkit tk;
            if (element.getResource() != null && (tk = DLTKLanguageManager.findAppropriateToolkitByObject(element.getResource())) != null) {
                return tk;
            }
            return DLTKLanguageManager.findAppropriateToolkitByObject(element.getPath());
        }
        return toolkit;
    }

    public static IDLTKLanguageToolkit findToolkit(IResource resource) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.findAppropriateToolkitByObject(resource);
        if (toolkit == null) {
            IScriptProject scriptProject = DLTKCore.create(resource.getProject());
            toolkit = DLTKLanguageManager.getLanguageToolkit(scriptProject);
        }
        return toolkit;
    }

    public static IDLTKLanguageToolkit findToolkit(IPath path) {
        return DLTKLanguageManager.findAppropriateToolkitByObject(path);
    }

    public static ISourceElementParser getSourceElementParser(String nature) {
        return (ISourceElementParser)InternalDLTKLanguageManager.getSourceElementParsersManager().getObject(nature);
    }

    public static ISourceElementParser getSourceElementParser(IModelElement element) {
        return (ISourceElementParser)InternalDLTKLanguageManager.getSourceElementParsersManager().getObject(element);
    }

    public static IProblemFactory getProblemFactory(String natureID) {
        IProblemFactory factory = (IProblemFactory)InternalDLTKLanguageManager.getProblemFactoryManager().getObject(natureID);
        if (factory != null) {
            return factory;
        }
        return new DefaultProblemFactory();
    }

    public static IProblemFactory getProblemFactory(IModelElement element) {
        IProblemFactory factory = (IProblemFactory)InternalDLTKLanguageManager.getProblemFactoryManager().getObject(element);
        if (factory != null) {
            return factory;
        }
        return new DefaultProblemFactory();
    }

    public static ICompletionEngine getCompletionEngine(String natureID) {
        return (ICompletionEngine)InternalDLTKLanguageManager.getCompletionEngineManager().getObject(natureID);
    }

    public static ISelectionEngine getSelectionEngine(String natureID) {
        return (ISelectionEngine)InternalDLTKLanguageManager.getSelectionEngineManager().getObject(natureID);
    }

    public static ISourceParser getSourceParser(String natureID) {
        return SourceParserManager.getInstance().getSourceParser(null, natureID);
    }

    public static DLTKSearchParticipant createSearchParticipant(String natureID) {
        DLTKSearchParticipant participant;
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(natureID);
        if (factory != null && (participant = factory.createSearchParticipant()) != null) {
            return participant;
        }
        return new DLTKSearchParticipant();
    }

    public static ISearchFactory getSearchFactory(String natureId) {
        return (ISearchFactory)InternalDLTKLanguageManager.getSearchManager().getObject(natureId);
    }

    public static MatchLocator createMatchLocator(String natureID, SearchPattern pattern, SearchRequestor requestor, IDLTKSearchScope scope, SubProgressMonitor subProgressMonitor) {
        MatchLocator locator;
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(natureID);
        if (factory != null && (locator = factory.createMatchLocator(pattern, requestor, scope, subProgressMonitor)) != null) {
            return locator;
        }
        return new MatchLocator(pattern, requestor, scope, (IProgressMonitor)subProgressMonitor);
    }

    public static SourceIndexerRequestor createSourceRequestor(String natureID) {
        SourceIndexerRequestor requestor;
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(natureID);
        if (factory != null && (requestor = factory.createSourceRequestor()) != null) {
            return requestor;
        }
        return new SourceIndexerRequestor();
    }

    public static IMatchLocatorParser createMatchParser(String natureID, MatchLocator matchLocator) {
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(natureID);
        if (factory != null) {
            return factory.createMatchParser(matchLocator);
        }
        return new MatchLocatorParser(matchLocator){};
    }

    public static ICalleeProcessor createCalleeProcessor(String natureID, IMethod member, IProgressMonitor progressMonitor, IDLTKSearchScope scope) {
        ICallHierarchyFactory factory = DLTKLanguageManager.getCallHierarchyFactory(natureID);
        if (factory != null) {
            ICalleeProcessor processor = factory.createCalleeProcessor(member, progressMonitor, scope);
            return processor;
        }
        return null;
    }

    private static ICallHierarchyFactory getCallHierarchyFactory(String natureId) {
        return (ICallHierarchyFactory)InternalDLTKLanguageManager.getCallHierarchyManager().getObject(natureId);
    }

    public static ICallProcessor createCallProcessor(String natureID) {
        ICallHierarchyFactory factory = DLTKLanguageManager.getCallHierarchyFactory(natureID);
        if (factory != null) {
            return factory.createCallProcessor();
        }
        return null;
    }

    public static IFileHierarchyResolver getFileHierarchyResolver(String natureId) {
        return (IFileHierarchyResolver)InternalDLTKLanguageManager.getFileHierarchyResolversManager().getObject(natureId);
    }

    public static IInterpreterContainerExtension getInterpreterContainerExtensions(IScriptProject project) {
        return (IInterpreterContainerExtension)InternalDLTKLanguageManager.getInterpreterContainerExtensionManager().getObject(project);
    }
}

