/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.mixin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.mixin.IMixinParser;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.AbstractIndexer;
import org.eclipse.dltk.internal.core.mixin.MixinManager;

public class MixinIndexer
extends AbstractIndexer {
    MixinIndexRequestor requestor = new MixinIndexRequestor();
    ISourceModule sourceModule;
    Index currentIndex;
    public int index;
    public String elementName;

    public MixinIndexer(SearchDocument document, ISourceModule module, Index currentIndex) {
        super(document);
        this.sourceModule = module;
        this.currentIndex = currentIndex;
    }

    public void indexDocument() {
        block5: {
            IDLTKLanguageToolkit toolkit = this.document.getToolkit();
            if (toolkit == null) {
                toolkit = DLTKLanguageManager.findToolkit((IPath)new Path(this.document.getPath()));
            }
            if (toolkit == null) {
                return;
            }
            try {
                IMixinParser parser = MixinManager.getMixinParser(toolkit.getNatureId());
                if (parser != null) {
                    parser.setRequirestor(this.requestor);
                    parser.parserSourceModule(false, this.sourceModule);
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block5;
                e.printStackTrace();
            }
        }
    }

    private class MixinIndexRequestor
    implements IMixinRequestor {
        private MixinIndexRequestor() {
        }

        public void reportElement(IMixinRequestor.ElementInfo info) {
            if (info.key.length() > 0) {
                MixinIndexer.this.addMixin(info.key.toCharArray());
            }
        }
    }
}

