/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parsers.raw;

import org.eclipse.dltk.tcl.internal.parsers.raw.BracesSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.CodeScanner;
import org.eclipse.dltk.tcl.internal.parsers.raw.CommandSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.ErrorDescription;
import org.eclipse.dltk.tcl.internal.parsers.raw.ISubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.MagicBackslashSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.NormalBackslashSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.QuotesSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.StopTclCommand;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclCommand;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclScript;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclTextUtils;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclWord;
import org.eclipse.dltk.tcl.internal.parsers.raw.VariableSubstitution;

public class SimpleTclParser {
    public static boolean handleError(ErrorDescription error) {
        return true;
    }

    public static String magicSubstitute(String src) {
        String regex = "\\\\\\r*\\n\\s*";
        return src.replaceAll(regex, " ");
    }

    public static ISubstitution getCVB(CodeScanner input) throws TclParseException {
        if (CommandSubstitution.iAm(input)) {
            return new CommandSubstitution();
        }
        if (VariableSubstitution.iAm(input)) {
            return new VariableSubstitution();
        }
        if (NormalBackslashSubstitution.iAm(input)) {
            return new NormalBackslashSubstitution();
        }
        if (MagicBackslashSubstitution.iAm(input)) {
            return new MagicBackslashSubstitution();
        }
        return null;
    }

    private static TclCommand nextCommand(CodeScanner input, boolean nest) throws TclParseException {
        TclCommand cmd;
        block26: {
            cmd = new TclCommand();
            cmd.setStart(input.getPosition());
            TclWord currentWord = null;
            while (true) {
                ISubstitution s;
                int ch;
                boolean eof;
                boolean bl = eof = (ch = input.read()) == -1;
                if (eof && cmd.getWords().size() == 0 && (currentWord == null || currentWord.empty())) {
                    return new StopTclCommand();
                }
                if (TclTextUtils.isTrueWhitespace(ch) || eof) {
                    if (currentWord != null) {
                        cmd.addWord(currentWord);
                    }
                    currentWord = null;
                    if (!eof) continue;
                    break block26;
                }
                input.unread();
                if (currentWord == null) {
                    currentWord = new TclWord();
                    currentWord.setStart(input.getPosition());
                }
                if (BracesSubstitution.iAm(input) && currentWord.empty()) {
                    s = new BracesSubstitution();
                    ((BracesSubstitution)s).readMe(input);
                    currentWord.add(s);
                    continue;
                }
                if (QuotesSubstitution.iAm(input) && currentWord.empty()) {
                    s = new QuotesSubstitution();
                    ((QuotesSubstitution)s).readMe(input);
                    currentWord.add(s);
                    continue;
                }
                if (cmd.getWords().size() == 0 && currentWord.empty()) {
                    if (ch == 35) {
                        input.read();
                        TclTextUtils.runToLineEnd(input);
                        return null;
                    }
                    if (ch == 93 && nest) {
                        input.read();
                        return new StopTclCommand();
                    }
                } else if (ch == 93 && nest) {
                    if (currentWord != null) {
                        cmd.addWord(currentWord);
                    }
                    break block26;
                }
                if ((s = SimpleTclParser.getCVB(input)) != null) {
                    s.readMe(input);
                    if (s instanceof MagicBackslashSubstitution) {
                        if (currentWord == null) continue;
                        if (!currentWord.empty()) {
                            currentWord.setEnd(((MagicBackslashSubstitution)s).getStart() - 1);
                            cmd.addWord(currentWord);
                        }
                        currentWord = null;
                        continue;
                    }
                    currentWord.add(s);
                    continue;
                }
                boolean cmdEnd = false;
                switch (ch) {
                    case 13: {
                        input.read();
                        int c1 = input.read();
                        if (c1 == 10) {
                            cmdEnd = true;
                            break;
                        }
                        if (c1 == -1) {
                            cmdEnd = true;
                            break;
                        }
                        input.unread();
                        currentWord.add((char)ch);
                        break;
                    }
                    case 10: {
                        input.read();
                        cmdEnd = true;
                        break;
                    }
                    case 59: {
                        input.read();
                        cmdEnd = true;
                        break;
                    }
                    default: {
                        input.read();
                        if (TclTextUtils.isWhitespace(ch)) break;
                        currentWord.add((char)ch);
                    }
                }
                if (cmdEnd) break;
            }
            if (currentWord != null) {
                cmd.addWord(currentWord);
            }
        }
        if (cmd.getWords().size() > 0) {
            TclWord w = (TclWord)cmd.getWords().get(cmd.getWords().size() - 1);
            cmd.setEnd(w.getEnd());
        } else {
            cmd.setEnd(cmd.getStart());
        }
        return cmd;
    }

    public static TclScript parse(CodeScanner input, boolean nest) throws TclParseException {
        TclCommand cmd;
        TclScript script = new TclScript();
        script.setStart(input.getPosition());
        while (!((cmd = SimpleTclParser.nextCommand(input, nest)) instanceof StopTclCommand)) {
            if (cmd == null || cmd.getWords().size() == 0) continue;
            script.addCommand(cmd);
        }
        script.setEnd(input.getPosition() - 1);
        return script;
    }

    public static TclScript parse(String content) throws TclParseException {
        CodeScanner scanner = new CodeScanner(content);
        TclScript script = SimpleTclParser.parse(scanner, false);
        return script;
    }
}

