/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.launcher;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationMigrationDelegate;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;

public class DLTKTestingMigrationDelegate
implements ILaunchConfigurationMigrationDelegate {
    protected static final String EMPTY_STRING = "";

    public boolean isCandidate(ILaunchConfiguration candidate) throws CoreException {
        IResource[] mapped = candidate.getMappedResources();
        IResource target = DLTKTestingMigrationDelegate.getResource(candidate);
        if (target == null) {
            return mapped == null;
        }
        if (mapped == null) {
            return true;
        }
        if (mapped.length != 1) {
            return true;
        }
        return !target.equals((Object)mapped[0]);
    }

    public void migrate(ILaunchConfiguration candidate) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = candidate.getWorkingCopy();
        DLTKTestingMigrationDelegate.mapResources(wc);
        wc.doSave();
    }

    public static void mapResources(ILaunchConfigurationWorkingCopy config) throws CoreException {
        IResource resource = DLTKTestingMigrationDelegate.getResource((ILaunchConfiguration)config);
        if (resource == null) {
            config.setMappedResources(null);
        } else {
            config.setMappedResources(new IResource[]{resource});
        }
    }

    private static IResource getResource(ILaunchConfiguration config) throws CoreException {
        String projName = config.getAttribute("project", null);
        String containerHandle = config.getAttribute("org.eclipse.dltk.testing.CONTAINER", null);
        IModelElement element = null;
        if (projName != null && Path.ROOT.isValidSegment(projName)) {
            IScriptProject javaProject = DLTKTestingMigrationDelegate.getModel().getScriptProject(projName);
            if (javaProject.exists()) {
                if (element == null) {
                    element = javaProject;
                }
            } else {
                IProject project = javaProject.getProject();
                if (project.exists() && !project.isOpen()) {
                    return project;
                }
            }
        } else if (containerHandle != null) {
            element = DLTKCore.create((String)containerHandle);
        }
        IResource resource = null;
        if (element != null) {
            resource = element.getResource();
        }
        return resource;
    }

    private static IScriptModel getModel() {
        return DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }
}

