/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.base.DLTKChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.AddToBuildpathChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DeleteFromBuildpathChange
extends DLTKChange {
    private final String fProjectHandle;
    private final IPath fPathToDelete;
    private IPath fPath;
    private int fEntryKind;

    public DeleteFromBuildpathChange(IProjectFragment root) {
        this(root.getPath(), root.getScriptProject());
    }

    DeleteFromBuildpathChange(IPath pathToDelete, IScriptProject project) {
        Assert.isNotNull((Object)pathToDelete);
        this.fPathToDelete = pathToDelete;
        this.fProjectHandle = project.getHandleIdentifier();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, 3);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        AddToBuildpathChange addToBuildpathChange;
        pm.beginTask(this.getName(), 1);
        try {
            IScriptProject project = this.getScriptProject();
            IBuildpathEntry[] cp = project.getRawBuildpath();
            IBuildpathEntry[] newCp = new IBuildpathEntry[cp.length - 1];
            int i = 0;
            int j = 0;
            while (j < newCp.length) {
                IBuildpathEntry current = cp[i];
                if (current != null && this.toBeDeleted(current)) {
                    ++i;
                    this.setDeletedEntryProperties(current);
                }
                newCp[j] = cp[i];
                ++i;
                ++j;
            }
            IBuildpathEntry last = cp[cp.length - 1];
            if (last != null && this.toBeDeleted(last)) {
                this.setDeletedEntryProperties(last);
            }
            project.setRawBuildpath(newCp, pm);
            addToBuildpathChange = new AddToBuildpathChange(this.getScriptProject(), this.fEntryKind, this.fPath);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return addToBuildpathChange;
    }

    private boolean toBeDeleted(IBuildpathEntry entry) {
        if (entry == null) {
            return false;
        }
        return this.fPathToDelete.equals((Object)entry.getPath());
    }

    private void setDeletedEntryProperties(IBuildpathEntry entry) {
        this.fEntryKind = entry.getEntryKind();
        this.fPath = entry.getPath();
    }

    private IScriptProject getScriptProject() {
        return (IScriptProject)DLTKCore.create((String)this.fProjectHandle);
    }

    public String getName() {
        return MessageFormat.format(RefactoringCoreMessages.DeleteFromClassPathChange_remove, this.getScriptProject().getElementName());
    }

    public Object getModifiedElement() {
        return this.getScriptProject();
    }
}

