/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui;

import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptExceptionBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.Messages;
import org.eclipse.dltk.debug.ui.breakpoints.BreakpointUtils;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.util.HandleFactory;
import org.eclipse.dltk.internal.debug.ui.ExternalFileEditorInput;
import org.eclipse.dltk.internal.debug.ui.ScriptDetailFormattersManager;
import org.eclipse.dltk.internal.debug.ui.ScriptEvaluationContextManager;
import org.eclipse.dltk.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.launching.debug.DebuggingEngineManager;
import org.eclipse.dltk.launching.debug.IDebuggingEngine;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public abstract class ScriptDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    private HashMap fAttributes = new HashMap();
    protected static final String SUSPENDED_LABEL = "suspended";
    protected static final String RUNNING_LABEL = "running";

    public static IDebuggingEngine getDebuggingEngine(IDebugElement element) {
        String id = element.getLaunch().getAttribute("debugging_engine_id");
        if (id == null) {
            return null;
        }
        return DebuggingEngineManager.getInstance().getDebuggingEngine(id);
    }

    public static IProject getProject(IDebugElement element) throws CoreException {
        ILaunchConfiguration configuration = element.getLaunch().getLaunchConfiguration();
        String projectName = configuration.getAttribute("project", null);
        if (projectName == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static IScriptThread getEvaluationThread(IScriptDebugTarget target) {
        IScriptThread thread = null;
        IScriptStackFrame frame = ScriptEvaluationContextManager.getEvaluationContext(null);
        if (frame != null) {
            thread = (IScriptThread)frame.getThread();
        }
        if (!(thread == null || thread.getDebugTarget().equals(target) && thread.isSuspended())) {
            thread = null;
        }
        if (thread == null) {
            try {
                IThread[] threads = target.getThreads();
                int i = 0;
                while (i < threads.length) {
                    if (threads[i].isSuspended()) {
                        thread = (IScriptThread)threads[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (DebugException e) {
                DLTKDebugUIPlugin.log(e);
            }
        }
        return thread;
    }

    protected String getDebugTargetText(IScriptDebugTarget target) {
        IDebuggingEngine engine = ScriptDebugModelPresentation.getDebuggingEngine((IDebugElement)target);
        if (engine != null) {
            return MessageFormat.format(Messages.ScriptDebugModelPresentation_debugTargetText, engine.getName(), target.getSessionId());
        }
        return target.toString();
    }

    protected String getThreadText(IScriptThread thread) {
        try {
            return MessageFormat.format(Messages.ScriptDebugModelPresentation_threadText, thread.getName(), thread.isSuspended() ? SUSPENDED_LABEL : RUNNING_LABEL);
        }
        catch (DebugException e) {
            DLTKDebugUIPlugin.log(e);
            return thread.toString();
        }
    }

    protected static IPath getStackFrameRelativePath(IScriptStackFrame stackFrame) throws CoreException {
        Path realPath;
        URI uri = stackFrame.getSourceURI();
        IProject project = ScriptDebugModelPresentation.getProject((IDebugElement)stackFrame);
        Path projectPath = new Path(project.getLocationURI().getPath());
        Path path = realPath = new Path(uri.getPath());
        if (projectPath.isPrefixOf((IPath)realPath)) {
            path = new Path("");
            int index = projectPath.segmentCount();
            while (index < realPath.segmentCount()) {
                path = path.append(realPath.segment(index));
                ++index;
            }
        }
        return path;
    }

    protected String getStackFrameText(IScriptStackFrame stackFrame) {
        try {
            ISourceModuleDocumentProvider provider;
            IDocument document;
            ILaunch launch;
            ISourceLocator sourceLocator;
            Object object;
            String sourceLine = stackFrame.getSourceLine();
            if ((sourceLine == null || sourceLine.length() == 0) && (object = (sourceLocator = (launch = stackFrame.getLaunch()).getSourceLocator()).getSourceElement((IStackFrame)stackFrame)) instanceof IFile && (document = (provider = DLTKUIPlugin.getDocumentProvider()).getDocument((Object)new FileEditorInput((IFile)object))) != null) {
                try {
                    IRegion region = document.getLineInformation(stackFrame.getLineNumber() - 1);
                    sourceLine = document.get(region.getOffset(), region.getLength()).trim();
                }
                catch (BadLocationException e) {
                    DLTKDebugUIPlugin.log(e);
                }
            }
            if (sourceLine == null || sourceLine.length() == 0) {
                int level = stackFrame.getStack().size() - stackFrame.getLevel() - 1;
                sourceLine = MessageFormat.format(Messages.ScriptDebugModelPresentation_stackFrameText, new Integer(level));
            }
            IPath path = ScriptDebugModelPresentation.getStackFrameRelativePath(stackFrame);
            return MessageFormat.format(Messages.ScriptDebugModelPresentation_stackFrameText2, sourceLine, path.toPortableString(), new Integer(stackFrame.getLineNumber()));
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.log(e);
            return stackFrame.toString();
        }
    }

    public String getVariableText(IScriptVariable variable) {
        try {
            String name = variable.getName();
            IScriptValue value = (IScriptValue)variable.getValue();
            if (value != null) {
                String valueText;
                IScriptType type;
                if (this.isShowVariableTypeNames() && (type = value.getType()) != null) {
                    String typeName = this.getTypeNameText(type);
                    name = String.valueOf(typeName) + " " + name;
                }
                if ((valueText = this.getValueText(value)) != null && valueText.length() > 0) {
                    return String.valueOf(name) + " = " + valueText;
                }
            }
            return name;
        }
        catch (DebugException e) {
            DLTKDebugUIPlugin.log(e);
            return variable.toString();
        }
    }

    protected String getValueText(IScriptValue value) {
        try {
            return value.getValueString();
        }
        catch (DebugException e) {
            DebugPlugin.log((Throwable)e);
            return value.toString();
        }
    }

    public String getDetailPaneText(IScriptValue value) {
        return this.getValueText(value);
    }

    protected String renderUnknownValue(IScriptValue value) throws DebugException {
        return value.getValueString();
    }

    protected String getBreakpointText(IScriptBreakpoint breakpoint) {
        try {
            StringBuffer sb = new StringBuffer();
            String language = BreakpointUtils.getLanguageToolkit(breakpoint).getLanguageName();
            int hitCount = breakpoint.getHitCount();
            if (breakpoint instanceof IScriptWatchpoint) {
                IScriptWatchpoint w = (IScriptWatchpoint)breakpoint;
                String file = w.getResourceName();
                int lineNumber = w.getLineNumber();
                String fieldName = w.getFieldName();
                sb.append(MessageFormat.format(Messages.ScriptDebugModelPresentation_breakpointText, language, file, new Integer(lineNumber), fieldName));
            } else if (breakpoint instanceof IScriptLineBreakpoint) {
                IScriptLineBreakpoint b = (IScriptLineBreakpoint)breakpoint;
                String file = b.getResourceName();
                int lineNumber = b.getLineNumber();
                sb.append(MessageFormat.format(Messages.ScriptDebugModelPresentation_breakpointText2, language, file, new Integer(lineNumber)));
            } else if (breakpoint instanceof IScriptExceptionBreakpoint) {
                IScriptExceptionBreakpoint b = (IScriptExceptionBreakpoint)breakpoint;
                String typeName = b.getTypeName();
                if (b.isSuspendOnSubclasses()) {
                    typeName = String.valueOf(typeName) + Messages.ScriptDebugModelPresentation_breakpointText3;
                }
                sb.append(MessageFormat.format(Messages.ScriptDebugModelPresentation_breakpointText4, language, typeName));
            }
            if (hitCount != -1) {
                sb.append(MessageFormat.format(Messages.ScriptDebugModelPresentation_breakpointText5, new Integer(hitCount)));
            }
            return sb.toString();
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.log(e);
            return breakpoint.toString();
        }
    }

    protected String getExpressionText(IExpression expression) {
        IErrorReportingExpression errorExpression;
        String expressionText = expression.getExpressionText();
        if (expression instanceof IErrorReportingExpression && (errorExpression = (IErrorReportingExpression)expression).hasErrors()) {
            return expressionText;
        }
        IScriptValue value = (IScriptValue)expression.getValue();
        if (value != null) {
            IScriptType type;
            if (this.isShowVariableTypeNames() && (type = value.getType()) != null) {
                String typeName = this.getTypeNameText(type);
                expressionText = String.valueOf(typeName) + " " + expressionText;
            }
            return MessageFormat.format(Messages.ScriptDebugModelPresentation_expressionText, expressionText, this.getValueText(value));
        }
        return expressionText;
    }

    public String getTypeNameText(IScriptType type) {
        return type.getName();
    }

    public final String getText(Object element) {
        if (element instanceof IScriptDebugTarget) {
            return this.getDebugTargetText((IScriptDebugTarget)element);
        }
        if (element instanceof IScriptBreakpoint) {
            return this.getBreakpointText((IScriptBreakpoint)element);
        }
        if (element instanceof IScriptThread) {
            return this.getThreadText((IScriptThread)element);
        }
        if (element instanceof IScriptStackFrame) {
            return this.getStackFrameText((IScriptStackFrame)element);
        }
        if (element instanceof IScriptVariable) {
            return this.getVariableText((IScriptVariable)element);
        }
        if (element instanceof IScriptValue) {
            return this.getValueText((IScriptValue)element);
        }
        if (element instanceof IExpression) {
            return this.getExpressionText((IExpression)element);
        }
        if (element instanceof IScriptType) {
            return this.getTypeNameText((IScriptType)element);
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        IScriptDebugTarget target = (IScriptDebugTarget)value.getDebugTarget();
        IScriptThread thread = ScriptDebugModelPresentation.getEvaluationThread(target);
        if (thread == null) {
            listener.detailComputed(value, this.getValueText((IScriptValue)value));
        } else {
            String natureId = target.getLanguageToolkit().getNatureId();
            ScriptDetailFormattersManager.getDefault(natureId).computeValueDetail((IScriptValue)value, thread, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String id, Object value) {
        if (value == null) {
            return;
        }
        HashMap hashMap = this.fAttributes;
        synchronized (hashMap) {
            this.fAttributes.put(id, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isShowVariableTypeNames() {
        HashMap hashMap = this.fAttributes;
        synchronized (hashMap) {
            Boolean show = (Boolean)this.fAttributes.get("org.eclipse.debug.ui.displayVariableTypeNames");
            show = show == null ? Boolean.FALSE : show;
            return show;
        }
    }

    protected Image getBreakpointImage(IScriptBreakpoint breakpoint) {
        return null;
    }

    protected Image getVariableImage(IScriptVariable variable) {
        return null;
    }

    protected Image getThreadImage(IScriptThread thread) {
        return null;
    }

    protected Image getStackFrameImage(IScriptStackFrame frame) {
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof IScriptBreakpoint) {
            return this.getBreakpointImage((IScriptBreakpoint)element);
        }
        if (element instanceof IScriptVariable) {
            return this.getVariableImage((IScriptVariable)element);
        }
        if (element instanceof IScriptThread) {
            return this.getThreadImage((IScriptThread)element);
        }
        if (element instanceof IScriptStackFrame) {
            return this.getStackFrameImage((IScriptStackFrame)element);
        }
        return null;
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFileHandle) {
            return new ExternalFileEditorInput((IFileHandle)element);
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            return this.getLineBreakpointEditorInput(element);
        }
        if (element instanceof IStorage) {
            return new ExternalStorageEditorInput((IStorage)element);
        }
        return null;
    }

    private IEditorInput getLineBreakpointEditorInput(Object element) {
        ILineBreakpoint bp = (ILineBreakpoint)element;
        IMarker marker = bp.getMarker();
        IResource resource = marker.getResource();
        if (resource instanceof IFile) {
            return new FileEditorInput((IFile)resource);
        }
        try {
            IPath path = Path.fromPortableString((String)((String)marker.getAttribute("location")));
            String debugModelId = bp.getModelIdentifier();
            String natureId = ScriptDebugManager.getInstance().getNatureByDebugModel(debugModelId);
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)natureId);
            if (toolkit != null) {
                HandleFactory fac = new HandleFactory();
                IDLTKSearchScope scope = DLTKSearchScopeFactory.getInstance().createWorkspaceScope(true, toolkit);
                Openable openable = fac.createOpenable(path.toOSString(), scope);
                if (openable instanceof IStorage) {
                    return new ExternalStorageEditorInput((IStorage)openable);
                }
            }
        }
        catch (CoreException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return null;
    }

    public abstract String getEditorId(IEditorInput var1, Object var2);
}

