/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.log;

import org.eclipse.dltk.internal.debug.ui.log.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

public class ScriptDebugLogView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.dltk.debug.ui.dbgpLogView";
    private IDocument document;
    private TextViewer viewer;
    private IAction copyAction;
    private IAction clearAction;
    private final String COPY_ACTION_NAME = Messages.ScriptDebugLogView_copy;
    private final String CLEAR_ACTION_NAME = Messages.ScriptDebugLogView_clear;

    public ScriptDebugLogView() {
        this.document = new Document();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TextViewer(parent, 768);
        this.viewer.setInput((Object)this.document);
        this.viewer.setEditable(false);
        this.createActions();
        this.createMenu();
        this.createToolbar();
        this.createContextMenu();
    }

    public void append(String text) {
        try {
            this.document.replace(this.document.getLength(), 0, text);
            this.viewer.revealRange(this.document.getLength(), 0);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void createActions() {
        this.copyAction = new Action(this.COPY_ACTION_NAME){

            public void run() {
                ScriptDebugLogView.this.viewer.doOperation(4);
            }
        };
        this.clearAction = new Action(this.CLEAR_ACTION_NAME){

            public void run() {
                try {
                    ScriptDebugLogView.this.document.replace(0, ScriptDebugLogView.this.document.getLength(), "");
                }
                catch (BadLocationException badLocationException) {}
            }
        };
    }

    private void createMenu() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add(this.copyAction);
        manager.add(this.clearAction);
    }

    private void createToolbar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add(this.copyAction);
        manager.add(this.clearAction);
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ScriptDebugLogView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add(this.copyAction);
        manager.add(this.clearAction);
        manager.add((IContributionItem)new Separator("additions"));
    }
}

