/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.utils;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.IDbgpSessionInfo;
import org.eclipse.dltk.dbgp.IDbgpStatus;
import org.eclipse.dltk.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.dbgp.exceptions.DbgpDebuggingEngineException;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.exceptions.DbgpProtocolException;
import org.eclipse.dltk.dbgp.internal.DbgpFeature;
import org.eclipse.dltk.dbgp.internal.DbgpProperty;
import org.eclipse.dltk.dbgp.internal.DbgpSessionInfo;
import org.eclipse.dltk.dbgp.internal.DbgpStackLevel;
import org.eclipse.dltk.dbgp.internal.DbgpStatus;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpCallBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpConditionalBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpExceptionBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpLineBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpReturnBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpWatchBreakpoint;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;
import org.eclipse.dltk.dbgp.internal.utils.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DbgpXmlEntityParser
extends DbgpXmlParser {
    private static final IDbgpProperty[] NO_CHILDREN = new IDbgpProperty[0];
    private static String ENCODING_NONE = "none";
    private static String ENCODING_BASE64 = "base64";

    protected DbgpXmlEntityParser() {
    }

    public static DbgpStackLevel parseStackLevel(Element element) throws DbgpException {
        int level = Integer.parseInt(element.getAttribute("level"));
        String cmdBegin = element.getAttribute("cmdbegin");
        String cmdEnd = element.getAttribute("cmdend");
        int lineBegin = -1;
        int lineEnd = -1;
        if (!"".equals(cmdBegin) && !"".equals(cmdEnd)) {
            lineBegin = DbgpXmlEntityParser.getPosition(cmdBegin);
            lineEnd = DbgpXmlEntityParser.getPosition(cmdEnd);
        }
        int lineNumber = Integer.parseInt(element.getAttribute("lineno"));
        String fileName = element.getAttribute("filename");
        URI fileUri = URI.create(fileName);
        String where = element.getAttribute("where");
        return new DbgpStackLevel(fileUri, where, level, lineNumber, lineBegin, lineEnd);
    }

    public static DbgpFeature parseFeature(Element element) throws DbgpProtocolException {
        String name = element.getAttribute("feature_name");
        boolean supported = DbgpXmlEntityParser.makeBoolean(element.getAttribute("supported"));
        String value = DbgpXmlEntityParser.parseContent(element);
        return new DbgpFeature(supported, name, value);
    }

    public static IDbgpProperty parseProperty(Element property) {
        String name = DbgpXmlEntityParser.getFromChildOrAttr(property, "name");
        String fullName = DbgpXmlEntityParser.getFromChildOrAttr(property, "fullname");
        String type = property.getAttribute("type");
        boolean hasChildren = false;
        if (property.hasAttribute("children")) {
            hasChildren = DbgpXmlEntityParser.makeBoolean(property.getAttribute("children"));
        }
        int childrenCount = -1;
        if (property.hasAttribute("numchildren")) {
            childrenCount = Integer.parseInt(property.getAttribute("numchildren"));
        }
        int page = 0;
        if (property.hasAttribute("page")) {
            page = Integer.parseInt(property.getAttribute("page"));
        }
        int pagesize = -1;
        if (property.hasAttribute("pagesize")) {
            pagesize = Integer.parseInt(property.getAttribute("pagesize"));
        }
        boolean constant = false;
        if (property.hasAttribute("constant")) {
            constant = DbgpXmlEntityParser.makeBoolean(property.getAttribute("constant"));
        }
        String key = null;
        if (property.hasAttribute("key")) {
            key = property.getAttribute("key");
        }
        String value = "";
        NodeList list = property.getElementsByTagName("value");
        value = list.getLength() == 0 ? DbgpXmlEntityParser.getEncodedValue(property) : DbgpXmlEntityParser.getEncodedValue((Element)list.item(0));
        IDbgpProperty[] availableChildren = NO_CHILDREN;
        if (hasChildren) {
            ArrayList<IDbgpProperty> childrenList = new ArrayList<IDbgpProperty>();
            NodeList properties = property.getChildNodes();
            int i = 0;
            while (i < properties.getLength()) {
                Node item = properties.item(i);
                if (item instanceof Element) {
                    childrenList.add(DbgpXmlEntityParser.parseProperty((Element)item));
                }
                ++i;
            }
            availableChildren = childrenList.toArray(new IDbgpProperty[childrenList.size()]);
        }
        if (childrenCount < 0) {
            childrenCount = availableChildren.length;
        }
        return new DbgpProperty(name, fullName, type, value, childrenCount, hasChildren, constant, key, availableChildren, page, pagesize);
    }

    public static IDbgpStatus parseStatus(Element element) throws DbgpProtocolException {
        String status = element.getAttribute("status");
        String reason = element.getAttribute("reason");
        return DbgpStatus.parse(status, reason);
    }

    public static IDbgpBreakpoint parseBreakpoint(Element element) {
        String type = element.getAttribute("type");
        String id = element.getAttribute("id");
        boolean enabled = element.getAttribute("state").equals("enabled");
        int hitCount = DbgpXmlEntityParser.getIntAttribute(element, "hit_count", 0);
        int hitValue = DbgpXmlEntityParser.getIntAttribute(element, "hit_value", 0);
        String hitCondition = DbgpXmlEntityParser.getStringAttribute(element, "hit_condition");
        if (type.equals("line")) {
            String fileName = element.getAttribute("filename");
            String lineno = element.getAttribute("lineno");
            if ("".equals(lineno)) {
                lineno = element.getAttribute("line");
            }
            int lineNumber = Integer.parseInt(lineno);
            return new DbgpLineBreakpoint(id, enabled, hitValue, hitCount, hitCondition, fileName, lineNumber);
        }
        if (type.equals("call")) {
            String function = element.getAttribute("function");
            return new DbgpCallBreakpoint(id, enabled, hitValue, hitCount, hitCondition, function);
        }
        if (type.equals("return")) {
            String function = element.getAttribute("function");
            return new DbgpReturnBreakpoint(id, enabled, hitValue, hitCount, hitCondition, function);
        }
        if (type.equals("exception")) {
            String exception = element.getAttribute("exception");
            return new DbgpExceptionBreakpoint(id, enabled, hitValue, hitCount, hitCondition, exception);
        }
        if (type.equals("conditional")) {
            String expression = element.getAttribute("expression");
            return new DbgpConditionalBreakpoint(id, enabled, hitValue, hitCount, hitCondition, expression);
        }
        if (type.equals("watch")) {
            String expression = element.getAttribute("expression");
            return new DbgpWatchBreakpoint(id, enabled, hitValue, hitCount, hitCondition, expression);
        }
        return null;
    }

    public static IDbgpSessionInfo parseSession(Element element) {
        String appId = element.getAttribute("appid");
        String ideKey = element.getAttribute("idekey");
        String session = element.getAttribute("session");
        String threadId = element.getAttribute("thread");
        String parentId = element.getAttribute("parent");
        String language = element.getAttribute("language");
        DbgpDebuggingEngineException error = DbgpXmlParser.checkError(element);
        return new DbgpSessionInfo(appId, ideKey, session, threadId, parentId, language, null, error);
    }

    protected static String getFromChildOrAttr(Element property, String name) {
        NodeList list = property.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return property.getAttribute(name);
        }
        return DbgpXmlEntityParser.getEncodedValue((Element)list.item(0));
    }

    protected static String getEncodedValue(Element element) {
        String encoding = ENCODING_NONE;
        if (element.hasAttribute("encoding")) {
            encoding = element.getAttribute("encoding");
        }
        if (ENCODING_NONE.equals(encoding)) {
            return DbgpXmlEntityParser.parseContent(element);
        }
        if (ENCODING_BASE64.equals(encoding)) {
            return DbgpXmlEntityParser.parseBase64Content(element);
        }
        throw new AssertionError((Object)MessageFormat.format(Messages.DbgpXmlEntityParser_invalidEncoding, encoding));
    }
}

