/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationCommand;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationEngine;
import org.eclipse.dltk.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptTypeFactory;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.internal.debug.core.eval.ScriptEvaluationCommand;
import org.eclipse.dltk.internal.debug.core.model.Messages;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptVariable;

public class ScriptValue
extends ScriptDebugElement
implements IScriptValue,
IIndexedValue {
    private final IScriptType type;
    private final IVariable[] variables;
    private IScriptStackFrame frame;
    private int pageSize;
    private String name;
    private String fullname;
    private String value;
    private boolean hasChildren;
    private String key;
    private String rawValue;
    static /* synthetic */ Class class$0;

    public static IScriptValue createValue(IScriptStackFrame frame, IDbgpProperty property) {
        IScriptType type = ScriptValue.createType(frame.getDebugTarget(), property);
        return new ScriptValue(frame, property, type);
    }

    private static IScriptType createType(IDebugTarget target, IDbgpProperty property) {
        IScriptType type = null;
        String rawType = property.getType();
        IScriptTypeFactory factory = ScriptDebugManager.getInstance().getTypeFactoryByDebugModel(target.getModelIdentifier());
        type = factory != null ? factory.buildType(rawType) : new AtomicScriptType(rawType);
        return type;
    }

    protected ScriptValue(IScriptStackFrame frame, IDbgpProperty property, IScriptType type) {
        this.frame = frame;
        this.type = type;
        this.key = property.getKey();
        this.name = property.getName();
        this.fullname = property.getEvalName();
        this.rawValue = property.getValue();
        this.value = null;
        this.hasChildren = property.hasChildren();
        this.variables = new ScriptVariable[property.getChildrenCount()];
        this.pageSize = property.getPageSize();
        this.fillVariables(property.getPage(), property);
    }

    private void loadPage(int page) throws DbgpException {
        IDbgpCoreCommands commands = this.frame.getScriptThread().getDbgpSession().getCoreCommands();
        IDbgpProperty pageProperty = commands.getProperty(page, this.fullname, this.frame.getLevel());
        this.fillVariables(page, pageProperty);
    }

    private void fillVariables(int page, IDbgpProperty pageProperty) {
        int offset = this.getPageOffset(page);
        IDbgpProperty[] properties = pageProperty.getAvailableChildren();
        int i = 0;
        while (i < properties.length) {
            IDbgpProperty p = properties[i];
            this.variables[offset + i] = new ScriptVariable(this.frame, p, p.getName());
            ++i;
        }
        Arrays.sort(this.variables, offset, offset + properties.length, ScriptDebugManager.getInstance().getVariableNameComparatorByDebugModel(this.getDebugTarget().getModelIdentifier()));
        Assert.isLegal((this.pageSize > 0 || properties.length == this.variables.length ? 1 : 0) != 0);
    }

    private int getPageOffset(int page) {
        if (this.pageSize <= 0) {
            this.pageSize = this.frame.getScriptThread().getPropertyPageSize();
        }
        if (this.pageSize <= 0) {
            return 0;
        }
        return page * this.pageSize;
    }

    private int getPageForOffset(int offset) {
        Assert.isLegal((this.pageSize > 0 ? 1 : 0) != 0);
        return offset / this.pageSize;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getType().getName();
    }

    public String getValueString() {
        if (this.value == null || this.value.length() == 0) {
            if (this.type.isString()) {
                this.value = this.prepareString(this.rawValue);
            } else if (!this.type.isAtomic()) {
                StringBuffer sb = new StringBuffer();
                if ("Array".equals(this.type.getName())) {
                    try {
                        if (this.getVariables().length > 0) {
                            sb.append(this.getVariable(0).getReferenceTypeName());
                        } else {
                            sb.append("Object");
                        }
                    }
                    catch (DebugException debugException) {
                        sb.append("Object");
                    }
                    try {
                        sb.append("[" + this.getVariables().length + "]");
                    }
                    catch (DebugException debugException) {
                        sb.append("[]");
                    }
                } else {
                    sb.append(this.type.getName());
                }
                String id = this.getInstanceId();
                if (id != null) {
                    sb.append(" (id = " + id + ")");
                }
                this.value = sb.toString();
            } else {
                this.value = this.rawValue;
            }
        }
        return this.value;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    private String prepareString(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer escaped = new StringBuffer();
        if (!(string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\""))) {
            escaped.append('\"');
        }
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    escaped.append("\\\"");
                    break;
                }
                default: {
                    escaped.append(c);
                }
            }
            ++i;
        }
        if (!(string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\""))) {
            escaped.append('\"');
        }
        return escaped.toString();
    }

    public String getEvalName() {
        return this.fullname;
    }

    public boolean hasVariables() throws DebugException {
        return this.hasChildren;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public String toString() {
        return this.getValueString();
    }

    public IDebugTarget getDebugTarget() {
        return this.frame.getDebugTarget();
    }

    public String getInstanceId() {
        return this.key;
    }

    public IScriptType getType() {
        return this.type;
    }

    public IScriptEvaluationCommand createEvaluationCommand(String messageTemplate, IScriptThread thread) {
        IScriptEvaluationEngine engine = thread.getEvaluationEngine();
        String pattern = "(%variable%)";
        String evalName = this.getEvalName();
        if (messageTemplate.indexOf(pattern) != -1) {
            String snippet = ScriptValue.replacePattern(messageTemplate, pattern, evalName);
            return new ScriptEvaluationCommand(engine, snippet, this.frame);
        }
        DLTKDebugPlugin.log((IStatus)new Status(2, "org.eclipse.dltk.debug", MessageFormat.format(Messages.ScriptValue_detailFormatterRequiredToContainIdentifier, pattern)));
        return new ScriptEvaluationCommand(engine, evalName, this.frame);
    }

    private static String replacePattern(String messageTemplate, String pattern, String evalName) {
        String result = messageTemplate;
        while (result.indexOf(pattern) != -1) {
            int pos = result.indexOf(pattern);
            result = String.valueOf(result.substring(0, pos)) + evalName + result.substring(pos + pattern.length(), result.length());
        }
        return result;
    }

    public int getInitialOffset() {
        return 0;
    }

    public int getSize() throws DebugException {
        return this.variables.length;
    }

    public IVariable getVariable(int offset) throws DebugException {
        try {
            if (this.variables[offset] == null) {
                this.loadPage(this.getPageForOffset(offset));
            }
            return this.variables[offset];
        }
        catch (DbgpException e) {
            throw this.wrapDbgpException(MessageFormat.format(Messages.ScriptValue_unableToLoadChildrenOf, this.name), e);
        }
    }

    public IVariable[] getVariables() throws DebugException {
        return this.getVariables(0, this.getSize());
    }

    public IVariable[] getVariables(int offset, int length) throws DebugException {
        IVariable[] variables = new IVariable[length];
        int i = 0;
        while (i < length) {
            variables[i] = this.getVariable(offset + i);
            ++i;
        }
        return variables;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IIndexedValue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz && this.type.isCollection()) {
            return this;
        }
        return super.getAdapter(adapter);
    }
}

