/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.callhierarchy;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchScopeAction;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.ui.DLTKUIPlugin;

class SearchScopeHierarchyAction
extends SearchScopeAction {
    private final SearchScopeActionGroup fGroup;

    public SearchScopeHierarchyAction(SearchScopeActionGroup group) {
        super(group, CallHierarchyMessages.SearchScopeActionGroup_hierarchy_text);
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_hierarchy_tooltip);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public IDLTKSearchScope getSearchScope() {
        try {
            IMethod method = this.fGroup.getView().getMethod();
            if (method != null) {
                return SearchEngine.createHierarchyScope((IType)method.getDeclaringType());
            }
            return null;
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
            return null;
        }
    }

    public int getSearchScopeType() {
        return 3;
    }

    public String getFullDescription() {
        IMethod method = this.fGroup.getView().getMethod();
        return DLTKSearchScopeFactory.getInstance().getHierarchyScopeDescription(method.getDeclaringType());
    }
}

