/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor.selectionaction;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.selectionaction.SelectionActionMessages;
import org.eclipse.dltk.internal.ui.editor.selectionaction.SelectionHistory;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.texteditor.IUpdate;

public class StructureSelectHistoryAction
extends Action
implements IUpdate {
    private ScriptEditor fEditor;
    private SelectionHistory fHistory;

    public StructureSelectHistoryAction(ScriptEditor editor, SelectionHistory history) {
        super(SelectionActionMessages.StructureSelectHistory_label);
        this.setToolTipText(SelectionActionMessages.StructureSelectHistory_tooltip);
        this.setDescription(SelectionActionMessages.StructureSelectHistory_description);
        Assert.isNotNull((Object)history);
        Assert.isNotNull((Object)editor);
        this.fHistory = history;
        this.fEditor = editor;
        this.update();
    }

    public void update() {
        this.setEnabled(!this.fHistory.isEmpty());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ISourceRange old = this.fHistory.getLast();
        if (old == null) return;
        try {
            this.fHistory.ignoreSelectionChanges();
            this.fEditor.selectAndReveal(old.getOffset(), old.getLength());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fHistory.listenToSelectionChanges();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.fHistory.listenToSelectionChanges();
            return;
        }
    }
}

