/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.CompletionContext;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;

public class CompletionProposalLabelProvider {
    public String createParameterList(CompletionProposal methodProposal) {
        Assert.isTrue((methodProposal.getKind() == 5 ? 1 : 0) != 0);
        return this.appendUnboundedParameterList(new StringBuffer(), methodProposal).toString();
    }

    protected StringBuffer appendUnboundedParameterList(StringBuffer buffer, CompletionProposal methodProposal) {
        char[][] parameterNames = methodProposal.findParameterNames(null);
        char[][] parameterTypes = null;
        return this.appendParameterSignature(buffer, parameterTypes, parameterNames);
    }

    protected StringBuffer appendParameterSignature(StringBuffer buffer, char[][] parameterTypes, char[][] parameterNames) {
        if (parameterNames != null) {
            int i = 0;
            while (i < parameterNames.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                buffer.append(parameterNames[i]);
                ++i;
            }
        }
        return buffer;
    }

    protected String createMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        return nameBuffer.toString();
    }

    protected String createOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(")  ");
        return nameBuffer.toString();
    }

    protected String createTypeProposalLabel(CompletionProposal typeProposal) {
        char[] fullName = typeProposal.getName();
        return this.createTypeProposalLabel(fullName);
    }

    String createScriptdocSimpleProposalLabel(CompletionProposal proposal) {
        return this.createSimpleLabel(proposal);
    }

    String createTypeProposalLabel(char[] fullName) {
        int qIndex = this.findSimpleNameStart(fullName);
        StringBuffer buf = new StringBuffer();
        buf.append(fullName, qIndex, fullName.length - qIndex);
        if (qIndex > 0) {
            buf.append(" - ");
            buf.append(fullName, 0, qIndex - 1);
        }
        return buf.toString();
    }

    private int findSimpleNameStart(char[] array) {
        int lastDot = 0;
        int i = 0;
        int len = array.length;
        while (i < len) {
            char ch = array[i];
            if (ch == '<') {
                return lastDot;
            }
            if (ch == '.') {
                lastDot = i + 1;
            }
            ++i;
        }
        return lastDot;
    }

    String createSimpleLabelWithType(CompletionProposal proposal) {
        return new String(proposal.getCompletion());
    }

    String createLabelWithTypeAndDeclaration(CompletionProposal proposal) {
        return new String(proposal.getCompletion());
    }

    public String createSimpleLabel(CompletionProposal proposal) {
        return String.valueOf(proposal.getCompletion());
    }

    public String createKeywordLabel(CompletionProposal proposal) {
        return String.valueOf(proposal.getName());
    }

    public String createLabel(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 5: 
            case 9: 
            case 10: {
                return this.createMethodProposalLabel(proposal);
            }
            case 6: {
                return this.createOverrideMethodProposalLabel(proposal);
            }
            case 7: {
                return this.createTypeProposalLabel(proposal);
            }
            case 1: {
                return this.createLabelWithTypeAndDeclaration(proposal);
            }
            case 4: 
            case 8: {
                return this.createSimpleLabelWithType(proposal);
            }
            case 2: {
                return this.createKeywordLabel(proposal);
            }
            case 3: 
            case 11: {
                return this.createSimpleLabel(proposal);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor descriptor;
        switch (proposal.getKind()) {
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                descriptor = ScriptElementImageProvider.getMethodImageDescriptor(proposal.getFlags());
                break;
            }
            case 7: {
                descriptor = DLTKPluginImages.DESC_OBJS_CLASSALT;
                break;
            }
            case 1: {
                descriptor = DLTKPluginImages.DESC_FIELD_DEFAULT;
                break;
            }
            case 4: 
            case 8: {
                descriptor = DLTKPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                break;
            }
            case 11: {
                descriptor = DLTKPluginImages.DESC_OBJS_PACKAGE;
                break;
            }
            case 2: {
                descriptor = DLTKPluginImages.DESC_OBJS_KEYWORD;
                break;
            }
            case 3: {
                descriptor = null;
                break;
            }
            default: {
                descriptor = null;
                Assert.isTrue((boolean)false);
            }
        }
        if (descriptor == null) {
            return null;
        }
        return this.decorateImageDescriptor(descriptor, proposal);
    }

    public ImageDescriptor createMethodImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        return this.decorateImageDescriptor(ScriptElementImageProvider.getMethodImageDescriptor(flags), proposal);
    }

    ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        return this.decorateImageDescriptor(ScriptElementImageProvider.getTypeImageDescriptor(flags, false), proposal);
    }

    ImageDescriptor createFieldImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        return this.decorateImageDescriptor(ScriptElementImageProvider.getFieldImageDescriptor(flags), proposal);
    }

    ImageDescriptor createLocalImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(DLTKPluginImages.DESC_OBJS_LOCAL_VARIABLE, proposal);
    }

    ImageDescriptor createPackageImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(DLTKPluginImages.DESC_OBJS_PACKAGE, proposal);
    }

    private ImageDescriptor decorateImageDescriptor(ImageDescriptor descriptor, CompletionProposal proposal) {
        int adornmentFlags = ScriptElementImageProvider.computeAdornmentFlags(proposal.getModelElement(), 3);
        if (proposal.isConstructor()) {
            adornmentFlags |= 0x200;
        }
        return new ScriptElementImageDescriptor(descriptor, adornmentFlags, ScriptElementImageProvider.SMALL_SIZE);
    }

    void setContext(CompletionContext context) {
    }
}

