/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class SimpleDLTKExtensionManager {
    private List extensions;
    private String extensionPoint = null;

    public SimpleDLTKExtensionManager(String extension) {
        this.extensionPoint = extension;
    }

    private void initialize() {
        if (this.extensions != null) {
            return;
        }
        this.extensions = new ArrayList(5);
        IConfigurationElement[] cfg = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPoint);
        int i = 0;
        while (i < cfg.length) {
            ElementInfo info = this.createInfo(cfg[i]);
            if (!this.extensions.contains(info)) {
                this.extensions.add(info);
            }
            ++i;
        }
    }

    public ElementInfo[] getElementInfos() {
        this.initialize();
        return this.extensions.toArray(new ElementInfo[this.extensions.size()]);
    }

    protected ElementInfo createInfo(IConfigurationElement config) {
        return new ElementInfo(config);
    }

    public static class ElementInfo {
        public IConfigurationElement config;
        public Object object;

        protected ElementInfo(IConfigurationElement config) {
            this.config = config;
        }

        public IConfigurationElement getConfig() {
            return this.config;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
            result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ElementInfo other = (ElementInfo)obj;
            if (this.config == null ? other.config != null : !this.config.equals((Object)other.config)) {
                return false;
            }
            return !(this.object == null ? other.object != null : !this.object.equals(other.object));
        }
    }
}

