/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist.selection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.FieldReferenceMatch;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.FakeField;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.VaribleDeclarationReference;
import org.eclipse.dltk.javascript.internal.core.codeassist.AssitUtils;

public class JavaScriptSelectionEngine
extends ScriptSelectionEngine {
    ISourceModule cu;

    public IAssistParser getParser() {
        return null;
    }

    public IModelElement[] select(ISourceModule cu, int offset, int i) {
        String content = cu.getSourceContents();
        char[] fileName = cu.getFileName();
        this.cu = cu;
        int index = content.indexOf(10, offset);
        if (index == -1) {
            index = content.length();
        }
        ReferenceResolverContext buildContext2 = AssitUtils.buildContext((org.eclipse.dltk.core.ISourceModule)cu, index, content, fileName);
        HostCollection buildContext = buildContext2.getHostCollection();
        AssitUtils.PositionCalculator calc = new AssitUtils.PositionCalculator(content, offset, true);
        ArrayList result = new ArrayList();
        String selection = calc.getCompletion();
        if (calc.isMember()) {
            this.processMember(buildContext2, calc, result, selection);
        } else {
            this.processGlobals(buildContext2, buildContext, result, selection);
        }
        HashSet sm = new HashSet(result);
        IModelElement[] resultA = new IModelElement[sm.size()];
        sm.toArray(resultA);
        int j = 0;
        while (j < resultA.length) {
            if (resultA[j] instanceof IField && resultA[j] instanceof FakeField) {
                ((FakeField)resultA[j]).setSnippet(selection);
            }
            ++j;
        }
        return resultA;
    }

    private void processGlobals(ReferenceResolverContext rc, HostCollection buildContext, List result, String selection) {
        if (selection.length() != 0) {
            IReference rm = buildContext.getReference(selection);
            if (rm != null) {
                rm.addModelElements(result);
            } else {
                Set resolveGlobals = rc.resolveGlobals(selection);
                Iterator it = resolveGlobals.iterator();
                while (it.hasNext()) {
                    IReference r;
                    Object next = it.next();
                    if (!(next instanceof IReference) || !(r = (IReference)next).getName().equals(selection)) continue;
                    r.addModelElements(result);
                }
            }
            if (result.size() == 0) {
                this.doCompletionOnFunction(selection, result);
                this.doCompletionOnGlobalVariable(selection, result);
            }
        }
    }

    private void processMember(ReferenceResolverContext buildContext, AssitUtils.PositionCalculator calc, final List result, String selection) {
        calc.getCorePart();
        IReference rm = buildContext.getHostCollection().queryElement(selection, true);
        if (rm != null) {
            rm.addModelElements(result);
        }
        if (result.size() == 0) {
            IDLTKLanguageToolkit toolkit = null;
            toolkit = DLTKLanguageManager.getLanguageToolkit((String)"org.eclipse.dltk.javascript.core.nature");
            Set resolveGlobals = buildContext.resolveGlobals(selection);
            Iterator it = resolveGlobals.iterator();
            while (it.hasNext()) {
                IReference r = (IReference)it.next();
                r.addModelElements(result);
            }
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    VaribleDeclarationReference vm;
                    IReference reference;
                    FieldReferenceMatch mr = (FieldReferenceMatch)match;
                    ASTNode nm = mr.getNode();
                    if (nm instanceof VaribleDeclarationReference && (reference = (vm = (VaribleDeclarationReference)nm).getReference()) != null) {
                        reference.addModelElements(result);
                    }
                }
            };
            IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
            try {
                this.search(selection, 2, 1, scope, requestor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void doCompletionOnFunction(final String startPart, final List modelElements) {
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IMethod mn;
                Object element = match.getElement();
                if (element instanceof IMethod && (mn = (IMethod)element).getElementName().equals(startPart)) {
                    if (!modelElements.isEmpty()) {
                        return;
                    }
                    modelElements.add(element);
                }
            }
        };
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((String)"org.eclipse.dltk.javascript.core.nature");
        IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
        try {
            this.search(startPart, 1, 0, scope, requestor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void doCompletionOnGlobalVariable(String startPart, final List methods) {
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IField) {
                    methods.add(element);
                }
                if (match instanceof FieldReferenceMatch) {
                    FieldReferenceMatch cfr_ignored_0 = (FieldReferenceMatch)match;
                }
            }
        };
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((String)"org.eclipse.dltk.javascript.core.nature");
        IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
        try {
            this.search(String.valueOf(startPart) + "*", 2, 0, scope, requestor);
            this.search(String.valueOf(startPart) + "*", 2, 1, scope, requestor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void search(String patternString, int searchFor, int limitTo, IDLTKSearchScope scope, SearchRequestor resultCollector) throws CoreException {
        this.search(patternString, searchFor, limitTo, EXACT_RULE, scope, resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IDLTKSearchScope scope, SearchRequestor requestor) throws CoreException {
        SearchPattern pattern;
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        if ((pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit())) == null) {
            pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        }
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }
}

