/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk.ui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.dltk.MylynStatusHandler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;

public class DLTKUiUtil {
    private static final Point SMALL_SIZE = new Point(16, 16);
    private static final String SEPARATOR_CODEASSIST = "\u0000";

    public static void installContentAssist(IPreferenceStore scriptPrefs, boolean mylynContentAssist) {
        String oldValue = scriptPrefs.getString("content_assist_disabled_computers");
        StringTokenizer tokenizer = new StringTokenizer(oldValue, SEPARATOR_CODEASSIST);
        HashSet<String> disabledIds = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            disabledIds.add((String)tokenizer.nextElement());
        }
        String newValue = "";
        Iterator it = disabledIds.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            newValue = String.valueOf(newValue) + id + SEPARATOR_CODEASSIST;
        }
        scriptPrefs.setValue("content_assist_disabled_computers", newValue);
    }

    public static ImageDescriptor decorate(ImageDescriptor base, int decorations) {
        ScriptElementImageDescriptor imageDescriptor = new ScriptElementImageDescriptor(base, decorations, SMALL_SIZE);
        return imageDescriptor;
    }

    public static IModelElement getScriptElement(ConcreteMarker marker) {
        ISourceModule cu;
        block9: {
            if (marker == null) {
                return null;
            }
            IResource res = marker.getResource();
            cu = null;
            if (!(res instanceof IFile)) break block9;
            IFile file = (IFile)res;
            IProject project = res.getProject();
            IScriptProject scriptProject = DLTKCore.create((IProject)project);
            if (scriptProject.exists()) {
                IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)scriptProject);
                if (DLTKContentTypeManager.isValidResourceForContentType((IDLTKLanguageToolkit)toolkit, (IResource)res)) {
                    cu = DLTKCore.createSourceModuleFrom((IFile)file);
                }
                break block9;
            }
            return null;
        }
        try {
            if (cu != null) {
                IModelElement je = cu.getElementAt(marker.getMarker().getAttribute("charStart", 0));
                return je;
            }
            return null;
        }
        catch (ModelException ex) {
            if (!ex.isDoesNotExist()) {
                ExceptionHandler.handle((CoreException)((Object)ex), (String)"error", (String)"could not find java element");
            }
            return null;
        }
        catch (Throwable t) {
            MylynStatusHandler.fail(t, "Could not find element for: " + marker, false);
            return null;
        }
    }

    public static String getFullyQualifiedName(IModelElement je) {
        if (!(je instanceof IMember)) {
            return null;
        }
        IMember m = (IMember)je;
        if (m.getDeclaringType() == null) {
            return ((IType)m).getFullyQualifiedName();
        }
        return String.valueOf(m.getDeclaringType().getFullyQualifiedName()) + "." + m.getElementName();
    }

    public static void closeActiveEditors(boolean javaOnly) {
        int j = 0;
        while (j < PlatformUI.getWorkbench().getWorkbenchWindows().length) {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getWorkbenchWindows()[j];
            IWorkbenchPage page = workbenchWindow.getActivePage();
            if (page != null) {
                IEditorReference[] references = page.getEditorReferences();
                int i = 0;
                while (i < references.length) {
                    IEditorPart part = references[i].getEditor(false);
                    if (part != null) {
                        if (javaOnly && part.getEditorInput() instanceof IFileEditorInput && part instanceof ScriptEditor) {
                            ScriptEditor editor = (ScriptEditor)part;
                            editor.close(true);
                        } else if (part instanceof ScriptEditor) {
                            ((AbstractTextEditor)part).close(true);
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
    }
}

