/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast.expressions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.ExpressionList;
import org.eclipse.dltk.utils.CorePrinter;

public class PythonForListExpression
extends Expression {
    private Expression fVars;
    private Expression fFrom;
    private ExpressionList fIfList;

    public PythonForListExpression(Expression vars, Expression from) {
        this.fVars = vars;
        this.fFrom = from;
        this.setStart(vars.sourceStart());
        this.setEnd(from.sourceEnd());
    }

    public int getKind() {
        return 38008;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Expression)this)) {
            if (this.fVars != null) {
                this.fVars.traverse(pVisitor);
            }
            if (this.fFrom != null) {
                this.fFrom.traverse(pVisitor);
            }
            if (this.fIfList != null) {
                this.fIfList.traverse(pVisitor);
            }
            pVisitor.endvisit((Expression)this);
        }
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("for ");
        if (this.fVars != null) {
            this.fVars.printNode(output);
        }
        output.formatPrintLn(" in ");
        if (this.fFrom != null) {
            this.fFrom.printNode(output);
        }
        if (this.fIfList != null) {
            List ifs = this.fIfList.getExpressions();
            Iterator i = ifs.iterator();
            while (i.hasNext()) {
                Expression ife = (Expression)i.next();
                output.formatPrintLn("if ");
                ife.printNode(output);
            }
        }
    }

    public void setIfListExpression(ExpressionList ifBlock) {
        this.fIfList = ifBlock;
        this.setEnd(ifBlock.sourceEnd());
    }
}

