/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.core.codeassist;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.ruby.ast.RubyBlock;
import org.eclipse.dltk.ruby.ast.RubyCallArgumentsList;
import org.eclipse.dltk.ruby.ast.RubyColonExpression;
import org.eclipse.dltk.ruby.ast.RubyDAssgnExpression;
import org.eclipse.dltk.ruby.ast.RubyDVarExpression;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.core.model.FakeField;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.dltk.ruby.internal.core.codeassist.ProjectTypeComparator;
import org.eclipse.dltk.ruby.internal.core.codeassist.RubyKeyword;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinVariable;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;
import org.eclipse.dltk.ruby.typeinference.IMixinSearchRequestor;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.RubyModelUtils;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.DLTKTypeInferenceEngine;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.jruby.util.collections.WeakHashSet;

public class RubyCompletionEngine
extends ScriptCompletionEngine {
    private static final int RELEVANCE_FREE_SPACE = 10000000;
    private int relevanceKeyword = 1000000;
    private static final int RELEVANCE_METHODS = 100000;
    private static final String[] globalVars = new String[]{"$DEBUG", "$$", "$-i", "$deferr", "$/", "$'", "$stdout", "$-l", "$-I", "$.", "$KCODE", "$binding", "$-w", "$FILENAME", "$defout", "$,", "$`", "$-F", "$*", "$LOADED_FEATURES", "$stdin", "$-p", "$:", "$\\", "$=", "$!", "$-v", "$>", "$&", "$;", "$SAFE", "$PROGRAM_NAME", "$\"", "$-d", "$?", "$-0", "$+", "$@", "$-a", "$VERBOSE", "$stderr", "$~", "$0", "$LOAD_PATH", "$<", "$_", "$-K"};
    private DLTKTypeInferenceEngine inferencer;
    private ISourceParser parser = null;
    private MixinModel model;
    private HashSet completedNames = new HashSet();
    private WeakHashSet intresting = new WeakHashSet();
    private ASTNode completionNode;
    private final Comparator modelElementComparator = new Comparator(){
        Collator collator = Collator.getInstance(Locale.ENGLISH);

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof IModelElement && arg1 instanceof IModelElement) {
                IModelElement me1 = (IModelElement)arg1;
                IModelElement me2 = (IModelElement)arg0;
                int r = -this.collator.compare(me1.getElementName(), me2.getElementName());
                if (r == 0) {
                    boolean cur2;
                    boolean cur1 = me1.getAncestor(5).equals(RubyCompletionEngine.this.currentModule);
                    if (cur1 == (cur2 = me2.getAncestor(5).equals(RubyCompletionEngine.this.currentModule))) {
                        return 0;
                    }
                    return cur1 ? -1 : 1;
                }
                return r;
            }
            return 0;
        }
    };
    private org.eclipse.dltk.core.ISourceModule currentModule;
    private int relevance;

    public RubyCompletionEngine() {
        this.inferencer = new DLTKTypeInferenceEngine();
        this.model = RubyMixinModel.getRawInstance();
        this.parser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.ruby.core.nature");
    }

    protected int getEndOfEmptyToken() {
        return 0;
    }

    protected String processMethodName(IMethod method, String token) {
        return null;
    }

    protected String processTypeName(IType method, String token) {
        return null;
    }

    public IAssistParser getParser() {
        return null;
    }

    private boolean afterColons(String content, int position) {
        if (position < 2) {
            return false;
        }
        return content.charAt(position - 1) == ':' && content.charAt(position - 2) == ':';
    }

    private boolean afterDollar(String content, int position) {
        if (position < 1) {
            return false;
        }
        return content.charAt(position - 1) == '$';
    }

    private boolean afterAt(String content, int position) {
        if (position < 1) {
            return false;
        }
        return content.charAt(position - 1) == '@';
    }

    private boolean afterAt2(String content, int position) {
        if (position < 2) {
            return false;
        }
        return content.charAt(position - 1) == '@' && content.charAt(position - 2) == '@';
    }

    private String getWordStarting(String content, int position, int maxLen) {
        if (position <= 0 || position > content.length()) {
            return null;
        }
        int original = position;
        while (position > 0 && maxLen > 0 && RubySyntaxUtils.isLessStrictIdentifierCharacter(content.charAt(position - 1))) {
            --position;
            --maxLen;
        }
        if (position < original) {
            return content.substring(position, original);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void complete(ISourceModule module, int position, int i) {
        this.currentModule = (org.eclipse.dltk.core.ISourceModule)module;
        this.completedNames.clear();
        this.actualCompletionPosition = position;
        this.requestor.beginReporting();
        try {
            String content = module.getSourceContents();
            String wordStarting = this.getWordStarting(content, position, 10);
            if (wordStarting != null) {
                this.setSourceRange(position - wordStarting.length(), position);
                String[] keywords = RubyKeyword.findByPrefix(wordStarting);
                int j = 0;
                while (j < keywords.length) {
                    this.reportKeyword(keywords[j]);
                    ++j;
                }
            }
            ModuleDeclaration moduleDeclaration = this.parser.parse(module.getFileName(), content.toCharArray(), null);
            if (this.afterDollar(content, position)) {
                this.completeGlobalVar(moduleDeclaration, "$", position);
            } else if (this.afterAt2(content, position)) {
                this.completeSimpleRef(moduleDeclaration, "@@", position);
            } else if (this.afterAt(content, position)) {
                this.completeSimpleRef(moduleDeclaration, "@", position);
            } else if (this.afterColons(content, position)) {
                ASTNode node = ASTUtils.findMaximalNodeEndingAt(moduleDeclaration, position - 2);
                this.setSourceRange(position, position);
                if (node != null) {
                    BasicContext basicContext = new BasicContext(this.currentModule, moduleDeclaration);
                    ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)basicContext, node);
                    IEvaluatedType type = this.inferencer.evaluateType((AbstractTypeGoal)goal, 3000);
                    this.reportSubElements(type, "");
                } else {
                    this.completeConstant(moduleDeclaration, "", position, true);
                }
            } else {
                ASTNode minimalNode = ASTUtils.findMinimalNode(moduleDeclaration, position, position);
                if (minimalNode != null) {
                    this.completionNode = minimalNode;
                    this.completeContextMethod(position, moduleDeclaration, minimalNode);
                    if (minimalNode instanceof CallExpression && !RubySyntaxUtils.isRubyOperator(((CallExpression)minimalNode).getName())) {
                        this.completeCall(moduleDeclaration, (CallExpression)minimalNode, position);
                    } else if (minimalNode instanceof ConstantReference) {
                        this.completeConstant(moduleDeclaration, (ConstantReference)minimalNode, position);
                    } else if (minimalNode instanceof RubyColonExpression) {
                        this.completeColonExpression(moduleDeclaration, (RubyColonExpression)minimalNode, position);
                    } else if (minimalNode instanceof SimpleReference) {
                        this.completeSimpleRef(moduleDeclaration, ((SimpleReference)minimalNode).getName(), position);
                    } else if (minimalNode instanceof RubyDVarExpression) {
                        this.completeSimpleRef(moduleDeclaration, ((RubyDVarExpression)minimalNode).getName(), position);
                    } else if (minimalNode instanceof NumericLiteral && position > 0 && position == minimalNode.sourceEnd() && position > minimalNode.sourceStart() && content.charAt(position - 1) == '.') {
                        this.setSourceRange(position, position);
                        this.completeClassMethods(moduleDeclaration, minimalNode, "");
                    } else if (wordStarting == null && !this.requestor.isContextInformationMode() && !this.afterContentAndSpace(moduleDeclaration, content, position)) {
                        this.reportCurrentElements(moduleDeclaration, position);
                    }
                }
            }
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.requestor.endReporting();
            throw throwable;
        }
        this.requestor.endReporting();
    }

    private boolean afterContentAndSpace(ModuleDeclaration moduleDeclaration, String content, int position) {
        while (position > 0) {
            char c = content.charAt(position - 1);
            if (c != ' ' && c != '\t') break;
            --position;
        }
        if (position > 0 && RubySyntaxUtils.isIdentifierCharacter(content.charAt(position - 1))) {
            ASTNode node = ASTUtils.findMinimalNode(moduleDeclaration, position, position);
            if (node instanceof CallExpression) {
                int begin = position;
                while (begin > 0 && content.charAt(begin - 1) != '\r' && content.charAt(begin - 1) != '\n') {
                    --begin;
                }
                ASTNode[] way = ASTUtils.restoreWayToNode(moduleDeclaration, node);
                int i = way.length - 1;
                while (--i >= 0) {
                    if (!(way[i] instanceof CallExpression)) continue;
                    return way[i].sourceStart() >= begin;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void reportCurrentElements(ModuleDeclaration moduleDeclaration, int position) {
        this.setSourceRange(position, position);
        this.completeSimpleRef(moduleDeclaration, "", position);
        RubyClassType self = RubyTypeInferencingUtils.determineSelfClass(this.currentModule, moduleDeclaration, position);
        this.completeClassMethods(moduleDeclaration, (IEvaluatedType)self, "");
        if ("Object".equals(self.getTypeName())) {
            try {
                IModelElement[] children = this.currentModule.getChildren();
                if (children != null) {
                    int i = 0;
                    while (i < children.length) {
                        IModelElement element = children[i];
                        if (element instanceof IField) {
                            this.reportField((IField)element, 10000000);
                        } else if (element instanceof IMethod) {
                            IMethod method = (IMethod)element;
                            if ((method.getFlags() & 0x100) == 0) {
                                this.reportMethod(method, 10000000);
                            }
                        } else if (element instanceof IType && !element.getElementName().trim().startsWith("<<")) {
                            this.reportType((IType)element, 10000000);
                        }
                        ++i;
                    }
                }
            }
            catch (ModelException e) {
                RubyPlugin.log((Exception)((Object)e));
            }
        }
    }

    private boolean completeContextMethod(int position, ModuleDeclaration moduleDeclaration, ASTNode minimalNode) {
        ASTNode[] path = ASTUtils.restoreWayToNode(moduleDeclaration, minimalNode);
        if (path == null) {
            return false;
        }
        int k = path.length;
        while (--k >= 1) {
            if (!(path[k] instanceof RubyCallArgumentsList) || !(path[k - 1] instanceof CallExpression)) continue;
            CallExpression call = (CallExpression)path[k - 1];
            RubyCallArgumentsList args = (RubyCallArgumentsList)path[k];
            if (RubySyntaxUtils.isRubyOperator(call.getName()) || !RubyCompletionEngine.isValidCallArgs(args)) continue;
            this.completeCallArgumentList(moduleDeclaration, call, position);
            return true;
        }
        return false;
    }

    private static boolean isValidCallArgs(RubyCallArgumentsList args) {
        return args.sourceStart() >= 0 && args.sourceEnd() >= 0 && args.sourceEnd() > args.sourceStart();
    }

    private void completeCallArgumentList(ModuleDeclaration moduleDeclaration, CallExpression call, int position) {
        ASTNode receiver = call.getReceiver();
        String methodName = call.getCallName().getName();
        if (receiver != null) {
            this.completeClassMethods(moduleDeclaration, receiver, methodName);
        } else {
            RubyClassType self = RubyTypeInferencingUtils.determineSelfClass(this.currentModule, moduleDeclaration, position);
            this.completeClassMethods(moduleDeclaration, (IEvaluatedType)self, methodName);
        }
    }

    private void completeClassMethods(ModuleDeclaration moduleDeclaration, RubyMixinClass rubyClass, String prefix) {
        CompletionMixinMethodRequestor mixinSearchRequestor = new CompletionMixinMethodRequestor(rubyClass);
        rubyClass.findMethods(prefix, true, mixinSearchRequestor);
        mixinSearchRequestor.flush();
    }

    private void completeClassMethods(ModuleDeclaration moduleDeclaration, IEvaluatedType type, String prefix) {
        if (type instanceof RubyClassType) {
            RubyClassType rubyClassType = (RubyClassType)type;
            RubyMixinClass rubyClass = RubyMixinModel.getInstance().createRubyClass(rubyClassType);
            if (rubyClass != null) {
                this.completeClassMethods(moduleDeclaration, rubyClass, prefix);
            }
        } else if (type instanceof AmbiguousType) {
            AmbiguousType type2 = (AmbiguousType)type;
            IEvaluatedType[] possibleTypes = type2.getPossibleTypes();
            int i = 0;
            while (i < possibleTypes.length) {
                this.completeClassMethods(moduleDeclaration, possibleTypes[i], prefix);
                ++i;
            }
        }
    }

    private void completeClassMethods(ModuleDeclaration moduleDeclaration, ASTNode receiver, String pattern) {
        ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)new BasicContext(this.currentModule, moduleDeclaration), receiver);
        IEvaluatedType type = this.inferencer.evaluateType((AbstractTypeGoal)goal, 2000);
        this.completeClassMethods(moduleDeclaration, type, pattern);
    }

    private void completeGlobalVar(ModuleDeclaration moduleDeclaration, String prefix, int position) {
        int relevance = 424242;
        this.setSourceRange(position - prefix.length(), position);
        IMixinElement[] elements = RubyMixinModel.getRawInstance().find(String.valueOf(prefix) + "*");
        int i = 0;
        while (i < elements.length) {
            IRubyMixinElement rubyElement = RubyMixinModel.getInstance().createRubyElement(elements[i]);
            if (rubyElement instanceof RubyMixinVariable) {
                RubyMixinVariable variable = (RubyMixinVariable)rubyElement;
                IField[] sourceFields = variable.getSourceFields();
                int j = 0;
                while (j < sourceFields.length) {
                    if (sourceFields[j] != null) {
                        this.reportField(sourceFields[j], relevance--);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < globalVars.length) {
            if (globalVars[i].startsWith(prefix)) {
                this.reportField((IField)new FakeField((ModelElement)this.currentModule, globalVars[i], 0, 0), relevance--);
            }
            ++i;
        }
    }

    private void completeSimpleRef(ModuleDeclaration moduleDeclaration, String prefix, int position) {
        int relevance = 424242;
        this.setSourceRange(position - prefix.length(), position);
        ASTNode[] wayToNode = ASTUtils.restoreWayToNode(moduleDeclaration, this.completionNode);
        int i = wayToNode.length - 1;
        while (i > 0) {
            if (wayToNode[i] instanceof RubyBlock) {
                RubyBlock rubyBlock = (RubyBlock)wayToNode[i];
                Set vars = rubyBlock.getVars();
                Iterator iterator = vars.iterator();
                while (iterator.hasNext()) {
                    RubyDAssgnExpression rd;
                    ASTNode n = (ASTNode)iterator.next();
                    if (!(n instanceof RubyDAssgnExpression) || !(rd = (RubyDAssgnExpression)n).getName().startsWith(prefix)) continue;
                    this.reportField((IField)new FakeField((ModelElement)this.currentModule, rd.getName(), 0, 0), relevance--);
                }
            }
            --i;
        }
        if (prefix.startsWith("$")) {
            this.completeGlobalVar(moduleDeclaration, prefix, position);
        } else {
            IField[] fields = RubyModelUtils.findFields(this.currentModule, moduleDeclaration, prefix, position);
            int i2 = 0;
            while (i2 < fields.length) {
                this.reportField(fields[i2], relevance--);
                ++i2;
            }
        }
    }

    private void reportSubElements(IEvaluatedType type, String prefix) {
        if (!(type instanceof RubyClassType)) {
            return;
        }
        RubyClassType rubyClassType = (RubyClassType)type;
        IMixinElement mixinElement = this.model.get(rubyClassType.getModelKey());
        if (mixinElement == null) {
            return;
        }
        ArrayList<IType> types = new ArrayList<IType>();
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        ArrayList<IField> fields = new ArrayList<IField>();
        IMixinElement[] children = mixinElement.getChildren();
        int i = 0;
        while (i < children.length) {
            Object[] infos = children[i].getAllObjects();
            int j = 0;
            while (j < infos.length) {
                RubyMixinElementInfo obj = (RubyMixinElementInfo)infos[j];
                if (obj.getObject() != null) {
                    IField fff;
                    IMethod method2;
                    if (obj.getKind() == 0 || obj.getKind() == 1) {
                        IType type2 = (IType)obj.getObject();
                        if (type2 != null && type2.getElementName().startsWith(prefix)) {
                            types.add(type2);
                        }
                    } else if (obj.getKind() == 2 && (method2 = (IMethod)obj.getObject()) != null && method2.getElementName().startsWith(prefix)) {
                        methods.add(method2);
                    }
                    if (obj.getKind() != 3 || (fff = (IField)obj.getObject()) == null || !fff.getElementName().startsWith(prefix)) break;
                    fields.add(fff);
                    break;
                }
                ++j;
            }
            ++i;
        }
        int relevance = 424242;
        Collections.sort(fields, this.modelElementComparator);
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            IField t = (IField)iterator.next();
            this.reportField(t, relevance--);
        }
        Collections.sort(types, this.modelElementComparator);
        iterator = types.iterator();
        while (iterator.hasNext()) {
            IType t = (IType)iterator.next();
            this.reportType(t, relevance--);
        }
        Collections.sort(methods, this.modelElementComparator);
        iterator = methods.iterator();
        while (iterator.hasNext()) {
            IMethod t = (IMethod)iterator.next();
            this.reportMethod(t, relevance--);
        }
    }

    private void completeColonExpression(ModuleDeclaration moduleDeclaration, RubyColonExpression node, int position) {
        String content;
        try {
            content = this.currentModule.getSource();
        }
        catch (ModelException modelException) {
            return;
        }
        int pos = node.getLeft() != null ? node.getLeft().sourceEnd() + 2 : node.sourceStart();
        String starting = null;
        try {
            starting = content.substring(pos, position).trim();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return;
        }
        if (starting.startsWith("::")) {
            this.setSourceRange(position - starting.length() + 2, position);
            this.completeConstant(moduleDeclaration, starting.substring(2), position, true);
            return;
        }
        this.setSourceRange(position - starting.length(), position);
        ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)new BasicContext(this.currentModule, moduleDeclaration), node.getLeft());
        IEvaluatedType type = this.inferencer.evaluateType((AbstractTypeGoal)goal, 3000);
        this.reportSubElements(type, starting);
    }

    private void completeConstant(ModuleDeclaration moduleDeclaration, String prefix, int position, boolean topLevelOnly) {
        this.relevance = 4242;
        this.reportProjectTypes(prefix);
        if (!topLevelOnly) {
            IMixinElement[] modelStaticScopes = RubyTypeInferencingUtils.getModelStaticScopes(this.model, moduleDeclaration, position);
            int i = modelStaticScopes.length - 1;
            while (i >= 0) {
                IMixinElement scope = modelStaticScopes[i];
                if (scope != null) {
                    this.reportSubElements((IEvaluatedType)new RubyClassType(scope.getKey()), prefix);
                }
                --i;
            }
        }
        if (prefix.length() > 0) {
            String varkey = "Object{" + prefix;
            RubyMixinModel rubyModel = RubyMixinModel.getInstance();
            String[] keys2 = rubyModel.getRawModel().findKeys(String.valueOf(varkey) + "*");
            int i = 0;
            while (i < keys2.length) {
                IRubyMixinElement element = rubyModel.createRubyElement(keys2[i]);
                if (element instanceof RubyMixinVariable) {
                    RubyMixinVariable variable = (RubyMixinVariable)element;
                    IField[] sourceFields = variable.getSourceFields();
                    int j = 0;
                    while (j < sourceFields.length) {
                        if (sourceFields[j] != null) {
                            this.reportField(sourceFields[j], this.relevance--);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void reportProjectTypes(String prefix) {
        IType[] types = RubyTypeInferencingUtils.getAllTypes(this.currentModule, prefix);
        Arrays.sort(types, new ProjectTypeComparator(this.currentModule));
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < types.length) {
            String elementName = types[i].getElementName();
            if (names.add(elementName)) {
                this.reportType(types[i], this.relevance--);
            }
            ++i;
        }
    }

    private void completeConstant(ModuleDeclaration moduleDeclaration, ConstantReference node, int position) {
        String content;
        try {
            content = this.currentModule.getSource();
        }
        catch (ModelException modelException) {
            return;
        }
        String prefix = content.substring(node.sourceStart(), position);
        this.setSourceRange(position - prefix.length(), position);
        this.completeConstant(moduleDeclaration, prefix, position, false);
    }

    private void completeCall(ModuleDeclaration moduleDeclaration, CallExpression node, int position) {
        String content;
        ASTNode receiver = node.getReceiver();
        try {
            content = this.currentModule.getSource();
        }
        catch (ModelException modelException) {
            return;
        }
        int pos = receiver != null ? receiver.sourceEnd() + 1 : node.sourceStart();
        int t = 0;
        while (t < 2) {
            if (pos < position && !RubySyntaxUtils.isStrictIdentifierCharacter(content.charAt(pos))) {
                ++pos;
            }
            ++t;
        }
        String starting = content.substring(pos, position).trim();
        if (receiver == null) {
            this.completeSimpleRef(moduleDeclaration, starting, position);
            this.completeConstant(moduleDeclaration, starting, position, false);
        }
        this.setSourceRange(position - starting.length(), position);
        if (starting.startsWith("__")) {
            String[] keywords = RubyKeyword.findByPrefix("__");
            int j = 0;
            while (j < keywords.length) {
                this.reportKeyword(keywords[j]);
                ++j;
            }
        }
        if (receiver != null) {
            this.completeClassMethods(moduleDeclaration, receiver, starting);
        } else {
            RubyClassType self = RubyTypeInferencingUtils.determineSelfClass(this.currentModule, moduleDeclaration, position);
            this.completeClassMethods(moduleDeclaration, (IEvaluatedType)self, starting);
        }
    }

    protected String processFieldName(IField field, String token) {
        return field.getElementName();
    }

    private void reportMethod(IMethod method, int rel) {
        char[] name;
        this.intresting.add(method);
        String elementName = method.getElementName();
        if (this.completedNames.contains(elementName)) {
            return;
        }
        this.completedNames.add(elementName);
        if (elementName.indexOf(46) != -1) {
            elementName = elementName.substring(elementName.indexOf(46) + 1);
        }
        char[] compl = name = elementName.toCharArray();
        this.noProposal = false;
        if (!this.requestor.isIgnored(6)) {
            CompletionProposal proposal = this.createProposal(6, this.actualCompletionPosition);
            String[] params = null;
            try {
                params = method.getParameters();
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            if (params != null && params.length > 0) {
                char[][] args = new char[params.length][];
                int i = 0;
                while (i < params.length) {
                    args[i] = params[i].toCharArray();
                    ++i;
                }
                proposal.setParameterNames((char[][])args);
            }
            proposal.setModelElement((IModelElement)method);
            proposal.setName(name);
            proposal.setCompletion(compl);
            try {
                proposal.setFlags(method.getFlags());
            }
            catch (ModelException e) {
                RubyPlugin.log((Exception)((Object)e));
            }
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(rel);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private void reportType(IType type, int rel) {
        this.intresting.add(type);
        String elementName = type.getElementName();
        if (this.completedNames.contains(elementName)) {
            return;
        }
        this.completedNames.add(elementName);
        char[] name = elementName.toCharArray();
        if (name.length == 0) {
            return;
        }
        this.noProposal = false;
        if (!this.requestor.isIgnored(7)) {
            CompletionProposal proposal = this.createProposal(7, this.actualCompletionPosition);
            proposal.setModelElement((IModelElement)type);
            proposal.setName(name);
            proposal.setCompletion(elementName.toCharArray());
            try {
                proposal.setFlags(type.getFlags());
            }
            catch (ModelException modelException) {}
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(rel);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private void reportField(IField field, int rel) {
        this.intresting.add(field);
        String elementName = field.getElementName();
        if (this.completedNames.contains(elementName)) {
            return;
        }
        this.completedNames.add(elementName);
        char[] name = elementName.toCharArray();
        if (name.length == 0) {
            return;
        }
        this.noProposal = false;
        if (!this.requestor.isIgnored(1)) {
            CompletionProposal proposal = this.createProposal(1, this.actualCompletionPosition);
            proposal.setModelElement((IModelElement)field);
            proposal.setName(name);
            proposal.setCompletion(elementName.toCharArray());
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(rel);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private void reportKeyword(String name) {
        this.noProposal = false;
        if (!this.requestor.isIgnored(2)) {
            CompletionProposal proposal = this.createProposal(2, this.actualCompletionPosition);
            proposal.setName(name.toCharArray());
            proposal.setCompletion(name.toCharArray());
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(--this.relevanceKeyword);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private class CompletionMixinMethodRequestor
    implements IMixinSearchRequestor {
        private String lastParent = null;
        private List group = new ArrayList();
        private int relevance = 0;
        private final RubyMixinClass klass;

        public CompletionMixinMethodRequestor(RubyMixinClass klass) {
            this.klass = klass;
        }

        public void acceptResult(IRubyMixinElement element) {
            if (element instanceof RubyMixinMethod) {
                RubyMixinMethod method = (RubyMixinMethod)element;
                String parent = method.getSelfType().getKey();
                if (this.lastParent == null || !this.lastParent.equals(parent)) {
                    this.flush();
                    this.lastParent = parent;
                }
                this.group.add(method);
            }
        }

        public void flush() {
            if (this.group.size() > 0) {
                RubyMixinMethod[] mixinMethods = this.group.toArray(new RubyMixinMethod[this.group.size()]);
                List allSourceMethods = RubyModelUtils.getAllSourceMethods(mixinMethods, this.klass);
                IMethod[] methods = allSourceMethods.toArray(new IMethod[allSourceMethods.size()]);
                Arrays.sort(methods, RubyCompletionEngine.this.modelElementComparator);
                int j = 0;
                while (j < methods.length) {
                    RubyCompletionEngine.this.reportMethod(methods[j], 100000 + this.relevance);
                    ++j;
                }
                this.group.clear();
            }
            --this.relevance;
        }
    }
}

