/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.console.ui;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.dltk.console.IScriptInterpreter;
import org.eclipse.dltk.console.ScriptConsolePrompt;
import org.eclipse.dltk.console.ui.IScriptConsoleFactory;
import org.eclipse.dltk.console.ui.ScriptConsole;
import org.eclipse.dltk.console.ui.ScriptConsoleFactoryBase;
import org.eclipse.dltk.javascript.console.JavaScriptConsoleUtil;
import org.eclipse.dltk.javascript.console.JavaScriptInterpreter;
import org.eclipse.dltk.javascript.internal.console.ui.JavaScriptConsole;
import org.eclipse.dltk.javascript.internal.debug.ui.JavaScriptDebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class JavaScriptConsoleFactory
extends ScriptConsoleFactoryBase
implements IScriptConsoleFactory {
    protected IPreferenceStore getPreferenceStore() {
        return JavaScriptDebugUIPlugin.getDefault().getPreferenceStore();
    }

    protected ScriptConsolePrompt makeInvitation() {
        IPreferenceStore store = this.getPreferenceStore();
        return new ScriptConsolePrompt(store.getString("tclconsole.new_invitation"), store.getString("tclconsole.continue_invitation"));
    }

    protected JavaScriptConsole makeConsole(JavaScriptInterpreter interpreter, String id) {
        JavaScriptConsole console = new JavaScriptConsole(interpreter, id);
        console.setPrompt(this.makeInvitation());
        return console;
    }

    private JavaScriptConsole createConsoleInstance(IScriptInterpreter interpreter, String id) {
        if (interpreter == null) {
            try {
                id = "default";
                interpreter = new JavaScriptInterpreter();
                JavaScriptConsoleUtil.runDefaultTclInterpreter((JavaScriptInterpreter)((JavaScriptInterpreter)interpreter));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.makeConsole((JavaScriptInterpreter)interpreter, id);
    }

    protected ScriptConsole createConsoleInstance() {
        return this.createConsoleInstance(null, null);
    }

    public void openConsole(IScriptInterpreter interpreter, String id, ILaunch launch) {
        this.registerAndOpenConsole(this.createConsoleInstance(interpreter, id));
    }
}

