/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.ui.wizards;

import java.util.Observable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.python.internal.ui.PythonUI;
import org.eclipse.dltk.python.internal.ui.preferences.PythonBuildPathsBlock;
import org.eclipse.dltk.python.internal.ui.wizards.PythonWizardMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.ui.wizards.NewElementWizard;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.dltk.ui.wizards.ProjectWizardSecondPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class PythonProjectCreationWizard
extends NewElementWizard
implements INewWizard,
IExecutableExtension {
    private ProjectWizardFirstPage fFirstPage;
    private ProjectWizardSecondPage fSecondPage;
    private IConfigurationElement fConfigElement;

    public PythonProjectCreationWizard() {
        this.setDefaultPageImageDescriptor(DLTKPluginImages.DESC_WIZBAN_NEWPRJ);
        this.setDialogSettings(DLTKUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(PythonWizardMessages.ProjectCreationWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new ProjectWizardFirstPage(){
            PythonInterpreterGroup fInterpreterGroup;

            protected void createInterpreterGroup(Composite parent) {
                this.fInterpreterGroup = new PythonInterpreterGroup(parent);
            }

            protected Observable getInterpreterGroupObservable() {
                return this.fInterpreterGroup;
            }

            protected boolean supportInterpreter() {
                return true;
            }

            protected IInterpreterInstall getInterpreter() {
                return this.fInterpreterGroup.getSelectedInterpreter();
            }

            protected void handlePossibleInterpreterChange() {
                this.fInterpreterGroup.handlePossibleInterpreterChange();
            }

            protected boolean interpeterRequired() {
                return false;
            }

            final class PythonInterpreterGroup
            extends ProjectWizardFirstPage.AbstractInterpreterGroup {
                public PythonInterpreterGroup(Composite composite) {
                    super((ProjectWizardFirstPage)this, composite);
                }

                protected String getCurrentLanguageNature() {
                    return "org.eclipse.dltk.python.core.nature";
                }

                protected String getIntereprtersPreferencePageId() {
                    return "org.eclipse.dltk.python.preferences.interpreters";
                }
            }
        };
        this.fFirstPage.setTitle(PythonWizardMessages.ProjectCreationWizardFirstPage_title);
        this.fFirstPage.setDescription(PythonWizardMessages.ProjectCreationWizardFirstPage_description);
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new ProjectWizardSecondPage(this.fFirstPage){

            protected BuildpathsBlock createBuildpathBlock(IStatusChangeListener listener) {
                return new PythonBuildPathsBlock((IRunnableContext)new BusyIndicatorRunnableContext(), listener, 0, this.useNewSourcePage(), null);
            }

            protected String getScriptNature() {
                return "org.eclipse.dltk.python.core.nature";
            }

            protected IPreferenceStore getPreferenceStore() {
                return PythonUI.getDefault().getPreferenceStore();
            }
        };
        this.addPage((IWizardPage)this.fSecondPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fSecondPage.getScriptProject().getProject());
        }
        return res;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public IModelElement getCreatedElement() {
        return DLTKCore.create((IProject)this.fFirstPage.getProjectHandle());
    }
}

