/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.parsers;

import org.antlr.runtime.Token;
import org.eclipse.dltk.ast.DLTKToken;

public class DLTKTokenConverter {
    String content;
    CodeModel model;

    public DLTKTokenConverter(char[] content0) {
        this.content = new String(content0);
        this.model = new CodeModel(this.content);
    }

    public DLTKToken convert(Token token) {
        if (token == null) {
            DLTKToken t = new DLTKToken(0, "");
            t.setLine(1);
            return t;
        }
        int line = token.getLine() - 1;
        if (line < 0) {
            line = 0;
        }
        int[] bounds = this.model.getBounds(line);
        DLTKToken t = new DLTKToken(token.getType(), token.getText());
        int offset = token.getCharPositionInLine();
        if (offset < 0) {
            offset = 0;
        }
        t.setColumn(bounds[0] + offset);
        t.setLine(line);
        return t;
    }

    public int convert(int line, int offset) {
        int[] bounds = this.model.getBounds(line - 1);
        return bounds[0] + offset;
    }

    public int length() {
        return this.content.length();
    }

    private static class CodeModel {
        private String[] codeLines;
        private int[] codeLineLengths;

        public CodeModel(String code) {
            this.codeLines = code.split("\n");
            int count = this.codeLines.length;
            this.codeLineLengths = new int[count];
            int sum = 0;
            int i = 0;
            while (i < count) {
                this.codeLineLengths[i] = sum;
                sum += this.codeLines[i].length() + 1;
                ++i;
            }
        }

        public int[] getBounds(int lineNumber) {
            String codeLine = this.codeLines[lineNumber];
            int start = this.codeLineLengths[lineNumber];
            int end = start + codeLine.length();
            return new int[]{start, end};
        }
    }
}

