/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.dbgp.DbgpSessionIdGenerator;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptDebugThreadConfigurator;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.internal.launching.InterpreterMessages;
import org.eclipse.dltk.launching.AbstractInterpreterRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.launching.debug.DbgpInterpreterConfig;
import org.eclipse.dltk.launching.debug.DebuggingEngineManager;
import org.eclipse.dltk.launching.debug.IDebuggingEngine;

public abstract class DebuggingEngineRunner
extends AbstractInterpreterRunner {
    public static final String LAUNCH_ATTR_DEBUGGING_ENGINE_ID = "debugging_engine_id";
    public static final String OVERRIDE_EXE = "OVERRIDE_EXE";

    protected String getSessionId(ILaunchConfiguration configuration) throws CoreException {
        return DbgpSessionIdGenerator.generate();
    }

    protected IScriptDebugTarget addDebugTarget(ILaunch launch, IDbgpService dbgpService) throws CoreException {
        ScriptDebugTarget target = new ScriptDebugTarget(this.getDebugModelId(), dbgpService, this.getSessionId(launch.getLaunchConfiguration()), launch, null);
        launch.addDebugTarget((IDebugTarget)target);
        return target;
    }

    public DebuggingEngineRunner(IInterpreterInstall install) {
        super(install);
    }

    protected void initializeLaunch(ILaunch launch, InterpreterConfig config, PreferencesLookupDelegate delegate) throws CoreException {
        IDbgpService service = DLTKDebugPlugin.getDefault().getDbgpService();
        if (!service.available()) {
            this.abort(InterpreterMessages.errDbgpServiceNotAvailable, null);
        }
        IScriptDebugTarget target = this.addDebugTarget(launch, service);
        String qualifier = this.getDebugPreferenceQualifier();
        target.toggleGlobalVariables(delegate.getBoolean(qualifier, this.showGlobalVarsPreferenceKey()));
        target.toggleClassVariables(delegate.getBoolean(qualifier, this.showClassVarsPreferenceKey()));
        target.toggleLocalVariables(delegate.getBoolean(qualifier, this.showLocalVarsPreferenceKey()));
        launch.setAttribute("org.eclipse.debug.core.capture_output", Boolean.FALSE.toString());
        launch.setAttribute(LAUNCH_ATTR_DEBUGGING_ENGINE_ID, this.getDebuggingEngineId());
        DbgpInterpreterConfig dbgpConfig = new DbgpInterpreterConfig(config);
        dbgpConfig.setSessionId(target.getSessionId());
        dbgpConfig.setPort(service.getPort());
        dbgpConfig.setHost(this.getBindAddress());
    }

    private String getBindAddress() {
        return DLTKDebugPlugin.getDefault().getBindAddress();
    }

    protected abstract InterpreterConfig addEngineConfig(InterpreterConfig var1, PreferencesLookupDelegate var2, ILaunch var3) throws CoreException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(InterpreterMessages.DebuggingEngineRunner_launching, 5);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            try {
                PreferencesLookupDelegate prefDelegate = this.createPreferencesLookupDelegate(launch);
                this.initializeLaunch(launch, config, prefDelegate);
                InterpreterConfig newConfig = this.addEngineConfig(config, prefDelegate, launch);
                IProcess process = null;
                try {
                    DebugEventHelper.fireExtendedEvent((Object)newConfig, (int)1);
                    monitor.subTask(InterpreterMessages.DebuggingEngineRunner_running);
                    process = this.rawRun(launch, newConfig);
                }
                catch (CoreException e) {
                    this.abort(InterpreterMessages.errDebuggingEngineNotStarted, e);
                }
                monitor.worked(4);
                this.waitDebuggerConnected(process, launch, monitor);
            }
            catch (CoreException e) {
                launch.terminate();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        monitor.done();
    }

    protected String[] renderCommandLine(InterpreterConfig config) {
        String exe = (String)config.getProperty(OVERRIDE_EXE);
        if (exe != null) {
            return config.renderCommandLine(this.getInstall().getEnvironment(), exe);
        }
        return config.renderCommandLine(this.getInstall());
    }

    protected IScriptDebugThreadConfigurator createThreadConfigurator() {
        return null;
    }

    protected void waitDebuggerConnected(IProcess debuggingProcess, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        int timeout = configuration.getAttribute("dbpg_waiting_timeout", 0);
        ScriptDebugTarget target = (ScriptDebugTarget)launch.getDebugTarget();
        IScriptDebugThreadConfigurator configurator = this.createThreadConfigurator();
        if (configurator != null) {
            target.setScriptDebugThreadConfigurator(configurator);
        }
        target.setProcess(debuggingProcess);
        try {
            int all = 0;
            while (timeout == 0 || all < timeout) {
                if (!(target.isInitialized() || target.isTerminated() || monitor.isCanceled() || debuggingProcess != null && debuggingProcess.isTerminated())) {
                    Thread.sleep(100L);
                    all += 100;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
        if (!target.isInitialized()) {
            if (debuggingProcess != null && debuggingProcess.canTerminate()) {
                debuggingProcess.terminate();
            }
            this.abort(InterpreterMessages.errDebuggingEngineNotConnected, null);
        }
    }

    public String getDebugModelId() {
        return ScriptDebugManager.getInstance().getDebugModelByNature(this.getInstall().getNatureId());
    }

    public IDebuggingEngine getDebuggingEngine() {
        return DebuggingEngineManager.getInstance().getDebuggingEngine(this.getDebuggingEngineId());
    }

    protected String showGlobalVarsPreferenceKey() {
        return "dbgp_show_scope_global";
    }

    protected String showClassVarsPreferenceKey() {
        return "dbgp_show_scope_class";
    }

    protected String showLocalVarsPreferenceKey() {
        return "dbgp_show_scope_local";
    }

    protected abstract String getDebuggingEngineId();

    protected PreferencesLookupDelegate createPreferencesLookupDelegate(ILaunch launch) throws CoreException {
        IScriptProject sProject = ScriptRuntime.getScriptProject(launch.getLaunchConfiguration());
        return new PreferencesLookupDelegate(sProject.getProject());
    }

    protected abstract String getDebugPreferenceQualifier();

    protected abstract String getDebuggingEnginePreferenceQualifier();

    protected abstract String getLogFileNamePreferenceKey();

    protected String getLogFileName(PreferencesLookupDelegate delegate, String sessionId) {
        IEnvironment env;
        String qualifier = this.getDebuggingEnginePreferenceQualifier();
        String keyValue = delegate.getString(qualifier, this.getLogFileNamePreferenceKey());
        Map logFileNames = EnvironmentPathUtils.decodePaths((String)keyValue);
        String pathString = (String)logFileNames.get(env = this.getInstall().getEnvironment());
        if (pathString != null && pathString.length() > 0) {
            return pathString;
        }
        return null;
    }
}

