/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor.semantic.highlighting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.internal.ui.editor.SemanticHighlightingManager;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.Highlighting;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingPresenter;
import org.eclipse.jface.text.Position;

public class SemanticUpdateWorker
extends ASTVisitor {
    private final List newPositions = new ArrayList();
    private int oldPositionCount = 0;
    private SemanticHighlightingManager.HighlightedPosition[] oldPositions;
    private SemanticHighlightingPresenter presenter;
    private Highlighting[] highlightings;
    private static final boolean DEBUG = false;

    protected void addHighlightedPosition(int start, int end, int highlightingIndex) {
        int len = end - start;
        Highlighting hl = this.highlightings[highlightingIndex];
        int i = 0;
        while (i < this.oldPositions.length) {
            SemanticHighlightingManager.HighlightedPosition p = this.oldPositions[i];
            if (p != null && p.isEqual(start, len, hl)) {
                this.oldPositions[i] = null;
                --this.oldPositionCount;
                return;
            }
            ++i;
        }
        SemanticHighlightingManager.HighlightedPosition hp = this.presenter.createHighlightedPosition(start, len, hl);
        this.newPositions.add(hp);
    }

    public List getNewPositions() {
        return this.newPositions;
    }

    public void setPresenter(SemanticHighlightingPresenter presenter) {
        this.presenter = presenter;
    }

    public void setHighlightings(Highlighting[] highlightings) {
        this.highlightings = highlightings;
    }

    public void setOldPositions(List oldPositions) {
        this.oldPositionCount = oldPositions.size();
        this.oldPositions = oldPositions.toArray(new SemanticHighlightingManager.HighlightedPosition[this.oldPositionCount]);
    }

    public List getOldPositions() {
        ArrayList<SemanticHighlightingManager.HighlightedPosition> result = new ArrayList<SemanticHighlightingManager.HighlightedPosition>(this.oldPositionCount);
        int i = 0;
        int size = this.oldPositions.length;
        while (i < size) {
            SemanticHighlightingManager.HighlightedPosition p = this.oldPositions[i];
            if (p != null) {
                result.add(p);
            }
            ++i;
        }
        return result;
    }

    public void checkNewPositionOrdering() {
        if (this.newPositions.isEmpty()) {
            return;
        }
        Collections.sort(this.newPositions, new Comparator(){

            public int compare(Object o1, Object o2) {
                Position p1 = (Position)o1;
                Position p2 = (Position)o2;
                return p1.getOffset() - p2.getOffset();
            }
        });
        Position previous = null;
        Iterator i = this.newPositions.iterator();
        while (i.hasNext()) {
            Position current = (Position)i.next();
            if (previous != null && previous.getOffset() + previous.getLength() > current.getOffset()) {
                i.remove();
                continue;
            }
            previous = current;
        }
    }
}

