/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.model.internal;

import org.eclipse.dltk.ruby.core.model.IElement;
import org.eclipse.dltk.ruby.core.model.IMethod;
import org.eclipse.dltk.ruby.core.model.IModel;
import org.eclipse.dltk.ruby.core.model.IType;
import org.eclipse.dltk.ruby.core.model.ITypeFragment;
import org.eclipse.dltk.ruby.core.model.IVariable;

public abstract class ModelElementKindSwitch {
    public void visit(IElement element) {
        int id = element.getElementKind().getId();
        switch (id) {
            case 101: {
                this.visitModel((IModel)element);
                break;
            }
            case 104: {
                this.visitClass((IType)element);
                break;
            }
            case 105: {
                this.visitMixin((IType)element);
                break;
            }
            case 106: {
                this.visitClassFragment((ITypeFragment)element);
                break;
            }
            case 107: {
                this.visitMixinFragment((ITypeFragment)element);
                break;
            }
            case 103: {
                this.visitMethod((IMethod)element);
                break;
            }
            default: {
                if (id >= 0 && id <= 100) {
                    this.visitVariable((IVariable)element);
                    break;
                }
                this.visitUnknown(element);
            }
        }
    }

    protected void visitGeneral(IElement element) {
    }

    protected void visitUnknown(IElement element) {
        this.visitGeneral(element);
    }

    protected void visitVariable(IVariable element) {
        this.visitGeneral(element);
    }

    protected void visitMethod(IMethod element) {
        this.visitGeneral(element);
    }

    protected void visitMixinFragment(ITypeFragment element) {
        this.visitGeneral(element);
    }

    protected void visitClassFragment(ITypeFragment element) {
        this.visitGeneral(element);
    }

    protected void visitMixin(IType element) {
        this.visitGeneral(element);
    }

    protected void visitClass(IType element) {
        this.visitGeneral(element);
    }

    protected void visitModel(IModel element) {
        this.visitGeneral(element);
    }
}

