/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.mixin;

import java.util.ArrayList;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.ruby.ast.RubyAliasExpression;
import org.eclipse.dltk.ruby.core.model.FakeMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinAlias;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinVariable;

public class AliasedRubyMixinMethod
extends RubyMixinMethod {
    private final RubyMixinAlias alias;

    public AliasedRubyMixinMethod(RubyMixinModel model, RubyMixinAlias alias) {
        super(model, alias.getKey());
        this.alias = alias;
        RubyAliasExpression node = alias.getAlias();
        String newName = node.getNewValue();
        int length = node.sourceEnd() - node.sourceStart();
        FakeMethod fakeMethod = new FakeMethod((ModelElement)alias.getSourceModule(), newName, node.sourceStart(), length, node.sourceStart(), length);
        IMethod[] sourceMethods2 = RubyMixinMethod.getSourceMethods(model, alias.getOldKey());
        if (sourceMethods2.length == 1 && sourceMethods2[0] != null) {
            IMethod method = sourceMethods2[0];
            try {
                fakeMethod.setFlags(method.getFlags());
                fakeMethod.setParameters(method.getParameters());
                fakeMethod.setParameterInitializers(method.getParameterInitializers());
            }
            catch (ModelException modelException) {}
        }
        this.setSourceMethods(new IMethod[]{fakeMethod});
    }

    public String getName() {
        return this.alias.getNewName();
    }

    public RubyMixinVariable[] getVariables() {
        ArrayList<IRubyMixinElement> result = new ArrayList<IRubyMixinElement>();
        IMixinElement mixinElement = this.model.getRawModel().get(this.alias.getOldKey());
        IMixinElement[] children = mixinElement.getChildren();
        int i = 0;
        while (i < children.length) {
            IRubyMixinElement element = this.model.createRubyElement(children[i]);
            if (element instanceof RubyMixinVariable) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new RubyMixinVariable[result.size()]);
    }
}

