/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import com.xored.org.mozilla.javascript.CompilerEnvirons;
import com.xored.org.mozilla.javascript.ErrorReporter;
import com.xored.org.mozilla.javascript.EvaluatorException;
import com.xored.org.mozilla.javascript.IXMLCallback;
import com.xored.org.mozilla.javascript.Parser;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.Highlighting;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.PositionUpdater;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingPresenter;
import org.eclipse.dltk.javascript.internal.ui.text.Token;
import org.eclipse.dltk.javascript.internal.ui.text.XMLTokenizer;

final class JavaScriptPositionUpdater
extends PositionUpdater {
    HashSet currentPositions = new HashSet();

    JavaScriptPositionUpdater() {
    }

    List calculateNewPositions(ISourceModule ast, final SemanticHighlightingPresenter presenter, final Highlighting[] highlightings) {
        final ArrayList result = new ArrayList();
        try {
            char[] sourceAsCharArray = ast.getSourceAsCharArray();
            Parser p = new Parser(new CompilerEnvirons(), new ErrorReporter(){

                public void error(String message, String sourceName, int line, String lineSource, int offset) {
                }

                public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    return null;
                }

                public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                }
            });
            try {
                p.setXMLCallback(new IXMLCallback(){

                    public void xmlTokenStart(int offset, String tagName, int cursor) {
                        int i = cursor - offset + 1;
                        if (tagName.length() != i) {
                            StringBuffer copy = new StringBuffer();
                            int a = 0;
                            while (a < tagName.length()) {
                                char c = tagName.charAt(a);
                                if (c == '\n') {
                                    copy.append("  ");
                                } else {
                                    copy.append(c);
                                }
                                ++a;
                            }
                            tagName = copy.toString();
                        }
                        XMLTokenizer r = new XMLTokenizer(new StringReader(tagName));
                        List l = r.getRegions();
                        int a = 0;
                        while (a < l.size()) {
                            Token object = (Token)l.get(a);
                            if (object.context == "5") {
                                result.add(presenter.createHighlightedPosition(offset - 1 + object.start, object.textLength, highlightings[0]));
                            } else if (object.context == "28") {
                                result.add(presenter.createHighlightedPosition(offset - 1 + object.start, object.textLength, highlightings[1]));
                            } else if (object.context == "16" || object.context == "8" || object.context == "17") {
                                result.add(presenter.createHighlightedPosition(offset - 1 + object.start, object.textLength, highlightings[2]));
                            } else {
                                String cfr_ignored_0 = object.context;
                            }
                            ++a;
                        }
                    }
                });
                p.parse((Reader)new CharArrayReader(sourceAsCharArray), ((Object)((Object)this)).toString(), 0);
            }
            catch (IOException iOException) {}
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return result;
    }

    public PositionUpdater.UpdateResult reconcile(ISourceModule ast, SemanticHighlightingPresenter presenter, Highlighting[] highlightings, List currentPositions) {
        this.currentPositions = new HashSet(currentPositions);
        List calculateNewPositions = this.calculateNewPositions(ast, presenter, highlightings);
        Iterator it = calculateNewPositions.iterator();
        ArrayList addedPositions = new ArrayList();
        HashSet removed = new HashSet(currentPositions);
        while (it.hasNext()) {
            Object o = it.next();
            if (currentPositions.contains(o)) {
                removed.remove(o);
                continue;
            }
            addedPositions.add(o);
        }
        ArrayList removedPositions = new ArrayList(removed);
        this.currentPositions = new HashSet(calculateNewPositions);
        return new PositionUpdater.UpdateResult(addedPositions, removedPositions);
    }
}

