/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerHelper;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerMarker;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerPlugin;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblem;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblemDescription;
import org.eclipse.jface.preference.IPreferenceStore;

public class TclChecker {
    private static final String CHECKING = "checking:";
    private static final String SCANNING = "scanning:";
    private ISourceModule checkingModule;
    private IPreferenceStore store;
    static /* synthetic */ Class class$0;

    protected static IMarker reportErrorProblem(IResource resource, TclCheckerProblem problem, int start, int end) throws CoreException {
        return TclCheckerMarker.setMarker(resource, problem.getLineNumber(), start, end, problem.getDescription().getMessage(), 2, 1);
    }

    protected static IMarker reportWarningProblem(IResource resource, TclCheckerProblem problem, int start, int end) throws CoreException {
        return TclCheckerMarker.setMarker(resource, problem.getLineNumber(), start, end, problem.getDescription().getMessage(), 1, 1);
    }

    public TclChecker(IPreferenceStore store) {
        if (store == null) {
            throw new NullPointerException("store cannot be null");
        }
        this.store = store;
    }

    public boolean canCheck(IEnvironment environment) {
        return TclCheckerHelper.canExecuteTclChecker(this.store, environment);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void check(List sourceModules, IProgressMonitor monitor, OutputStream console, IEnvironment environment) {
        block53: {
            block52: {
                block51: {
                    block50: {
                        if (!this.canCheck(environment)) {
                            throw new IllegalStateException("TclChecker cannot be executed");
                        }
                        arguments = new ArrayList<String>();
                        pathToSource = new HashMap<String, ISourceModule>();
                        moduleToCodeModel = new HashMap<ISourceModule, TclParseUtil.CodeModel>();
                        iterator = sourceModules.iterator();
                        while (true) {
                            block49: {
                                if (!iterator.hasNext()) {
                                    if (arguments.size() != 0) break;
                                    if (monitor == null) return;
                                    monitor.done();
                                    return;
                                }
                                module = (ISourceModule)iterator.next();
                                try {
                                    source = module.getSource();
                                    if (source.length() == 0) continue;
                                    codeModel = new TclParseUtil.CodeModel(source);
                                    moduleToCodeModel.put(module, codeModel);
                                }
                                catch (ModelException e) {
                                    if (!DLTKCore.DEBUG) break block49;
                                    e.printStackTrace();
                                }
                            }
                            location = module.getResource().getLocation();
                            loc = null;
                            if (location == null) {
                                locationURI = module.getResource().getLocationURI();
                                loc = environment.getFile(locationURI).toOSString();
                            } else {
                                loc = location.toOSString();
                            }
                            pathToSource.put(loc, module);
                            arguments.add(loc);
                        }
                        cmdLine = new ArrayList<String>();
                        if (!TclCheckerHelper.passOriginalArguments(this.store, cmdLine, environment) && console != null) {
                            try {
                                console.write("Path to TclChecker is not specified.".getBytes());
                            }
                            catch (IOException e) {
                                if (!DLTKCore.DEBUG) break block50;
                                e.printStackTrace();
                            }
                        }
                    }
                    if ((v0 = TclChecker.class$0) == null) {
                        try {
                            v1 = Class.forName("org.eclipse.dltk.core.environment.IExecutionEnvironment");
                        }
                        catch (ClassNotFoundException v2) {
                            throw new NoClassDefFoundError(v2.getMessage());
                        }
                        v0 = TclChecker.class$0 = v1;
                    }
                    execEnvironment = (IExecutionEnvironment)environment.getAdapter((Class)v0);
                    deployment = execEnvironment.createDeployment();
                    baros = new ByteArrayOutputStream();
                    try {
                        arg = arguments.iterator();
                        while (true) {
                            if (!arg.hasNext()) {
                                baros.close();
                                break;
                            }
                            path = (String)arg.next();
                            baros.write((String.valueOf(path) + "\n").getBytes());
                        }
                    }
                    catch (FileNotFoundException e1) {
                        if (DLTKCore.DEBUG) {
                            e1.printStackTrace();
                        }
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block51;
                        e.printStackTrace();
                    }
                }
                try {
                    pattern = deployment.add((InputStream)new ByteArrayInputStream(baros.toByteArray()), "pattern.txt");
                }
                catch (IOException e1) {
                    if (DLTKCore.DEBUG == false) return;
                    TclCheckerPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.dltk.tcl.tclchecker", "Failed to deploy file list", (Throwable)e1));
                    if (DLTKCore.DEBUG == false) return;
                    e1.printStackTrace();
                    return;
                }
                cmdLine.add("-@");
                cmdLine.add(deployment.getFile(pattern).toOSString());
                input = null;
                checkingFile = null;
                scanned = 0;
                checked = 0;
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("Executing TclChecker...", sourceModules.size() * 2 + 1);
                map = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
                env = new String[map.size()];
                i = 0;
                iterator = map.keySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        ** try [egrp 5[TRYBLOCK] [9 : 723->1474)] { 
lbl100:
                        // 1 sources

                        break;
                    }
                    key = (String)iterator.next();
                    value = (String)map.get(key);
                    env[i] = String.valueOf(key) + "=" + value;
                    ++i;
                }
                {
                    try {
                        monitor.subTask("Launching TclChecker...");
                        process = execEnvironment.exec(cmdLine.toArray(new String[cmdLine.size()]), null, env);
                        monitor.worked(1);
                        input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        line = null;
                        model = null;
                        while (true) {
                            if ((line = input.readLine()) == null) break;
                            if (console != null) {
                                console.write((String.valueOf(line) + "\n").getBytes());
                            }
                            problem = TclCheckerHelper.parseProblem(line);
                            if (monitor.isCanceled()) {
                                process.destroy();
lbl121:
                                // 2 sources

                                while (true) {
                                    var29_35 = null;
                                    break block52;
                                    break;
                                }
                            }
                            if (line.startsWith("scanning:")) {
                                fileName = line.substring("scanning:".length() + 1).trim();
                                fileName = Path.fromOSString((String)fileName).lastSegment();
                                monitor.subTask(MessageFormat.format("TclChecker scanning \"{0}\" ({1} to scan)...", new Object[]{fileName, new Integer(sourceModules.size() - scanned)}));
                                monitor.worked(1);
                                ++scanned;
                            }
                            if (line.startsWith("checking:")) {
                                checkingFile = fileName = line.substring("checking:".length() + 1).trim();
                                this.checkingModule = (ISourceModule)pathToSource.get(checkingFile);
                                if (this.checkingModule == null) {
                                    paths = pathToSource.keySet();
                                    fullPath = null;
                                    iterator = paths.iterator();
                                    while (iterator.hasNext()) {
                                        p = (String)iterator.next();
                                        if (!p.endsWith(fileName)) continue;
                                        if (fullPath != null) {
                                            fullPath = null;
                                            break;
                                        }
                                        fullPath = p;
                                    }
                                    if (fullPath != null) {
                                        this.checkingModule = (ISourceModule)pathToSource.get(fullPath);
                                    }
                                }
                                model = (TclParseUtil.CodeModel)moduleToCodeModel.get(this.checkingModule);
                                fileName = Path.fromOSString((String)fileName).lastSegment();
                                monitor.subTask(MessageFormat.format("TclChecker checking  \"{0}\" ({1} to check)...", new Object[]{fileName, new Integer(sourceModules.size() - checked)}));
                                monitor.worked(1);
                                ++checked;
                            }
                            if (problem == null || checkingFile == null || this.checkingModule == null || model == null) continue;
                            desc = problem.getDescription();
                            bounds = model.getBounds(problem.getLineNumber() - 1);
                            res = this.checkingModule.getResource();
                            if (TclCheckerProblemDescription.isError(desc.getCategory())) {
                                TclChecker.reportErrorProblem(res, problem, bounds[0], bounds[1]);
                                continue;
                            }
                            if (!TclCheckerProblemDescription.isWarning(desc.getCategory())) continue;
                            TclChecker.reportWarningProblem(res, problem, bounds[0], bounds[1]);
                        }
                        errorMessage = new StringBuffer();
                        input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        line = null;
                        do {
                            if ((line = input.readLine()) == null) {
                                error = errorMessage.toString();
                                if (error.length() > 0) {
                                    TclCheckerPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.dltk.tcl.tclchecker", "Error during tcl_checker execution:\n" + error));
                                }
                                break block53;
                            }
                            if (console != null) {
                                console.write((String.valueOf(line) + "\n").getBytes());
                            }
                            errorMessage.append(line).append("\n");
                        } while (!monitor.isCanceled());
                        process.destroy();
                        ** continue;
                    }
                    catch (Exception e) {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                        break block53;
                    }
                }
lbl184:
                // 1 sources

                catch (Throwable var30_41) {
                    var29_36 = null;
                    monitor.done();
                    deployment.dispose();
                    if (input == null) throw var30_41;
                    try {
                        input.close();
                        throw var30_41;
                    }
                    catch (IOException e) {
                        if (DLTKCore.DEBUG == false) throw var30_41;
                        e.printStackTrace();
                    }
                    throw var30_41;
                }
            }
            monitor.done();
            deployment.dispose();
            if (input == null) return;
            ** try [egrp 7[TRYBLOCK] [12 : 1502->1510)] { 
lbl202:
            // 1 sources

            input.close();
            return;
lbl204:
            // 1 sources

            catch (IOException e) {
                if (DLTKCore.DEBUG == false) return;
                e.printStackTrace();
            }
            return;
        }
        var29_37 = null;
        monitor.done();
        deployment.dispose();
        if (input == null) return;
        try {}
        catch (IOException e) {
            if (DLTKCore.DEBUG == false) return;
            e.printStackTrace();
            return;
        }
        input.close();
    }
}

