/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.debug.core.model.IScriptDebugThreadConfigurator;
import org.eclipse.dltk.launching.ExternalDebuggingEngineRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.tcl.activestatedebugger.TclActiveStateDebugThreadConfigurator;
import org.eclipse.dltk.utils.PlatformFileUtils;

public class TclActiveStateDebuggerRunner
extends ExternalDebuggingEngineRunner {
    public static final String ENGINE_ID = "org.eclipse.dltk.tcl.activestatedebugger";
    private static final String ADDRESS_KEY = "-dbgp";
    private static final String SHELL_KEY = "-app-shell";
    private static final String IDE_KEY = "-ide-key";
    private static final String SCRIPT_KEY = "-app-file";
    private static final String LOG_KEY = "-log";
    private static final String LOG_FILE_KEY = "-logfile";
    private static final String ARGS_SEPARATOR = "--";

    public TclActiveStateDebuggerRunner(IInterpreterInstall install) {
        super(install);
    }

    protected InterpreterConfig alterConfig(InterpreterConfig config, PreferencesLookupDelegate delegate) {
        IFileHandle pdxFiles;
        IFileHandle file = this.getDebuggingEnginePath(delegate);
        String exe = this.getInstall().getInstallLocation().toOSString();
        String host = (String)config.getProperty("host");
        String port = (String)config.getProperty("port");
        String sessionId = (String)config.getProperty("sessionId");
        IEnvironment env = this.getInstall().getEnvironment();
        String pathKeyValue = this.getDebuggingPreference(delegate, "debugging_engine_pdx_path");
        String path = (String)EnvironmentPathUtils.decodePaths((String)pathKeyValue).get(env);
        InterpreterConfig newConfig = (InterpreterConfig)config.clone();
        if (path != null && (pdxFiles = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)env, (IPath)new Path(path))).exists()) {
            newConfig.addEnvVar("TCLDEVKIT_LOCAL", pdxFiles.toOSString());
        }
        newConfig.setProperty("OVERRIDE_EXE", (Object)file.toString());
        newConfig.addInterpreterArg(ADDRESS_KEY);
        newConfig.addInterpreterArg(String.valueOf(host) + ':' + port);
        newConfig.addInterpreterArg(SHELL_KEY);
        newConfig.addInterpreterArg(exe);
        newConfig.addInterpreterArg(IDE_KEY);
        newConfig.addInterpreterArg(sessionId);
        String logFileName = this.getLogFileName(delegate, sessionId);
        if (logFileName != null) {
            newConfig.addInterpreterArg(LOG_KEY);
            newConfig.addInterpreterArg(LOG_FILE_KEY);
            newConfig.addInterpreterArg(logFileName);
        }
        newConfig.addInterpreterArg(SCRIPT_KEY);
        List args = config.getScriptArgs();
        newConfig.clearScriptArgs();
        newConfig.addScriptArg(ARGS_SEPARATOR);
        newConfig.addScriptArgs(args);
        return newConfig;
    }

    protected String getDebuggingEngineId() {
        return ENGINE_ID;
    }

    protected String getDebuggingEnginePreferenceKey() {
        return "debugging_engine_path";
    }

    protected String getDebuggingEnginePreferenceQualifier() {
        return ENGINE_ID;
    }

    protected String getDebugPreferenceQualifier() {
        return "org.eclipse.dltk.tcl.debug";
    }

    protected String getLoggingEnabledPreferenceKey() {
        return "enable_logging";
    }

    protected String getLogFileNamePreferenceKey() {
        return "log_file_name";
    }

    protected String getLogFilePathPreferenceKey() {
        return "log_file_path";
    }

    protected IScriptDebugThreadConfigurator createThreadConfigurator() {
        return new TclActiveStateDebugThreadConfigurator();
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        if (code == 500) {
            super.abort("Tcl Debugging Engine is not correctly configured. Path is not specified or not valid. Please configure Tcl Debugging Engine...", exception, code);
        }
        super.abort(message, exception, code);
    }
}

