/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ui.tests.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.ruby.ui.tests.internal.TestUtils;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;

public class PartitioningTest
extends SuiteOfTestCases {
    public PartitioningTest(String name) {
        super(name);
    }

    public void doTest(String data, String partition) throws Exception {
        int startPos = data.indexOf("#$#");
        Assert.isLegal((startPos >= 0 ? 1 : 0) != 0);
        data = String.valueOf(data.substring(0, startPos)) + data.substring(startPos + "#$#".length());
        int endPos = data.indexOf("#$#");
        Assert.isLegal((endPos >= 0 ? 1 : 0) != 0);
        data = String.valueOf(data.substring(0, endPos)) + data.substring(endPos + "#$#".length());
        String test = data.substring(startPos, endPos);
        Document doc = new Document(data);
        TestUtils.installStuff(doc);
        StringBuffer expected = new StringBuffer();
        StringBuffer actual = new StringBuffer();
        int offset = startPos;
        while (offset < endPos) {
            ITypedRegion p2 = TextUtilities.getPartition((IDocument)doc, (String)"__ruby_partitioning", (int)offset, (offset > startPos ? 1 : 0) != 0);
            expected.append(offset);
            expected.append(" ");
            expected.append(partition);
            expected.append("\n");
            actual.append(offset);
            actual.append(" ");
            actual.append(p2.getType());
            actual.append("\n");
            offset = p2.getOffset() + p2.getLength();
            ++offset;
        }
        PartitioningTest.assertEquals((String)("Wrong partition at \"" + test + "\" in doc:\n" + data), (String)expected.toString(), (String)actual.toString());
    }

    public void testCode() throws Exception {
        this.doTest("#$#class Foo; end#$#", "__dftl_partition_content_type");
    }

    public void testString() throws Exception {
        this.doTest("puts #$#\"Hello, world\"#$#, a", "__ruby_string");
    }

    public void testPercentStringAfterPuts() throws Exception {
        this.doTest("puts #$#%s/foo bar boz/#$# / 2", "__ruby_string");
    }

    public void testPercentStringAfterMethodCall() throws Exception {
        this.doTest("def foo(*args); puts(*args); end\nfoo #$#%s/foo bar boz/#$# / 2", "__ruby_string");
    }

    public void testPercentOperatorAfterVariable() throws Exception {
        this.doTest("foo = 20\nfoo #$#%s/foo bar boz/#$# 2", "__ruby_string");
    }

    public void testPercentDoesStartString() throws Exception {
        this.doTest("if a == #$#%s/2/#$# then puts 1 else puts 2 end", "__ruby_string");
    }

    public void testPercentDoesNotStartString() throws Exception {
        this.doTest("puts bar #$#%s/2/#$#\n3", "__ruby_string");
    }

    private void doHereDocTest(String data) throws Exception {
        String s1 = data.replaceAll("[\u00c2\u00b1\u00c3\u00b8\u00e2\u0088\u0091]", "");
        String s2 = data.replaceAll("\u00c2\u00b1", "#$#");
        String s3 = data.replaceAll("\u00c3\u00b8", "#$#");
        String s4 = data.replaceAll("\u00e2\u0088\u0091", "#$#");
        this.doTest(s1, "__ruby_string");
        if (!data.equals(s2)) {
            this.doTest(s2, "__ruby_string");
        }
        if (!data.equals(s3)) {
            this.doTest(s3, "__ruby_string");
        }
        if (!data.equals(s4)) {
            this.doTest(s3, "__ruby_string");
        }
    }

    public void REM_testAllSortsOfHeredocs() throws Exception {
        int x = 0;
        while (x < 6) {
            String minus;
            String string = minus = (x & 1) != 0 ? "-" : "";
            String quote = (x & 6) == 0 ? "" : ((x & 6) == 1 ? "'" : "\"");
            this.doHereDocTest("puts #$#<<" + minus + quote + "HEREDOC" + quote + "#$#, 'blah'\n" + "\u00c2\u00b1one two three\n" + "fourdman five six\n" + "seven eight\n" + "HEREDOC\u00c2\u00b1\n" + "puts ");
            ++x;
        }
    }

    public void REM_testAllSortsOfSequentialHeredocs() throws Exception {
        int x = 0;
        while (x < 6) {
            String minus;
            String string = minus = (x & 1) != 0 ? "-" : "";
            String quote = (x & 6) == 0 ? "" : ((x & 6) == 1 ? "'" : "\"");
            this.doHereDocTest("puts #$#<<" + minus + quote + "HEREDOC" + quote + "#$#, 'blah', \u00c3\u00b8<<-BOO, 123\n" + "\u00c2\u00b1one two three\n" + "fourdman five six\n" + "seven eight\n" + "HEREDOC\u00c2\u00b1\n" + "\u00e2\u0088\u0091sdfsdfdsfsdfsd\n" + "BOO\u00e2\u0088\u0091\n" + "puts 222");
            ++x;
        }
    }

    public void REM_testEmbeddedCode() throws Exception {
        this.doTest("puts \"Press any #{#$#if 2 > 4 then key else reset_button end#$#} to continue\"", "__dftl_partition_content_type");
    }

    public void testBug179488() throws Exception {
        this.doTest("class Test\ndef test(x)\nobj = f($'#$#, x)\nif (obj.class.name == #$#\"Array\") then\n#...\nreturn\nend\n# It's ...\nend", "__dftl_partition_content_type");
        this.doTest("class Test\ndef test(x)\nobj = f($', x)\nif (obj.class.name == #$#\"Array\"#$#) then\n#...\nreturn\nend\n# It's ...\nend", "__ruby_string");
        this.doTest("class Test\ndef test(x)\nobj = f($', x)\nif (obj.class.name == \"Array\"#$#) then\n#$##...\nreturn\nend\n# It's ...\nend", "__dftl_partition_content_type");
        this.doTest("class Test\ndef test(x)\nobj = f($', x)\nif (obj.class.name == \"Array\") then\n#$##...\n#$#return\nend\n# It's ...\nend", "__ruby_comment");
        this.doTest("class Test\ndef test(x)\nobj = f($', x)\nif (obj.class.name == \"Array\") then\n#...\n#$#return\nend\n#$## It's ...\nend", "__dftl_partition_content_type");
        this.doTest("class Test\ndef test(x)\nobj = f($', x)\nif (obj.class.name == \"Array\") then\n#...\nreturn\nend\n#$## It's ...\n#$#end", "__ruby_comment");
        this.doTest("class Test\ndef test(x)\nobj = f($', x)\nif (obj.class.name == \"Array\") then\n#...\nreturn\nend\n# It's ...\n#$#end#$#", "__dftl_partition_content_type");
    }

    public void testBug180370() throws Exception {
        this.doTest("#$## Some metaprogramming to make it rock\n#$#%w{app controllers models helpers views\nspecs spec_models spec_helpers spec_controllers spec_views spec_fixtures\ntests fixtures unit_tests functional_tests integration_tests\npublic stylesheets javascripts images}.each do |item|\n\nmethod_to_eval = <<-EO_METH\ndef #{item}_dir_path\nresolve_path(:#{item})\nend\nEO_METH\nclass_eval(method_to_eval)\nend", "__ruby_comment");
        this.doTest("# Some metaprogramming to make it rock\n#$#%w{app controllers models helpers views\nspecs spec_models spec_helpers spec_controllers spec_views spec_fixtures\ntests fixtures unit_tests functional_tests integration_tests\npublic stylesheets javascripts images}#$#.each do |item|\n\nmethod_to_eval = <<-EO_METH\ndef #{item}_dir_path\nresolve_path(:#{item})\nend\nEO_METH\nclass_eval(method_to_eval)\nend", "__ruby_string");
        this.doTest("# Some metaprogramming to make it rock\n%w{app controllers models helpers views\nspecs spec_models spec_helpers spec_controllers spec_views spec_fixtures\ntests fixtures unit_tests functional_tests integration_tests\npublic stylesheets javascripts images}#$#.each do |item|\n\nmethod_to_eval = <<-EO_METH\ndef #$##{item}_dir_path\nresolve_path(:#{item})\nend\nEO_METH\nclass_eval(method_to_eval)\nend", "__dftl_partition_content_type");
        this.doTest("# Some metaprogramming to make it rock\n%w{app controllers models helpers views\nspecs spec_models spec_helpers spec_controllers spec_views spec_fixtures\ntests fixtures unit_tests functional_tests integration_tests\npublic stylesheets javascripts images}.each do |item|\n\nmethod_to_eval = <<-EO_METH\ndef #$##{item}_dir_path\n#$#resolve_path(:#{item})\nend\nEO_METH\nclass_eval(method_to_eval)\nend", "__ruby_comment");
        this.doTest("# Some metaprogramming to make it rock\n%w{app controllers models helpers views\nspecs spec_models spec_helpers spec_controllers spec_views spec_fixtures\ntests fixtures unit_tests functional_tests integration_tests\npublic stylesheets javascripts images}.each do |item|\n\nmethod_to_eval = <<-EO_METH\ndef #{item}_dir_path\n#$#resolve_path(:#$##{item})\nend\nEO_METH\nclass_eval(method_to_eval)\nend", "__dftl_partition_content_type");
        this.doTest("# Some metaprogramming to make it rock\n%w{app controllers models helpers views\nspecs spec_models spec_helpers spec_controllers spec_views spec_fixtures\ntests fixtures unit_tests functional_tests integration_tests\npublic stylesheets javascripts images}.each do |item|\n\nmethod_to_eval = <<-EO_METH\ndef #{item}_dir_path\nresolve_path(:#$##{item})\n#$#end\nEO_METH\nclass_eval(method_to_eval)\nend", "__ruby_comment");
        this.doTest("# Some metaprogramming to make it rock\n%w{app controllers models helpers views\nspecs spec_models spec_helpers spec_controllers spec_views spec_fixtures\ntests fixtures unit_tests functional_tests integration_tests\npublic stylesheets javascripts images}.each do |item|\n\nmethod_to_eval = <<-EO_METH\ndef #{item}_dir_path\nresolve_path(:#{item})\n#$#end\nEO_METH\nclass_eval(method_to_eval)\nend#$#", "__dftl_partition_content_type");
    }
}

