/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ruby.internal.ui.text.RubyWhitespaceDetector;
import org.eclipse.dltk.ruby.internal.ui.text.RubyWordDetector;
import org.eclipse.dltk.ruby.internal.ui.text.rules.RubyFloatNumberRule;
import org.eclipse.dltk.ruby.internal.ui.text.rules.StartWithRule;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class RubyCodeScanner
extends AbstractScriptScanner {
    private static String[] fgKeywords = new String[]{"alias", "alias_method", "and", "BEGIN", "begin", "break", "case", "class", "def", "defined", "do", "else", "elsif", "END", "end", "ensure", "for", "if", "in", "module", "next", "not", "or", "redo", "rescue", "retry", "return", "super", "then", "undef", "unless", "until", "when", "while", "yield", "private", "protected", "public", "attr", "attr_accessor", "attr_reader", "attr_writer", "include", "require", "extend", "lambda", "proc", "block_given?", "at_exit", "try", "catch", "raise", "throw", "=begin", "=end", "module_function"};
    private static String[] additionalKeywords = new String[]{"initialize", "new", "loop"};
    private static String[] fgPseudoVariables = new String[]{"true", "false", "self", "nil"};
    private static String fgReturnKeyword = "return";
    private static String[] fgTokenProperties = new String[]{"DLTK_single_line_comment", "DLTK_default", "DLTK_keyword", "DLTK_keyword_return", "DLTK_number", "variable", "variable.class", "variable.constant", "variable.global", "variable.instance", "variable.predefined", "variable.pseudo", "ruby.symbols"};

    public RubyCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token keyword = this.getToken("DLTK_keyword");
        Token keywordReturn = this.getToken("DLTK_keyword_return");
        Token other = this.getToken("DLTK_default");
        Token number = this.getToken("DLTK_number");
        Token classVariable = this.getToken("variable.class");
        Token instanceVariable = this.getToken("variable.instance");
        Token pseudoVariable = this.getToken("variable.pseudo");
        Token globalVariable = this.getToken("variable.global");
        rules.add(new WhitespaceRule((IWhitespaceDetector)new RubyWhitespaceDetector()));
        rules.add(new RubyFloatNumberRule((IToken)number));
        rules.add(new StartWithRule((IToken)globalVariable, '$'){
            private char[] addition = new char[]{'=', '-'};

            protected char[] getAdditional() {
                return this.addition;
            }
        });
        WordRule wordRule = new WordRule((IWordDetector)new RubyWordDetector(), (IToken)other);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < fgPseudoVariables.length) {
            wordRule.addWord(fgPseudoVariables[i], (IToken)pseudoVariable);
            ++i;
        }
        wordRule.addWord(fgReturnKeyword, (IToken)keywordReturn);
        rules.add(wordRule);
        rules.add(new StartWithRule((IToken)instanceVariable, '@', true));
        rules.add(new StartWithRule((IToken)classVariable, "@@".toCharArray()));
        Token symbols = this.getToken("ruby.symbols");
        rules.add(new StartWithRule((IToken)symbols, ':', true));
        this.setDefaultReturnToken((IToken)other);
        return rules;
    }
}

