/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ui.tests.dialogs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.BuildpathModifierQueries;
import org.eclipse.dltk.tcl.ui.tests.dialogs.NewProjectWizardTest;
import org.eclipse.dltk.ui.tests.ScriptProjectHelper;

public class NewEmptyProjectWizardTest
extends NewProjectWizardTest {
    public static final Class THIS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.tcl.ui.tests.dialogs.NewEmptyProjectWizardTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public NewEmptyProjectWizardTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fProject = fTestSetup.getWorkspaceProject();
        this.testProjectIsOnBuildpath(true);
    }

    public void testCreateNormalFolderOnProject() throws CoreException, InvocationTargetException, InterruptedException {
        super.testCreateNormalFolderOnProject();
        IFolder folder = this.getNormalFolderCreationQuery().getCreatedFolder();
        NewEmptyProjectWizardTest.assertTrue((boolean)BuildpathModifier.isExcluded((IResource)folder, (IScriptProject)this.fProject));
    }

    public void testCreateSourceFolderOnProjectWithProjAsRoot() throws CoreException, InvocationTargetException, InterruptedException {
        BuildpathModifierQueries.ICreateFolderQuery folderQuery = this.getSourceFolderCreationQuery();
        IProjectFragment root = (IProjectFragment)this.executeOperation(10, null, folderQuery, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getUnderlyingResource().exists());
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getElementName().equals(this.fSubFolder));
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(true);
        NewEmptyProjectWizardTest.assertTrue((boolean)BuildpathModifier.isExcluded((IResource)this.fProject.getProject().findMember(root.getPath().removeFirstSegments(1)), (IScriptProject)this.fProject));
        this.validateBuildpath();
    }

    public void testCreateSourceFolderOnProject() throws CoreException, InvocationTargetException, InterruptedException {
        super.testCreateSourceFolderOnProject();
        IFolder folder = this.getSourceFolderCreationQuery().getCreatedFolder();
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)folder.getFullPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(false);
    }

    public void testCreateSourceFolderOnFragRootWithProjAsRoot() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment parentRoot = (IProjectFragment)this.executeOperation(0, this.getFolderHandle((IPath)new Path(this.fNormalFolder)), null, null);
        NewEmptyProjectWizardTest.assertTrue((parentRoot != null ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(true);
        BuildpathModifierQueries.ICreateFolderQuery folderQuery = new BuildpathModifierQueries.ICreateFolderQuery(){

            public boolean doQuery() {
                return true;
            }

            public boolean isSourceFolder() {
                return true;
            }

            public IFolder getCreatedFolder() {
                return NewEmptyProjectWizardTest.this.getFolderHandle(new Path(NewEmptyProjectWizardTest.this.fNormalFolder).append(NewEmptyProjectWizardTest.this.fSubFolder));
            }
        };
        IProjectFragment root = (IProjectFragment)this.executeOperation(10, null, folderQuery, null);
        this.testProjectIsOnBuildpath(true);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getUnderlyingResource().exists());
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testCreateSourceFolderOnFragRoot() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment parentRoot = (IProjectFragment)this.executeOperation(0, this.getFolderHandle((IPath)new Path(this.fNormalFolder)), null, null);
        this.testProjectIsOnBuildpath(true);
        BuildpathModifierQueries.ICreateFolderQuery folderQuery = new BuildpathModifierQueries.ICreateFolderQuery(){

            public boolean doQuery() {
                return true;
            }

            public boolean isSourceFolder() {
                return true;
            }

            public IFolder getCreatedFolder() {
                return NewEmptyProjectWizardTest.this.getFolderHandle(new Path(NewEmptyProjectWizardTest.this.fNormalFolder).append(NewEmptyProjectWizardTest.this.fSubFolder));
            }
        };
        IProjectFragment root = (IProjectFragment)this.executeOperation(10, null, folderQuery, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getUnderlyingResource().exists());
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getUnderlyingResource().getParent().equals((Object)parentRoot.getUnderlyingResource()));
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(false);
        this.validateBuildpath();
    }

    public void testCreateNormalFolderOnFragRootWithProjAsRoot() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = (IProjectFragment)this.executeOperation(0, this.getFolderHandle((IPath)new Path(this.fNormalFolder)), null, null);
        BuildpathModifierQueries.ICreateFolderQuery folderQuery = new BuildpathModifierQueries.ICreateFolderQuery(){

            public boolean doQuery() {
                return true;
            }

            public boolean isSourceFolder() {
                return false;
            }

            public IFolder getCreatedFolder() {
                return NewEmptyProjectWizardTest.this.getFolderHandle(new Path(NewEmptyProjectWizardTest.this.fNormalFolder).append(NewEmptyProjectWizardTest.this.fSubFolder));
            }
        };
        IFolder folder = (IFolder)this.executeOperation(10, null, folderQuery, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)folder.getParent().equals((Object)root.getUnderlyingResource()));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testCreateSourceFolderOnFrag() throws CoreException, InvocationTargetException, InterruptedException {
        Path srcPath = new Path("src");
        IProjectFragment parentRoot = (IProjectFragment)this.executeOperation(0, this.getFolderHandle((IPath)srcPath), null, null);
        IFolder fragmentFolder = this.getFolderHandle(srcPath.append(this.fNormalFolder));
        NewEmptyProjectWizardTest.assertTrue((boolean)fragmentFolder.getParent().equals((Object)parentRoot.getUnderlyingResource()));
        this.testProjectIsOnBuildpath(true);
        BuildpathModifierQueries.ICreateFolderQuery folderQuery = new BuildpathModifierQueries.ICreateFolderQuery((IPath)srcPath){
            private final /* synthetic */ IPath val$srcPath;
            {
                this.val$srcPath = iPath;
            }

            public boolean doQuery() {
                return true;
            }

            public boolean isSourceFolder() {
                return true;
            }

            public IFolder getCreatedFolder() {
                return NewEmptyProjectWizardTest.this.getFolderHandle(this.val$srcPath.append(NewEmptyProjectWizardTest.this.fNormalFolder).append(NewEmptyProjectWizardTest.this.fSubFolder));
            }
        };
        IProjectFragment root = (IProjectFragment)this.executeOperation(10, null, folderQuery, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getUnderlyingResource().exists());
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getUnderlyingResource().getParent().equals((Object)fragmentFolder));
        this.testProjectIsOnBuildpath(false);
        this.validateBuildpath();
    }

    public void testCreateSourceFolderOnFragWithProjAsRoot() throws CoreException, InvocationTargetException, InterruptedException {
        super.testCreateSourceFolderOnFrag();
        this.testProjectIsOnBuildpath(false);
    }

    public void testCreateNormalFolderOnFrag() throws CoreException, InvocationTargetException, InterruptedException {
        super.testCreateNormalFolderOnFrag();
        this.testProjectIsOnBuildpath(false);
    }

    public void testCreateNormalFolderOnFragWithProjAsRoot() throws CoreException, InvocationTargetException, InterruptedException {
        Path srcPath = new Path("src");
        IProjectFragment parentRoot = (IProjectFragment)this.executeOperation(0, this.getFolderHandle((IPath)srcPath), null, null);
        IFolder fragmentFolder = this.getFolderHandle(srcPath.append(this.fNormalFolder));
        NewEmptyProjectWizardTest.assertTrue((boolean)fragmentFolder.getParent().equals((Object)parentRoot.getUnderlyingResource()));
        this.testProjectIsOnBuildpath(true);
        BuildpathModifierQueries.ICreateFolderQuery folderQuery = new BuildpathModifierQueries.ICreateFolderQuery((IPath)srcPath){
            private final /* synthetic */ IPath val$srcPath;
            {
                this.val$srcPath = iPath;
            }

            public boolean doQuery() {
                return true;
            }

            public boolean isSourceFolder() {
                return false;
            }

            public IFolder getCreatedFolder() {
                return NewEmptyProjectWizardTest.this.getFolderHandle(this.val$srcPath.append(NewEmptyProjectWizardTest.this.fNormalFolder).append(NewEmptyProjectWizardTest.this.fSubFolder));
            }
        };
        IFolder folder = (IFolder)this.executeOperation(10, null, folderQuery, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)folder.getParent().equals((Object)fragmentFolder));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testAddProjectToBPAndKeepDefaultOutputLocation() throws CoreException, InvocationTargetException, InterruptedException {
        this.testRemoveProjectToBPAndKeepDefaultOutputLocation();
        IPath[] paths = this.getPaths();
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(this.fProject.getPath(), paths, null));
        IScriptProject project = (IScriptProject)this.executeOperation(0, this.fProject, null, null);
        paths = this.getPaths();
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(this.fProject.getPath(), paths, null));
        NewEmptyProjectWizardTest.assertTrue((boolean)project.equals(this.fProject));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testAddNormalFolderToBP() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        int numberOfEntries = this.fProject.getRawBuildpath().length;
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        int newNumberOfEntries = this.fProject.getRawBuildpath().length;
        NewEmptyProjectWizardTest.assertTrue((numberOfEntries == newNumberOfEntries ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        this.testProjectIsOnBuildpath(false);
        this.validateBuildpath();
    }

    public void testAddNormalFolderToBPWithProjAsRoot() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        int numberOfEntries = this.fProject.getRawBuildpath().length;
        IFolder folder = this.getFolderHandle((IPath)new Path(this.fNormalFolder));
        IPath[] paths = this.getPaths();
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(folder.getFullPath(), paths, null));
        IProjectFragment root = (IProjectFragment)this.executeOperation(0, folder, null, null);
        paths = this.getPaths();
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(folder.getFullPath(), this.getPaths(), null));
        int newNumberOfEntries = this.fProject.getRawBuildpath().length;
        NewEmptyProjectWizardTest.assertTrue((numberOfEntries + 1 == newNumberOfEntries ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testAddNestedNormalFolderToBP() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IFolder cpFolder = this.getFolderHandle((IPath)new Path(this.fNormalFolder));
        IProjectFragment root = (IProjectFragment)this.executeOperation(0, cpFolder, null, null);
        IFolder folder = this.getFolderHandle(cpFolder.getProjectRelativePath().append(this.fSubFolder));
        IScriptFolder fragment = root.getScriptFolder(folder.getName());
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int nrExcluded = entry.getExclusionPatterns().length;
        folder = (IFolder)this.executeOperation(2, fragment, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)folder.getFullPath().equals((Object)fragment.getPath()));
        entry = root.getRawBuildpathEntry();
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        NewEmptyProjectWizardTest.assertTrue((nrExcluded + 1 == exclusionPatterns.length ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), exclusionPatterns, null));
        IProjectFragment newRoot = (IProjectFragment)this.executeOperation(0, folder, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)newRoot.getPath().equals((Object)folder.getFullPath()));
        entry = root.getRawBuildpathEntry();
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(folder.getName()), entry.getExclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)folder.getFullPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testAddNestedNormalFolderToBPWithProjAsRoot() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IFolder cpFolder = this.getFolderHandle((IPath)new Path(this.fNormalFolder));
        IProjectFragment root = (IProjectFragment)this.executeOperation(0, cpFolder, null, null);
        IFolder folder = this.getFolderHandle(cpFolder.getProjectRelativePath().append(this.fSubFolder));
        IScriptFolder fragment = root.getScriptFolder(folder.getName());
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int nrExcluded = entry.getExclusionPatterns().length;
        this.executeOperation(2, fragment, null, null);
        entry = root.getRawBuildpathEntry();
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        NewEmptyProjectWizardTest.assertTrue((nrExcluded + 1 == exclusionPatterns.length ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), exclusionPatterns, null));
        this.executeOperation(0, folder, null, null);
        entry = root.getRawBuildpathEntry();
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(folder.getName()), entry.getExclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)folder.getFullPath(), (IScriptProject)this.fProject, (int)3) == null ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(false);
        this.validateBuildpath();
    }

    public void testAddPackageToBP() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment parentRoot = this.createFragmentRootAndKeepProjAsRoot();
        this.getFolderHandle(parentRoot.getPath().removeFirstSegments(1).append(this.fSubFolder));
        IScriptFolder fragment = parentRoot.getScriptFolder(this.fSubFolder);
        IBuildpathEntry entry = parentRoot.getRawBuildpathEntry();
        int nrExclusions = entry.getExclusionPatterns().length;
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getExclusionPatterns(), null));
        IProjectFragment root = (IProjectFragment)this.executeOperation(0, fragment, null, null);
        entry = parentRoot.getRawBuildpathEntry();
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getExclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((entry.getExclusionPatterns().length - 1 == nrExclusions ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        this.testProjectIsOnBuildpath(false);
        this.validateBuildpath();
    }

    public void testAddPackageToBPWithProjAsRoot() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment parentRoot = this.createFragmentRootAndKeepProjAsRoot();
        this.getFolderHandle(parentRoot.getPath().removeFirstSegments(1).append(this.fSubFolder));
        IScriptFolder fragment = parentRoot.getScriptFolder(this.fSubFolder);
        IBuildpathEntry entry = parentRoot.getRawBuildpathEntry();
        int nrExclusions = entry.getExclusionPatterns().length;
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getExclusionPatterns(), null));
        IProjectFragment root = (IProjectFragment)this.executeOperation(0, fragment, null, null);
        entry = parentRoot.getRawBuildpathEntry();
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getExclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((entry.getExclusionPatterns().length - 1 == nrExclusions ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testAddArchiveFileToBP() throws InvocationTargetException, InterruptedException, CoreException, IOException {
        super.testAddArchiveFileToBP();
        this.testProjectIsOnBuildpath(false);
    }

    public void testAddJarFileToBPWithProjAsRoot() throws InvocationTargetException, InterruptedException, CoreException {
        IProjectFragment parentRoot = this.createFragmentRootAndKeepProjAsRoot();
        IPath libraryPath = parentRoot.getPath().append("archive.zip");
        IProjectFragment root = ScriptProjectHelper.addLibrary((IScriptProject)this.fProject, (IPath)libraryPath);
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        IFile zipFile = (IFile)this.executeOperation(1, root, null, null);
        zipFile.create(null, false, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)zipFile.getFileExtension().equals("zip"));
        NewEmptyProjectWizardTest.assertTrue((boolean)BuildpathModifier.isArchive((IFile)zipFile, (IScriptProject)this.fProject));
        NewEmptyProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)zipFile.getFullPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        root = (IProjectFragment)this.executeOperation(13, zipFile, null, null);
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testAddJarFileToBPWithProjAsRootAndParent() throws InvocationTargetException, InterruptedException, CoreException {
        IProjectFragment parentRoot = BuildpathModifier.getFragmentRoot((IResource)this.fProject.getUnderlyingResource(), (IScriptProject)this.fProject, null);
        IPath libraryPath = parentRoot.getPath().append("archive.zip");
        IProjectFragment root = ScriptProjectHelper.addLibrary((IScriptProject)this.fProject, (IPath)libraryPath);
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        IFile zipFile = (IFile)this.executeOperation(1, root, null, null);
        zipFile.create(null, false, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)zipFile.getFileExtension().equals("zip"));
        NewEmptyProjectWizardTest.assertTrue((boolean)BuildpathModifier.isArchive((IFile)zipFile, (IScriptProject)this.fProject));
        NewEmptyProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)zipFile.getFullPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        root = (IProjectFragment)this.executeOperation(13, zipFile, null, null);
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testAddJarFileToBPWithProjWithProjAsParentButRemovedAsRoot() throws InvocationTargetException, InterruptedException, CoreException {
        IProjectFragment parentRoot = BuildpathModifier.getFragmentRoot((IResource)this.fProject.getUnderlyingResource(), (IScriptProject)this.fProject, null);
        IPath libraryPath = parentRoot.getPath().append("archive.zip");
        IProjectFragment root = ScriptProjectHelper.addLibrary((IScriptProject)this.fProject, (IPath)libraryPath);
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        IFile zipFile = (IFile)this.executeOperation(1, root, null, null);
        zipFile.create(null, false, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)zipFile.getFileExtension().equals("zip"));
        NewEmptyProjectWizardTest.assertTrue((boolean)BuildpathModifier.isArchive((IFile)zipFile, (IScriptProject)this.fProject));
        NewEmptyProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)zipFile.getFullPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        root = (IProjectFragment)this.executeOperation(13, zipFile, null, null);
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testAddZipFileToBP() throws InvocationTargetException, InterruptedException, CoreException {
        super.testAddZipFileToBP();
        this.testProjectIsOnBuildpath(false);
    }

    public void testAddZipFileToBPWithProjAsRoot() throws InvocationTargetException, InterruptedException, CoreException {
        IProjectFragment parentRoot = this.createFragmentRootAndKeepProjAsRoot();
        IPath libraryPath = parentRoot.getPath().append("archive.zip");
        IProjectFragment root = ScriptProjectHelper.addLibrary((IScriptProject)this.fProject, (IPath)libraryPath);
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        IFile zipFile = (IFile)this.executeOperation(1, root, null, null);
        zipFile.create(null, false, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)zipFile.getFileExtension().equals("zip"));
        NewEmptyProjectWizardTest.assertTrue((boolean)BuildpathModifier.isArchive((IFile)zipFile, (IScriptProject)this.fProject));
        NewEmptyProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)zipFile.getFullPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        root = (IProjectFragment)this.executeOperation(13, zipFile, null, null);
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testAddZipFileToBPWithProjAsRootAndParent() throws InvocationTargetException, InterruptedException, CoreException {
        IProjectFragment parentRoot = BuildpathModifier.getFragmentRoot((IResource)this.fProject.getUnderlyingResource(), (IScriptProject)this.fProject, null);
        IPath libraryPath = parentRoot.getPath().append("archive.zip");
        IProjectFragment root = ScriptProjectHelper.addLibrary((IScriptProject)this.fProject, (IPath)libraryPath);
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        IFile zipFile = (IFile)this.executeOperation(1, root, null, null);
        zipFile.create(null, false, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)zipFile.getFileExtension().equals("zip"));
        NewEmptyProjectWizardTest.assertTrue((boolean)BuildpathModifier.isArchive((IFile)zipFile, (IScriptProject)this.fProject));
        NewEmptyProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)zipFile.getFullPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        root = (IProjectFragment)this.executeOperation(13, zipFile, null, null);
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testAddZipFileToBPWithProjWithProjAsParentButRemovedAsRoot() throws InvocationTargetException, InterruptedException, CoreException {
        IProjectFragment parentRoot = BuildpathModifier.getFragmentRoot((IResource)this.fProject.getUnderlyingResource(), (IScriptProject)this.fProject, null);
        IPath libraryPath = parentRoot.getPath().append("archive.zip");
        IProjectFragment root = ScriptProjectHelper.addLibrary((IScriptProject)this.fProject, (IPath)libraryPath);
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        IFile zipFile = (IFile)this.executeOperation(1, root, null, null);
        zipFile.create(null, false, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)zipFile.getFileExtension().equals("zip"));
        NewEmptyProjectWizardTest.assertTrue((boolean)BuildpathModifier.isArchive((IFile)zipFile, (IScriptProject)this.fProject));
        NewEmptyProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)zipFile.getFullPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        root = (IProjectFragment)this.executeOperation(13, zipFile, null, null);
        NewEmptyProjectWizardTest.assertFalse((BuildpathModifier.getBuildpathEntryFor((IPath)root.getPath(), (IScriptProject)this.fProject, (int)1) == null ? 1 : 0) != 0);
        this.validateBuildpath();
    }

    public void testAddInterpreterEnvironmentToBP() throws InvocationTargetException, InterruptedException, CoreException {
        super.testAddInterpreterEnvironmentToBP();
        this.testProjectIsOnBuildpath(true);
    }

    public void testAddIncludedPackageToBP() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment parentRoot = this.includePackageAndKeepProjAsRoot();
        IScriptFolder fragment = parentRoot.getScriptFolder(this.fSubFolder);
        IBuildpathEntry entry = parentRoot.getRawBuildpathEntry();
        int nrInclusions = entry.getInclusionPatterns().length;
        int nrExclusions = entry.getExclusionPatterns().length;
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getExclusionPatterns(), null));
        IProjectFragment root = (IProjectFragment)this.executeOperation(0, fragment, null, null);
        entry = parentRoot.getRawBuildpathEntry();
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(root.getElementName()), entry.getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(root.getElementName()), entry.getExclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((entry.getInclusionPatterns().length + 1 == nrInclusions ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((entry.getExclusionPatterns().length - 1 == nrExclusions ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        this.testProjectIsOnBuildpath(false);
        this.validateBuildpath();
    }

    public void testAddIncludedPackageToBPWithProjAsRoot() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment parentRoot = this.includePackageAndKeepProjAsRoot();
        IScriptFolder fragment = parentRoot.getScriptFolder(this.fSubFolder);
        IBuildpathEntry entry = parentRoot.getRawBuildpathEntry();
        int nrInclusions = entry.getInclusionPatterns().length;
        int nrExclusions = entry.getExclusionPatterns().length;
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getExclusionPatterns(), null));
        IProjectFragment root = (IProjectFragment)this.executeOperation(0, fragment, null, null);
        entry = parentRoot.getRawBuildpathEntry();
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(root.getElementName()), entry.getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(root.getElementName()), entry.getExclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((entry.getInclusionPatterns().length + 1 == nrInclusions ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((entry.getExclusionPatterns().length - 1 == nrExclusions ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)root.getParent().equals(this.fProject));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testAddExcludedPackageToBP() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment parentRoot = this.excludePackageAndKeepProjAsRoot();
        IScriptFolder fragment = parentRoot.getScriptFolder(this.fSubFolder);
        IBuildpathEntry entry = parentRoot.getRawBuildpathEntry();
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getExclusionPatterns(), null));
        IPath[] paths = this.getPaths();
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath(), paths, null));
        IProjectFragment root = (IProjectFragment)this.executeOperation(0, fragment, null, null);
        paths = this.getPaths();
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath(), paths, null));
        parentRoot = this.fProject.findProjectFragment(parentRoot.getPath());
        entry = parentRoot.getRawBuildpathEntry();
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(root.getElementName()), entry.getExclusionPatterns(), null));
        this.testProjectIsOnBuildpath(false);
        this.validateBuildpath();
    }

    public void testAddExcludedPackageToBPWithProjAsRoot() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment parentRoot = this.excludePackageAndKeepProjAsRoot();
        IScriptFolder fragment = parentRoot.getScriptFolder(this.fSubFolder);
        IBuildpathEntry entry = parentRoot.getRawBuildpathEntry();
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(fragment.getElementName()), entry.getExclusionPatterns(), null));
        IProjectFragment root = (IProjectFragment)this.executeOperation(0, fragment, null, null);
        parentRoot = this.fProject.findProjectFragment(parentRoot.getPath());
        entry = parentRoot.getRawBuildpathEntry();
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(root.getElementName()), entry.getExclusionPatterns(), null));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testRemoveProjectToBPAndKeepDefaultOutputLocation() throws CoreException, InvocationTargetException, InterruptedException {
        this.executeOperation(1, this.fProject, null, null);
        this.testProjectIsOnBuildpath(false);
        this.validateBuildpath();
    }

    public void testRemoveFromBP() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        int before = this.fProject.getRawBuildpath().length;
        IFolder folder = this.getFolderHandle((IPath)new Path(this.fNormalFolder));
        IProjectFragment root = this.addToBuildpath((IPath)new Path(this.fNormalFolder));
        this.executeOperation(1, root, null, null);
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(folder.getFullPath(), this.getPaths(), null));
        int after = this.fProject.getRawBuildpath().length;
        NewEmptyProjectWizardTest.assertTrue((before - 1 == after ? 1 : 0) != 0);
        this.validateBuildpath();
        this.testProjectIsOnBuildpath(false);
    }

    public void testRemoveFromBPWithProjAsRoot() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        int before = this.fProject.getRawBuildpath().length;
        IProjectFragment root = this.createFragmentRootAndKeepProjAsRoot();
        IFolder folder = (IFolder)this.executeOperation(1, root, null, null);
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(folder.getFullPath(), this.getPaths(), null));
        int after = this.fProject.getRawBuildpath().length;
        NewEmptyProjectWizardTest.assertTrue((before == after ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testRemoveZipFileFromBP() throws InvocationTargetException, InterruptedException, CoreException {
        super.testRemoveZipFileFromBP();
        this.testProjectIsOnBuildpath(false);
    }

    public void testRemoveArchiveFileFromBP() throws InvocationTargetException, InterruptedException, CoreException, IOException {
        super.testRemoveArchiveFileFromBP();
        this.testProjectIsOnBuildpath(false);
    }

    public void testRemoveInterpreterEnvironmentFromBP() throws InvocationTargetException, InterruptedException, CoreException {
        super.testRemoveInterpreterEnvironmentFromBP();
        this.testProjectIsOnBuildpath(true);
    }

    public void testIncludePackageOnProject() throws ModelException, InvocationTargetException, InterruptedException {
        IScriptFolder fragment = this.createFragmentOnProject();
        IProjectFragment root = this.getProjectRoot(fragment.getUnderlyingResource());
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        fragment = (IScriptFolder)this.executeOperation(8, fragment, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testExcludePackageOnProject() throws ModelException, InvocationTargetException, InterruptedException {
        IScriptFolder fragment = this.createFragmentOnProject();
        IProjectFragment root = this.getProjectRoot(fragment.getUnderlyingResource());
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        IFolder excludedFolder = (IFolder)this.executeOperation(2, fragment, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(excludedFolder.getProjectRelativePath(), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testExcludeIncludedPackageOnProject() throws ModelException, InvocationTargetException, InterruptedException {
        IScriptFolder fragment = this.createFragmentOnProject();
        IProjectFragment root = this.getProjectRoot(fragment.getUnderlyingResource());
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        fragment = (IScriptFolder)this.executeOperation(8, fragment, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int nrIncluded = entry.getInclusionPatterns().length;
        int nrExcluded = entry.getExclusionPatterns().length;
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        IFolder excludedFolder = (IFolder)this.executeOperation(2, fragment, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(excludedFolder.getProjectRelativePath(), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getInclusionPatterns().length + 1 == nrIncluded ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getExclusionPatterns().length - 1 == nrExcluded ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testIncludeExcludedFolderOnProject() throws ModelException, CoreException, InvocationTargetException, InterruptedException {
        IScriptFolder fragment = this.createFragmentOnProject();
        IProjectFragment root = this.getProjectRoot(fragment.getUnderlyingResource());
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        IFolder excludedFolder = (IFolder)this.executeOperation(2, fragment, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(excludedFolder.getProjectRelativePath(), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int nrIncluded = entry.getInclusionPatterns().length;
        int nrExcluded = entry.getExclusionPatterns().length;
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        fragment = (IScriptFolder)this.executeOperation(8, excludedFolder, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getInclusionPatterns().length - 1 == nrIncluded ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((root.getRawBuildpathEntry().getExclusionPatterns().length + 1 == nrExcluded ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testRemoveInclusionOnProject() throws ModelException, InvocationTargetException, InterruptedException {
        IScriptFolder fragment = this.createFragmentOnProject();
        IProjectFragment root = this.getProjectRoot(fragment.getUnderlyingResource());
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        fragment = (IScriptFolder)this.executeOperation(8, fragment, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        fragment = (IScriptFolder)this.executeOperation(9, fragment, null, null);
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testRemoveExclusionOnProject() throws ModelException, InvocationTargetException, InterruptedException {
        IScriptFolder fragment = this.createFragmentOnProject();
        IProjectFragment root = this.getProjectRoot(fragment.getUnderlyingResource());
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        IFolder excludedFolder = (IFolder)this.executeOperation(2, fragment, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(excludedFolder.getProjectRelativePath(), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        fragment = (IScriptFolder)this.executeOperation(3, excludedFolder, null, null);
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testEditFiltersOnProject() throws ModelException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.getProjectRoot(this.fProject.getUnderlyingResource());
        final IScriptFolder includedPackage = root.getScriptFolder(this.fSubFolder);
        final IScriptFolder excludedPackage = root.getScriptFolder(String.valueOf(this.fSubFolder) + "2");
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(new Path(includedPackage.getElementName()).addTrailingSeparator(), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(new Path(excludedPackage.getElementName()).addTrailingSeparator(), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        BuildpathModifierQueries.IInclusionExclusionQuery query = new BuildpathModifierQueries.IInclusionExclusionQuery(){

            public boolean doQuery(BPListElement element, boolean focusOnExcluded) {
                return true;
            }

            public IPath[] getInclusionPattern() {
                return new IPath[]{new Path(includedPackage.getElementName()).addTrailingSeparator()};
            }

            public IPath[] getExclusionPattern() {
                return new IPath[]{new Path(excludedPackage.getElementName()).addTrailingSeparator()};
            }
        };
        IScriptProject jProject = (IScriptProject)this.executeOperation(4, this.fProject, null, query);
        NewEmptyProjectWizardTest.assertTrue((boolean)jProject.equals(this.fProject));
        root = this.getProjectRoot(this.fProject.getUnderlyingResource());
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(new Path(includedPackage.getElementName()).addTrailingSeparator(), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(new Path(excludedPackage.getElementName()).addTrailingSeparator(), root.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.validateBuildpath();
    }

    public void testResetFiltersOnProject() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.createFragmentRootAndKeepProjAsRoot();
        IScriptFolder includedPackage = root.getScriptFolder(this.fSubFolder);
        IScriptFolder excludedPackage = root.getScriptFolder(String.valueOf(this.fSubFolder) + "2");
        IFolder subSrcFolder = this.getFolderHandle(root.getPath().removeFirstSegments(1).append(String.valueOf(this.fSubFolder) + "3"));
        this.executeOperation(8, includedPackage, null, null);
        this.executeOperation(8, excludedPackage, null, null);
        this.executeOperation(0, subSrcFolder, null, null);
        int numberOnBP = this.fProject.getRawBuildpath().length;
        this.executeOperation(7, root, null, null);
        IProjectFragment projectRoot = this.getProjectRoot(this.fProject.getUnderlyingResource());
        IBuildpathEntry entry = projectRoot.getRawBuildpathEntry();
        NewEmptyProjectWizardTest.assertTrue((entry.getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((entry.getExclusionPatterns().length == 1 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(root.getPath(), this.getPaths(), null));
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(subSrcFolder.getFullPath(), this.getPaths(), null));
        NewEmptyProjectWizardTest.assertTrue((this.fProject.getRawBuildpath().length == numberOnBP ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testIncludeFileOnProject() throws ModelException, InvocationTargetException, InterruptedException {
        IProjectFragment projectRoot = this.getProjectRoot(this.fProject.getCorrespondingResource());
        IScriptFolder fragment = projectRoot.createScriptFolder("", false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        cu = (ISourceModule)this.executeOperation(8, cu, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(cu.getPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getInclusionPatterns(), null));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testExcludeFileOnProject() throws ModelException, InvocationTargetException, InterruptedException {
        IProjectFragment projectRoot = this.getProjectRoot(this.fProject.getCorrespondingResource());
        IScriptFolder fragment = projectRoot.createScriptFolder("", false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        IFile excludedFile = (IFile)this.executeOperation(2, cu, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(excludedFile.getFullPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testIncludeExcludedFileOnProject() throws ModelException, InvocationTargetException, InterruptedException {
        IProjectFragment projectRoot = this.getProjectRoot(this.fProject.getCorrespondingResource());
        IScriptFolder fragment = projectRoot.createScriptFolder("", false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        IFile excludedFile = (IFile)this.executeOperation(2, cu, null, null);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(excludedFile.getFullPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getExclusionPatterns(), null));
        cu = (ISourceModule)this.executeOperation(8, excludedFile, null, null);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(cu.getPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getInclusionPatterns(), null));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testExcludeIncludedFileOnProject() throws ModelException, InvocationTargetException, InterruptedException {
        IProjectFragment projectRoot = this.getProjectRoot(this.fProject.getCorrespondingResource());
        IScriptFolder fragment = projectRoot.createScriptFolder("", false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        cu = (ISourceModule)this.executeOperation(8, cu, null, null);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(cu.getPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getInclusionPatterns(), null));
        IFile excludedFile = (IFile)this.executeOperation(2, cu, null, null);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(excludedFile.getFullPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testUnincludeFileOnProject() throws ModelException, InvocationTargetException, InterruptedException {
        IProjectFragment projectRoot = this.getProjectRoot(this.fProject.getCorrespondingResource());
        IScriptFolder fragment = projectRoot.createScriptFolder("", false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        cu = (ISourceModule)this.executeOperation(8, cu, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(cu.getPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getInclusionPatterns(), null));
        cu = (ISourceModule)this.executeOperation(9, cu, null, null);
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(cu.getPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getInclusionPatterns(), null));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testUnexcludeFileOnProject() throws ModelException, InvocationTargetException, InterruptedException {
        IProjectFragment projectRoot = this.getProjectRoot(this.fProject.getCorrespondingResource());
        IScriptFolder fragment = projectRoot.createScriptFolder("", false, null);
        ISourceModule cu = this.createISourceModule("C", fragment);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        IFile excludedFile = (IFile)this.executeOperation(2, cu, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(excludedFile.getFullPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getExclusionPatterns(), null));
        cu = (ISourceModule)this.executeOperation(3, excludedFile, null, null);
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(excludedFile.getFullPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.validateBuildpath();
    }

    public void testIncludeFileWithIncludedFragment() throws ModelException, InvocationTargetException, InterruptedException {
        IProjectFragment projectRoot = this.getProjectRoot(this.fProject.getCorrespondingResource());
        IScriptFolder fragment = this.createFragmentOnProject();
        IProjectFragment root = this.getProjectRoot(fragment.getUnderlyingResource());
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        fragment = (IScriptFolder)this.executeOperation(8, fragment, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        IScriptFolder defaultFragment = projectRoot.createScriptFolder("", false, null);
        ISourceModule cu = this.createISourceModule("C", defaultFragment);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 1 ? 1 : 0) != 0);
        cu = (ISourceModule)this.executeOperation(8, cu, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(cu.getPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 2 ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testExcludeIncludedFileWithIncludedFragment() throws ModelException, InvocationTargetException, InterruptedException {
        IProjectFragment projectRoot = this.getProjectRoot(this.fProject.getCorrespondingResource());
        IScriptFolder fragment = this.createFragmentOnProject();
        IProjectFragment root = this.getProjectRoot(fragment.getUnderlyingResource());
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        fragment = (IScriptFolder)this.executeOperation(8, fragment, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        IScriptFolder defaultFragment = projectRoot.createScriptFolder("", false, null);
        ISourceModule cu = this.createISourceModule("C", defaultFragment);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 1 ? 1 : 0) != 0);
        cu = (ISourceModule)this.executeOperation(8, cu, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(cu.getPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 2 ? 1 : 0) != 0);
        IFile excludedFile = (IFile)this.executeOperation(2, cu, null, null);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 1 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(excludedFile.getProjectRelativePath(), projectRoot.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(excludedFile.getProjectRelativePath(), projectRoot.getRawBuildpathEntry().getExclusionPatterns(), null));
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    public void testUnincludeIncludedFileWithIncludedFragment() throws ModelException, InvocationTargetException, InterruptedException {
        IProjectFragment projectRoot = this.getProjectRoot(this.fProject.getCorrespondingResource());
        IScriptFolder fragment = this.createFragmentOnProject();
        IProjectFragment root = this.getProjectRoot(fragment.getUnderlyingResource());
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 0 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        fragment = (IScriptFolder)this.executeOperation(8, fragment, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(fragment.getPath().removeFirstSegments(1), root.getRawBuildpathEntry().getInclusionPatterns(), null));
        IScriptFolder defaultFragment = projectRoot.createScriptFolder("", false, null);
        ISourceModule cu = this.createISourceModule("C", defaultFragment);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 1 ? 1 : 0) != 0);
        cu = (ISourceModule)this.executeOperation(8, cu, null, null);
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains(cu.getPath().removeFirstSegments(1), projectRoot.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 2 ? 1 : 0) != 0);
        IFile file = (IFile)this.executeOperation(9, cu, null, null);
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getInclusionPatterns().length == 1 ? 1 : 0) != 0);
        NewEmptyProjectWizardTest.assertFalse((boolean)NewEmptyProjectWizardTest.contains(file.getProjectRelativePath(), projectRoot.getRawBuildpathEntry().getInclusionPatterns(), null));
        NewEmptyProjectWizardTest.assertTrue((projectRoot.getRawBuildpathEntry().getExclusionPatterns().length == 0 ? 1 : 0) != 0);
        this.testProjectIsOnBuildpath(true);
        this.validateBuildpath();
    }

    protected IProjectFragment createFragmentRootAndKeepProjAsRoot() throws CoreException, InvocationTargetException, InterruptedException {
        BuildpathModifierQueries.ICreateFolderQuery folderQuery = new BuildpathModifierQueries.ICreateFolderQuery(){

            public boolean doQuery() {
                return true;
            }

            public boolean isSourceFolder() {
                return true;
            }

            public IFolder getCreatedFolder() {
                return NewEmptyProjectWizardTest.this.getFolderHandle((IPath)new Path(NewEmptyProjectWizardTest.this.fSubFolder));
            }
        };
        IProjectFragment root = (IProjectFragment)this.executeOperation(10, null, folderQuery, null);
        return root;
    }

    protected IScriptFolder createFragmentOnProject() throws ModelException {
        IFolder fragmentFolder = this.getFolderHandle((IPath)new Path(this.fNormalFolder));
        IProjectFragment root = this.getProjectRoot((IResource)fragmentFolder);
        IScriptFolder fragment = root.getScriptFolder(fragmentFolder.getName());
        NewEmptyProjectWizardTest.assertTrue((boolean)fragment.exists());
        return fragment;
    }

    protected IProjectFragment includePackageAndKeepProjAsRoot() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.createFragmentRootAndKeepProjAsRoot();
        IFolder folder = this.getFolderHandle(root.getPath().removeFirstSegments(1).append(this.fSubFolder));
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int before = entry.getInclusionPatterns().length;
        this.executeOperation(8, folder, null, null);
        entry = root.getRawBuildpathEntry();
        IPath[] inclusionPatterns = entry.getInclusionPatterns();
        int after = inclusionPatterns.length;
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(folder.getName()), inclusionPatterns, null));
        NewEmptyProjectWizardTest.assertTrue((before + 1 == after ? 1 : 0) != 0);
        return root;
    }

    protected IProjectFragment excludePackageAndKeepProjAsRoot() throws CoreException, InvocationTargetException, InterruptedException {
        IProjectFragment root = this.createFragmentRootAndKeepProjAsRoot();
        IFolder folder = this.getFolderHandle(root.getPath().removeFirstSegments(1).append(this.fSubFolder));
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int before = entry.getExclusionPatterns().length;
        folder = (IFolder)this.executeOperation(2, root.getScriptFolder(folder.getName()), null, null);
        entry = root.getRawBuildpathEntry();
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        int after = exclusionPatterns.length;
        NewEmptyProjectWizardTest.assertTrue((boolean)NewEmptyProjectWizardTest.contains((IPath)new Path(folder.getName()), exclusionPatterns, null));
        NewEmptyProjectWizardTest.assertTrue((before + 1 == after ? 1 : 0) != 0);
        return root;
    }

    protected void testProjectIsOnBuildpath(boolean isOnBuildpath) throws ModelException {
        NewEmptyProjectWizardTest.assertTrue((BuildpathModifier.getBuildpathEntryFor((IPath)this.fProject.getPath(), (IScriptProject)this.fProject, (int)3) != null == isOnBuildpath ? 1 : 0) != 0);
    }
}

