/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ui.tests.wizardapi;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.ui.tests.wizardapi.NewTclProjectWizardPage;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class NewTCLProjectWizardTest
extends TestCase {
    private static final String PROJECT_NAME = "DummyProject";
    private static final String OTHER_PROJECT_NAME = "OtherProject";
    private TestNewScriptProjectWizardPage fWizardPage;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.tcl.ui.tests.wizardapi.NewTCLProjectWizardTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public NewTCLProjectWizardTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(PROJECT_NAME);
        this.fWizardPage = new TestNewScriptProjectWizardPage(root);
        this.fWizardPage.setProjectHandle(project);
    }

    protected void tearDown() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(PROJECT_NAME);
        if (project.exists()) {
            project.delete(true, null);
        }
        if ((project = root.getProject(OTHER_PROJECT_NAME)).exists()) {
            project.delete(true, null);
        }
        super.tearDown();
    }

    private void assertBasicBuildPath(IProject project, IBuildpathEntry[] buildpath) {
        NewTCLProjectWizardTest.assertNotNull((String)"b", (Object)buildpath);
        NewTCLProjectWizardTest.assertTrue((String)"c", (buildpath.length == 1 ? 1 : 0) != 0);
        if (TclUI.getDefault().getPreferenceStore().getBoolean("com.xore.dltk.ui.wizards.srcBinFoldersInNewProjects")) {
            NewTCLProjectWizardTest.assertEquals((String)"e", (Object)buildpath[0].getPath(), (Object)project.getFolder("src").getFullPath());
        } else {
            NewTCLProjectWizardTest.assertEquals((String)"g", (Object)buildpath[0].getPath(), (Object)project.getFullPath());
        }
    }

    public void testBasicSet() throws Exception {
        this.fWizardPage.initBuildPath();
        IProject project = this.fWizardPage.getProjectHandle();
        IBuildpathEntry[] buildpath = this.fWizardPage.getRawBuildPath();
        this.assertBasicBuildPath(project, buildpath);
    }

    public void testBasicCreate() throws Exception {
        IProject project = this.fWizardPage.getProjectHandle();
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(this.fWizardPage.getRunnable());
        op.run(null);
        IScriptProject jproj = this.fWizardPage.getNewScriptProject();
        NewTCLProjectWizardTest.assertEquals((String)"a", (Object)jproj.getProject(), (Object)project);
        IBuildpathEntry[] buildpath = jproj.getRawBuildpath();
        this.assertBasicBuildPath(jproj.getProject(), buildpath);
    }

    public void testProjectChange() throws Exception {
        this.fWizardPage.initBuildPath();
        IProject project = this.fWizardPage.getProjectHandle();
        IBuildpathEntry[] buildpath = this.fWizardPage.getRawBuildPath();
        this.assertBasicBuildPath(project, buildpath);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject otherProject = root.getProject(OTHER_PROJECT_NAME);
        this.fWizardPage.setProjectHandle(otherProject);
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(this.fWizardPage.getRunnable());
        op.run(null);
        IScriptProject jproj = this.fWizardPage.getNewScriptProject();
        NewTCLProjectWizardTest.assertEquals((String)"a", (Object)jproj.getProject(), (Object)otherProject);
        IBuildpathEntry[] buildpath1 = this.fWizardPage.getRawBuildPath();
        this.assertBasicBuildPath(otherProject, buildpath1);
    }

    private void assertUserBuildPath(IProject project, IBuildpathEntry[] buildpath) {
        NewTCLProjectWizardTest.assertNotNull((String)"b", (Object)buildpath);
        NewTCLProjectWizardTest.assertTrue((String)"c", (buildpath.length == 2 ? 1 : 0) != 0);
        NewTCLProjectWizardTest.assertEquals((String)"e", (Object)buildpath[0].getPath(), (Object)project.getFolder("dsrc1").getFullPath());
        NewTCLProjectWizardTest.assertEquals((String)"f", (Object)buildpath[1].getPath(), (Object)project.getFolder("dsrc2").getFullPath());
    }

    public void testUserSet() throws Exception {
        IProject project = this.fWizardPage.getProjectHandle();
        IBuildpathEntry[] entries = new IBuildpathEntry[]{DLTKCore.newSourceEntry((IPath)project.getFolder("dsrc1").getFullPath()), DLTKCore.newSourceEntry((IPath)project.getFolder("dsrc2").getFullPath())};
        this.fWizardPage.setDefaultBuildPath(entries, true);
        this.fWizardPage.initBuildPath();
        IBuildpathEntry[] buildpath = this.fWizardPage.getRawBuildPath();
        this.assertUserBuildPath(project, buildpath);
        this.fWizardPage.setDefaultBuildPath(null, false);
        this.fWizardPage.initBuildPath();
        IBuildpathEntry[] buildpath1 = this.fWizardPage.getRawBuildPath();
        this.assertBasicBuildPath(project, buildpath1);
    }

    public void testUserCreate() throws Exception {
        IProject project = this.fWizardPage.getProjectHandle();
        IBuildpathEntry[] entries = new IBuildpathEntry[]{DLTKCore.newSourceEntry((IPath)project.getFolder("dsrc1").getFullPath()), DLTKCore.newSourceEntry((IPath)project.getFolder("dsrc2").getFullPath())};
        this.fWizardPage.setDefaultBuildPath(entries, true);
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(this.fWizardPage.getRunnable());
        op.run(null);
        IScriptProject jproj = this.fWizardPage.getNewScriptProject();
        NewTCLProjectWizardTest.assertEquals((String)"a", (Object)jproj.getProject(), (Object)project);
        IBuildpathEntry[] buildpath = jproj.getRawBuildpath();
        this.assertUserBuildPath(jproj.getProject(), buildpath);
    }

    public void testReadExisting() throws Exception {
        IProject project = this.fWizardPage.getProjectHandle();
        IBuildpathEntry[] entries = new IBuildpathEntry[]{DLTKCore.newSourceEntry((IPath)project.getFolder("dsrc1").getFullPath()), DLTKCore.newSourceEntry((IPath)project.getFolder("dsrc2").getFullPath())};
        this.fWizardPage.setDefaultBuildPath(entries, true);
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(this.fWizardPage.getRunnable());
        op.run(null);
        IProject proj = this.fWizardPage.getNewScriptProject().getProject();
        this.fWizardPage.setDefaultBuildPath(null, false);
        this.fWizardPage.setProjectHandle(proj);
        this.fWizardPage.initBuildPath();
        IBuildpathEntry[] buildpath1 = this.fWizardPage.getRawBuildPath();
        this.assertUserBuildPath(project, buildpath1);
    }

    public void testExistingOverwrite() throws Exception {
        IProject project = this.fWizardPage.getProjectHandle();
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(this.fWizardPage.getRunnable());
        op.run(null);
        IBuildpathEntry[] entries = new IBuildpathEntry[]{DLTKCore.newSourceEntry((IPath)project.getFolder("dsrc1").getFullPath()), DLTKCore.newSourceEntry((IPath)project.getFolder("dsrc2").getFullPath())};
        this.fWizardPage.setDefaultBuildPath(entries, true);
        WorkspaceModifyDelegatingOperation op1 = new WorkspaceModifyDelegatingOperation(this.fWizardPage.getRunnable());
        op1.run(null);
        IScriptProject jproj = this.fWizardPage.getNewScriptProject();
        IBuildpathEntry[] buildpath1 = jproj.getRawBuildpath();
        this.assertUserBuildPath(project, buildpath1);
    }

    private class TestNewScriptProjectWizardPage
    extends NewTclProjectWizardPage {
        private IProject fNewProject;

        public TestNewScriptProjectWizardPage(IWorkspaceRoot root) {
            super(root, null);
        }

        public void setProjectHandle(IProject newProject) {
            this.fNewProject = newProject;
        }

        protected IPath getLocationPath() {
            return null;
        }

        protected IProject getProjectHandle() {
            return this.fNewProject;
        }

        public void initBuildPath() {
            super.initBuildPaths();
        }
    }
}

