/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ui.tests.wizardapi;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.tcl.internal.ui.preferences.TclBuildPathsBlock;
import org.eclipse.dltk.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewTclProjectWizardPage
extends NewElementWizardPage {
    public static final String TCL_NATURE = "org.eclipse.dltk.tcl.core.nature";
    private static final String PAGE_NAME = "NewScriptProjectWizardPage";
    private WizardNewProjectCreationPage fMainPage;
    private IBuildpathEntry[] fBuildpathEntries;
    private BuildpathsBlock fBuildPathsBlock;
    private boolean fProjectModified;

    public NewTclProjectWizardPage(IWorkspaceRoot root, WizardNewProjectCreationPage mainpage) {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.NewScriptProjectWizardPage_title);
        this.setDescription(NewWizardMessages.NewScriptProjectWizardPage_description);
        this.fMainPage = mainpage;
        IStatusChangeListener listener = new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
                NewTclProjectWizardPage.this.updateStatus(status);
            }
        };
        this.fBuildPathsBlock = new TclBuildPathsBlock((IRunnableContext)new BusyIndicatorRunnableContext(), listener, 0, false, null);
        this.fProjectModified = true;
        this.fBuildpathEntries = null;
    }

    public void setDefaultBuildPath(IBuildpathEntry[] entries, boolean appendDefaultInterpreterEnvironment) {
        if (entries != null && appendDefaultInterpreterEnvironment) {
            IBuildpathEntry[] newEntries = new IBuildpathEntry[entries.length];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            entries = newEntries;
        }
        this.fBuildpathEntries = entries;
        this.setProjectModified();
    }

    public void setProjectModified() {
        this.fProjectModified = true;
    }

    protected IProject getProjectHandle() {
        Assert.isNotNull((Object)this.fMainPage);
        return this.fMainPage.getProjectHandle();
    }

    protected IPath getLocationPath() {
        Assert.isNotNull((Object)this.fMainPage);
        return this.fMainPage.getLocationPath();
    }

    public IScriptProject getNewScriptProject() {
        return DLTKCore.create((IProject)this.getProjectHandle());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(1, false));
        Control control = this.fBuildPathsBlock.createControl(composite);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)composite);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
        this.setControl((Control)composite);
    }

    protected void initBuildPaths() {
        this.fBuildPathsBlock.init(this.getNewScriptProject(), this.fBuildpathEntries);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && (this.fProjectModified || this.isNewProjectHandle())) {
            this.initBuildPaths();
            this.fProjectModified = false;
        }
    }

    private boolean isNewProjectHandle() {
        IProject oldProject = this.fBuildPathsBlock.getScriptProject().getProject();
        return !oldProject.equals((Object)this.getProjectHandle());
    }

    public IBuildpathEntry[] getRawBuildPath() {
        return this.fBuildPathsBlock.getRawBuildPath();
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(NewWizardMessages.NewScriptProjectWizardPage_op_desc, 10);
                if (NewTclProjectWizardPage.this.fProjectModified || NewTclProjectWizardPage.this.isNewProjectHandle()) {
                    NewTclProjectWizardPage.this.initBuildPaths();
                }
                try {
                    try {
                        IPath locationPath = NewTclProjectWizardPage.this.getLocationPath();
                        BuildpathsBlock.createProject((IProject)NewTclProjectWizardPage.this.getProjectHandle(), (URI)(locationPath != null ? URIUtil.toURI((IPath)locationPath) : null), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        TclBuildPathsBlock.addScriptNature((IProject)NewTclProjectWizardPage.this.getProjectHandle(), (IProgressMonitor)new SubProgressMonitor(monitor, 2), (String)NewTclProjectWizardPage.TCL_NATURE);
                        NewTclProjectWizardPage.this.fBuildPathsBlock.configureScriptProject((IProgressMonitor)new SubProgressMonitor(monitor, 6));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
    }
}

