/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.core.BecomeWorkingCopyOperation;
import org.eclipse.dltk.internal.core.CommitWorkingCopyOperation;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.DiscardWorkingCopyOperation;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ReconcileWorkingCopyOperation;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.SourceModuleElementInfo;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;

public class SourceModule
extends AbstractSourceModule
implements ISourceModule {
    private static int nextId = 1;
    private final int id = nextId++;

    public SourceModule(ScriptFolder parent, String name, WorkingCopyOwner owner) {
        super(parent, name, owner, false);
    }

    public void becomeWorkingCopy(IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(this, false, true, null);
        if (perWorkingCopyInfo == null) {
            this.close();
            BecomeWorkingCopyOperation operation = new BecomeWorkingCopyOperation(this, problemRequestor);
            operation.runOperation(monitor);
        }
    }

    public boolean canBeRemovedFromCache() {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBeRemovedFromCache();
    }

    public boolean canBufferBeRemovedFromCache(IBuffer buffer) {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBufferBeRemovedFromCache(buffer);
    }

    public void close() throws ModelException {
        if (this.getPerWorkingCopyInfo() != null) {
            return;
        }
        super.close();
    }

    public void codeComplete(int offset, CompletionRequestor requestor) throws ModelException {
        this.codeComplete(offset, requestor, DefaultWorkingCopyOwner.PRIMARY);
    }

    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner) throws ModelException {
        this.codeComplete(this, offset, requestor, owner);
    }

    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws ModelException {
        CommitWorkingCopyOperation op = new CommitWorkingCopyOperation(this, force);
        op.runOperation(monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws ModelException {
        IModelElement[] elements = new IModelElement[]{this};
        this.getModel().delete(elements, force, monitor);
    }

    public void discardWorkingCopy() throws ModelException {
        DiscardWorkingCopyOperation op = new DiscardWorkingCopyOperation(this);
        op.runOperation(null);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourceModule)) {
            return false;
        }
        return super.equals(obj);
    }

    public boolean exists() {
        if (this.getPerWorkingCopyInfo() != null) {
            return true;
        }
        return super.exists();
    }

    public char[] getFileName() {
        return this.getPath().toOSString().toCharArray();
    }

    public ModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        return ModelManager.getModelManager().getPerWorkingCopyInfo(this, false, false, null);
    }

    public IResource getResource() {
        ProjectFragment root = this.getProjectFragment();
        if (root.isArchive()) {
            return root.getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getElementName()));
    }

    public ISourceModule getWorkingCopy(WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
        SourceModule workingCopy;
        if (!this.isPrimary()) {
            return this;
        }
        ModelManager manager = ModelManager.getModelManager();
        ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy = new SourceModule((ScriptFolder)this.getParent(), this.getElementName(), workingCopyOwner), false, true, null);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation(workingCopy, problemRequestor, null);
        op.runOperation(monitor);
        return workingCopy;
    }

    public boolean hasResourceChanged() {
        if (!this.isWorkingCopy()) {
            return false;
        }
        Object info = ModelManager.getModelManager().getInfo(this);
        if (info == null) {
            return false;
        }
        return ((SourceModuleElementInfo)info).timestamp != this.getResource().getModificationStamp();
    }

    public boolean isWorkingCopy() {
        return !this.isPrimary() || this.getPerWorkingCopyInfo() != null;
    }

    public void makeConsistent(IProgressMonitor monitor) throws ModelException {
        if (this.isConsistent()) {
            return;
        }
        ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
        sourceModuleInfoCache.remove(this);
        this.openWhenClosed(this.createElementInfo(), monitor);
    }

    public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] containers = new IModelElement[]{container};
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getModel().move(elements, containers, null, renamings, replace, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconcile(boolean forceProblemDetection, WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) throws ModelException {
        if (!this.isWorkingCopy()) {
            return;
        }
        if (workingCopyOwner == null) {
            workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        }
        ReconcileWorkingCopyOperation op = new ReconcileWorkingCopyOperation(this, forceProblemDetection, workingCopyOwner);
        ModelManager manager = ModelManager.getModelManager();
        try {
            manager.cacheZipFiles();
            op.runOperation(monitor);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            manager.flushZipFiles();
            throw throwable;
        }
        {
            Object var6_8 = null;
            manager.flushZipFiles();
            return;
        }
    }

    public void rename(String newName, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (newName == null) {
            throw new IllegalArgumentException(Messages.operation_nullName);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] dests = new IModelElement[]{this.getParent()};
        String[] renamings = new String[]{newName};
        this.getModel().rename(elements, dests, renamings, replace, monitor);
    }

    public void save(IProgressMonitor pm, boolean force) throws ModelException {
        if (this.isWorkingCopy()) {
            throw new RuntimeException("not implemented");
        }
        super.save(pm, force);
    }

    protected boolean preventReopen() {
        return super.preventReopen() && this.getPerWorkingCopyInfo() == null;
    }

    protected IProblemReporter getProblemReporter(String natureId) throws CoreException {
        ModelManager.PerWorkingCopyInfo wcInfo = this.getPerWorkingCopyInfo();
        if (wcInfo != null) {
            if (wcInfo.noProblemReporter) {
                return null;
            }
            if (wcInfo.problemReporter != null) {
                return wcInfo.problemReporter;
            }
        }
        return super.getProblemReporter(natureId);
    }

    protected String getNatureId() throws CoreException {
        IResource resource = this.getResource();
        Object lookup = resource == null ? this.getPath() : resource;
        IDLTKLanguageToolkit lookupLanguageToolkit = this.lookupLanguageToolkit(lookup);
        if (lookupLanguageToolkit == null) {
            return null;
        }
        return lookupLanguageToolkit.getNatureId();
    }

    protected void closing(Object info) {
        if (this.getPerWorkingCopyInfo() == null) {
            super.closing(info);
        }
    }

    protected char[] getBufferContent() throws ModelException {
        IFile file = (IFile)this.getResource();
        if (file == null || !file.exists()) {
            return CharOperation.NO_CHAR;
        }
        return Util.getResourceContentsAsCharArray(file);
    }

    protected String getModuleType() {
        return "DLTK Source Module: ";
    }

    protected ISourceModule getOriginalSourceModule() {
        return new SourceModule((ScriptFolder)this.getParent(), this.getElementName(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    protected void updateTimeStamp(SourceModule original) throws ModelException {
        long timeStamp = ((IFile)original.getResource()).getModificationStamp();
        if (timeStamp == -1L) {
            throw new ModelException(new ModelStatus(995));
        }
        ((SourceModuleElementInfo)this.getElementInfo()).timestamp = timeStamp;
    }
}

